/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.isolator.Configuration;
import de.sormuras.junit.platform.isolator.Modules;
import de.sormuras.junit.platform.isolator.TestMode;
import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import de.sormuras.junit.platform.maven.plugin.JavaOptions;
import de.sormuras.junit.platform.maven.plugin.JavaPatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class JavaExecutor {
    private final JUnitPlatformMojo mojo;
    private final JavaOptions options;
    private final Modules modules;

    JavaExecutor(JUnitPlatformMojo mojo) {
        this.mojo = mojo;
        this.options = mojo.getJavaOptions();
        this.modules = mojo.getProjectModules();
    }

    int evaluate(Configuration configuration) {
        boolean captureIO;
        Path target = Paths.get(configuration.basic().getTargetDirectory(), new String[0]);
        Path cmdPath = target.resolve("console-launcher.cmd.log");
        Path errorPath = target.resolve("console-launcher.err.log");
        Path outputPath = target.resolve("console-launcher.out.log");
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(this.mojo.getMavenProject().getBasedir());
        List<String> cmd = builder.command();
        boolean inheritIO = this.mojo.getJavaOptions().inheritIO;
        boolean bl = captureIO = !inheritIO;
        if (inheritIO) {
            builder.inheritIO();
        } else {
            builder.redirectError(errorPath.toFile());
            builder.redirectOutput(outputPath.toFile());
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        }
        if (this.options.additionalEnvironment != null && !this.options.additionalEnvironment.isEmpty()) {
            builder.environment().putAll(this.options.additionalEnvironment);
        }
        cmd.add(this.mojo.getJavaExecutable());
        this.addJavaOptions(cmd, configuration);
        this.addLauncherOptions(cmd, configuration);
        try {
            Files.createDirectories(target, new FileAttribute[0]);
            Files.write(cmdPath, cmd, new OpenOption[0]);
            if (captureIO) {
                if (Files.notExists(errorPath, new LinkOption[0])) {
                    Files.createFile(errorPath, new FileAttribute[0]);
                }
                if (Files.notExists(outputPath, new LinkOption[0])) {
                    Files.createFile(outputPath, new FileAttribute[0]);
                }
            }
        }
        catch (IOException e) {
            this.mojo.warn("Preparing target path failed: {0} // {1}", target, e);
        }
        if (this.mojo.isDryRun()) {
            this.mojo.info("Dry-run mode is active -- only printing command line", new Object[0]);
            cmd.forEach(x$0 -> this.mojo.info((String)x$0, new Object[0]));
            return 0;
        }
        this.mojo.debug("", new Object[0]);
        this.mojo.debug("Starting process...", new Object[0]);
        cmd.forEach(x$0 -> this.mojo.debug((String)x$0, new Object[0]));
        try {
            Process process = builder.start();
            this.mojo.debug("Process started: {0}", process);
            if (!process.waitFor(this.mojo.getTimeout(), TimeUnit.SECONDS)) {
                int i;
                this.mojo.warn("Global timeout of " + this.mojo.getTimeout() + " second(s) reached.", new Object[0]);
                process.destroy();
                for (i = 10; i > 0 && process.isAlive(); --i) {
                    Thread.sleep(123L);
                }
                if (process.isAlive()) {
                    this.mojo.warn("Killing java process...", new Object[0]);
                    process.destroyForcibly();
                    for (i = 10; i > 0 && process.isAlive(); --i) {
                        Thread.sleep(1234L);
                    }
                }
                return -2;
            }
            int exitValue = process.exitValue();
            if (captureIO) {
                try {
                    Files.readAllLines(outputPath).stream().limit(500L).forEach(exitValue == 0 ? x$0 -> this.mojo.info((String)x$0, new Object[0]) : x$0 -> this.mojo.error((String)x$0, new Object[0]));
                    Files.readAllLines(errorPath).forEach(exitValue == 0 ? x$0 -> this.mojo.warn((String)x$0, new Object[0]) : x$0 -> this.mojo.error((String)x$0, new Object[0]));
                }
                catch (IOException e) {
                    this.mojo.warn("Reading output/error logs failed: {0}", e);
                }
            }
            return exitValue;
        }
        catch (IOException | InterruptedException e) {
            this.mojo.error("Executing process failed: {0}", e);
            return -1;
        }
    }

    private void addJavaOptions(List<String> cmd, Configuration configuration) {
        List<String> overrides = this.options.overrideJavaOptions;
        if (overrides != Collections.EMPTY_LIST) {
            cmd.addAll(overrides);
            return;
        }
        Optional mainModule = this.modules.getMainModuleReference();
        Optional testModule = this.modules.getTestModuleReference();
        cmd.addAll(this.options.additionalOptions);
        if (configuration.basic().isDefaultAssertionStatus()) {
            cmd.add("-enableassertions");
        }
        if (!this.options.encoding.isEmpty()) {
            cmd.add("-Dfile.encoding=" + this.options.encoding);
        }
        if (!"false".equalsIgnoreCase(this.options.debug)) {
            cmd.add("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + (Boolean.parseBoolean(this.options.debug) ? "5005" : this.options.debug));
        }
        if (mainModule.isPresent() || testModule.isPresent()) {
            cmd.add("--module-path");
            cmd.add(this.createPathArgument(configuration));
            cmd.add("--add-modules");
            cmd.add(this.createAddModulesArgument());
            if (mainModule.isPresent() && !testModule.isPresent()) {
                new JavaPatcher(this.mojo, configuration).patch(cmd);
            }
            cmd.add("--module");
            cmd.add("org.junit.platform.console");
        } else {
            cmd.add("-classpath");
            cmd.add(this.createPathArgument(configuration));
            cmd.add("org.junit.platform.console.ConsoleLauncher");
        }
    }

    private void addLauncherOptions(List<String> cmd, Configuration configuration) {
        List<String> overrides = this.options.overrideLauncherOptions;
        if (overrides != Collections.EMPTY_LIST) {
            cmd.addAll(overrides);
            return;
        }
        Configuration.Basic basic = configuration.basic();
        Configuration.Discovery dsc = configuration.discovery();
        if (basic.isFailIfNoTests()) {
            cmd.add("--fail-if-no-tests");
        }
        if (this.mojo.getTweaks().disableAnsi) {
            cmd.add("--disable-ansi-colors");
        }
        cmd.add("--details");
        cmd.add(this.mojo.getTweaks().details);
        cmd.add("--details-theme");
        cmd.add(this.mojo.getTweaks().detailsTheme);
        cmd.add("--reports-dir");
        cmd.add(basic.getTargetDirectory());
        dsc.getFilterTags().forEach(tag -> cmd.add(JavaExecutor.createTagArgument("include", tag)));
        if (this.mojo.getTest() != null) {
            if (this.mojo.getTest().contains("(") || this.mojo.getTest().contains("#")) {
                cmd.add("--select-method=" + this.mojo.getTest());
            } else {
                cmd.add("--select-class=" + this.mojo.getTest());
            }
        } else if (dsc.getFilterClassNamePatterns() != null) {
            dsc.getFilterClassNamePatterns().forEach(it -> cmd.add("--include-classname=" + it));
        }
        dsc.getParameters().forEach((key, value) -> cmd.add(JavaExecutor.createConfigArgument(key, value)));
        Optional mainModule = this.modules.getMainModuleReference();
        Optional testModule = this.modules.getTestModuleReference();
        if (this.mojo.getTest() == null && dsc.getFilterClassNamePatterns() == null) {
            if (testModule.isPresent()) {
                cmd.add("--select-module");
                cmd.add((String)this.modules.getTestModuleName().orElseThrow(AssertionError::new));
            } else if (mainModule.isPresent()) {
                cmd.add("--select-module");
                cmd.add((String)this.modules.getMainModuleName().orElseThrow(AssertionError::new));
            } else {
                cmd.add("--scan-class-path");
            }
        }
        if (this.options.additionalLauncherOptions != null && !this.options.additionalLauncherOptions.isEmpty()) {
            cmd.addAll(this.options.additionalLauncherOptions);
        }
    }

    private String createAddModulesArgument() {
        String value = this.options.addModulesArgument;
        if (value != null && !value.isEmpty()) {
            return value;
        }
        if (this.modules.getMode() == TestMode.MODULAR_PATCHED_TEST_RUNTIME) {
            return (String)this.modules.getMainModuleName().orElseThrow(AssertionError::new);
        }
        return (String)this.modules.getTestModuleName().orElseThrow(AssertionError::new);
    }

    private static String createConfigArgument(String key, String value) {
        return "--config=\"" + key + "\"=\"" + value + "\"";
    }

    private static String createTagArgument(String filter, String tag) {
        return "--" + filter + "-tag=\"" + tag + "\"";
    }

    private String createPathArgument(Configuration configuration) {
        boolean dropMainClasses = this.modules.getMainModuleName().isPresent() && this.modules.getTestModuleName().isPresent() && ((String)this.modules.getTestModuleName().orElseThrow(IllegalStateException::new)).equals(this.modules.getMainModuleName().orElseThrow(IllegalStateException::new));
        return configuration.basic().getPaths().values().stream().flatMap(Collection::stream).filter(path -> !dropMainClasses || !this.isMain(configuration, (String)path)).collect(Collectors.joining(File.pathSeparator));
    }

    private boolean isMain(Configuration configuration, String path) {
        return path.equals(configuration.basic().getTargetMainPath());
    }
}

