/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.tlog.webflux.common;

import com.yomahub.tlog.context.SpanIdGenerator;
import com.yomahub.tlog.core.rpc.TLogLabelBean;
import com.yomahub.tlog.core.rpc.TLogRPCHandler;
import com.yomahub.tlog.utils.LocalhostUtil;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class TLogWebFluxCommon
extends TLogRPCHandler {
    private static final Logger log = LoggerFactory.getLogger(TLogWebFluxCommon.class);
    private static volatile TLogWebFluxCommon tLogWebCommon;
    private static final Integer FIRST;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TLogWebFluxCommon loadInstance() {
        if (tLogWebCommon != null) return tLogWebCommon;
        Class<TLogWebFluxCommon> clazz = TLogWebFluxCommon.class;
        synchronized (TLogWebFluxCommon.class) {
            if (tLogWebCommon != null) return tLogWebCommon;
            tLogWebCommon = new TLogWebFluxCommon();
            // ** MonitorExit[var0] (shouldn't be in output)
            return tLogWebCommon;
        }
    }

    public ServerWebExchange preHandle(ServerWebExchange exchange, String appName) {
        List preIps;
        List preIvkHosts;
        List preIvkApps;
        List spanIds;
        String traceId = null;
        String spanId = null;
        String preIvkApp = null;
        String preIvkHost = null;
        String preIp = null;
        HttpHeaders headers = exchange.getRequest().getHeaders();
        List traceIds = headers.get((Object)"tlogTraceId");
        if (traceIds != null && traceIds.size() > 0) {
            traceId = (String)traceIds.get(FIRST);
        }
        if ((spanIds = headers.get((Object)"tlogSpanId")) != null && spanIds.size() > 0) {
            spanId = (String)spanIds.get(FIRST);
        }
        if ((preIvkApps = headers.get((Object)"preIvkApp")) != null && preIvkApps.size() > 0) {
            preIvkApp = (String)preIvkApps.get(FIRST);
        }
        if ((preIvkHosts = headers.get((Object)"preIvkHost")) != null && preIvkHosts.size() > 0) {
            preIvkHost = (String)preIvkHosts.get(FIRST);
        }
        if ((preIps = headers.get((Object)"preIp")) != null && preIps.size() > 0) {
            preIp = (String)preIps.get(FIRST);
        }
        TLogLabelBean labelBean = new TLogLabelBean(preIvkApp, preIvkHost, preIp, traceId, spanId);
        labelBean.putExtData("exchange", (Object)exchange);
        this.processProviderSide(labelBean);
        if (StringUtils.isNotBlank((CharSequence)labelBean.getTraceId())) {
            Consumer<HttpHeaders> httpHeaders = httpHeader -> {
                httpHeader.set("tlogTraceId", labelBean.getTraceId());
                httpHeader.set("tlogSpanId", SpanIdGenerator.generateNextSpanId());
                httpHeader.set("preIvkApp", appName);
                httpHeader.set("preIvkHost", LocalhostUtil.getHostName());
                httpHeader.set("preIp", LocalhostUtil.getHostIp());
            };
            ServerHttpRequest serverHttpRequest = exchange.getRequest().mutate().headers(httpHeaders).build();
            return exchange.mutate().request(serverHttpRequest).build();
        }
        log.debug("[TLOG]\u672c\u5730threadLocal\u53d8\u91cf\u6ca1\u6709\u6b63\u786e\u4f20\u9012traceId,\u672c\u6b21\u8c03\u7528\u4e0d\u4f20\u9012traceId");
        return exchange;
    }

    static {
        FIRST = 0;
    }
}

