/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import com.xxl.tool.core.AssertTool;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ClassTool {
    private static final Map<Class<?>, Class<?>> primitiveWrapper2TypeMap = new IdentityHashMap(9);
    private static final Map<Class<?>, Class<?>> primitiveType2WrapperMap = new IdentityHashMap(9);

    public static boolean isAssignable(Class<?> superType, Class<?> subType) {
        AssertTool.notNull(superType, "Left-hand side type must not be null");
        AssertTool.notNull(subType, "Right-hand side type must not be null");
        if (superType.isAssignableFrom(subType)) {
            return true;
        }
        if (superType.isPrimitive()) {
            Class<?> resolvedPrimitive = primitiveWrapper2TypeMap.get(subType);
            return superType == resolvedPrimitive;
        }
        Class<?> resolvedWrapper = primitiveType2WrapperMap.get(subType);
        return resolvedWrapper != null && superType.isAssignableFrom(resolvedWrapper);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        AssertTool.notNull(clazz, "Class must not be null");
        AssertTool.notNull(methodName, "Method name must not be null");
        if (paramTypes != null) {
            return ClassTool.getMethodOrNull(clazz, methodName, paramTypes);
        }
        Set<Method> candidates = ClassTool.findMethodCandidatesByName(clazz, methodName);
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        return null;
    }

    private static Method getMethodOrNull(Class<?> clazz, String methodName, Class<?>[] paramTypes) {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static Set<Method> findMethodCandidatesByName(Class<?> clazz, String methodName) {
        Method[] methods;
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates.add(method);
        }
        return candidates;
    }

    static {
        primitiveWrapper2TypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapper2TypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapper2TypeMap.put(Character.class, Character.TYPE);
        primitiveWrapper2TypeMap.put(Double.class, Double.TYPE);
        primitiveWrapper2TypeMap.put(Float.class, Float.TYPE);
        primitiveWrapper2TypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapper2TypeMap.put(Long.class, Long.TYPE);
        primitiveWrapper2TypeMap.put(Short.class, Short.TYPE);
        primitiveWrapper2TypeMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : primitiveWrapper2TypeMap.entrySet()) {
            primitiveType2WrapperMap.put(entry.getValue(), entry.getKey());
        }
    }
}

