/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.response;

import com.xxl.tool.response.Response;
import com.xxl.tool.response.ResponseCode;

public class ResponseBuilder<T> {
    private final Response<T> response = new Response();

    public ResponseBuilder<T> code(int code) {
        this.response.setCode(code);
        return this;
    }

    public ResponseBuilder<T> msg(String msg) {
        this.response.setMsg(msg);
        return this;
    }

    public ResponseBuilder<T> data(T data) {
        this.response.setData(data);
        return this;
    }

    public ResponseBuilder<T> success() {
        this.response.setCode(ResponseCode.CODE_200.getCode());
        this.response.setMsg(ResponseCode.CODE_200.getMsg());
        return this;
    }

    public ResponseBuilder<T> success(T data) {
        this.response.setCode(ResponseCode.CODE_200.getCode());
        this.response.setMsg(ResponseCode.CODE_200.getMsg());
        this.response.setData(data);
        return this;
    }

    public ResponseBuilder<T> fail() {
        this.response.setCode(ResponseCode.CODE_203.getCode());
        this.response.setMsg(ResponseCode.CODE_203.getMsg());
        return this;
    }

    public ResponseBuilder<T> fail(String msg) {
        this.response.setCode(ResponseCode.CODE_203.getCode());
        this.response.setMsg(msg);
        return this;
    }

    public Response<T> build() {
        return this.response;
    }
}

