/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.pipeline;

import com.xxl.tool.pipeline.PipelineChain;
import com.xxl.tool.pipeline.PipelineContext;
import com.xxl.tool.pipeline.PipelineHandler;
import com.xxl.tool.pipeline.PipelineStatus;
import com.xxl.tool.response.Response;
import com.xxl.tool.response.ResponseBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pipeline {
    private static final Logger logger = LoggerFactory.getLogger(Pipeline.class);
    private String name;
    private String status = PipelineStatus.RUNTIME.getStatus();
    private final List<PipelineChain> handlerList = new ArrayList<PipelineChain>();

    public Pipeline name(String name) {
        this.name = name;
        return this;
    }

    public Pipeline status(String status) {
        this.status = status;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public List<PipelineChain> getHandlerList() {
        return this.handlerList;
    }

    public String toString() {
        return "Pipeline{name='" + this.name + '\'' + ", status='" + this.status + '\'' + ", handlerList=" + this.handlerList + '}';
    }

    public Pipeline addLast(PipelineHandler pipelineHandler) {
        PipelineChain pipelineChain = new PipelineChain(pipelineHandler);
        this.handlerList.add(pipelineChain);
        return this;
    }

    public Pipeline addLasts(PipelineHandler ... pipelineHandlers) {
        for (PipelineHandler pipelineHandler : pipelineHandlers) {
            this.addLast(pipelineHandler);
        }
        return this;
    }

    public Response<Object> process(Object request) {
        return this.process(request, null);
    }

    public Response<Object> process(Object request, ConcurrentMap<String, Object> contextMap) {
        logger.debug("pipeline process start, name:{}, status:{}", (Object)this.name, (Object)this.status);
        PipelineContext pipelineContext = new PipelineContext(request);
        if (contextMap != null) {
            pipelineContext.setContextMap(contextMap);
        }
        for (PipelineChain handlerChain : this.handlerList) {
            if (pipelineContext.isBreak()) break;
            try {
                handlerChain.handle(pipelineContext);
            }
            catch (Exception e) {
                logger.error("pipeline process error, name:{}, pipelineContext:{}", new Object[]{this.name, pipelineContext, e});
                pipelineContext.breakToFail(new ResponseBuilder().fail(e.getMessage()).build());
            }
        }
        if (pipelineContext.getResponse() == null) {
            pipelineContext.breakToFail(new ResponseBuilder().fail("pipeline response not found.").build());
        }
        logger.error("pipeline process end, name:{}, pipelineContext:{}", (Object)this.name, (Object)pipelineContext);
        return pipelineContext.getResponse();
    }
}

