/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieTool {
    private static final int COOKIE_MAX_AGE = Integer.MAX_VALUE;
    private static final String COOKIE_PATH = "/";

    private static void set(HttpServletResponse response, String key, String value, String domain, String path, int maxAge, boolean isHttpOnly) {
        try {
            value = URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
        Cookie cookie = new Cookie(key, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        cookie.setHttpOnly(isHttpOnly);
        response.addCookie(cookie);
    }

    public static void set(HttpServletResponse response, String key, String value, boolean ifRemember) {
        int age = ifRemember ? Integer.MAX_VALUE : -1;
        CookieTool.set(response, key, value, null, COOKIE_PATH, age, true);
    }

    public static void set(HttpServletResponse response, String key, String value, int maxAge) {
        CookieTool.set(response, key, value, null, COOKIE_PATH, maxAge, true);
    }

    public static void remove(HttpServletRequest request, HttpServletResponse response, String key) {
        Cookie cookie = CookieTool.get(request, key);
        if (cookie != null) {
            CookieTool.set(response, key, "", null, COOKIE_PATH, 0, true);
        }
    }

    private static Cookie get(HttpServletRequest request, String key) {
        Cookie[] arr_cookie = request.getCookies();
        if (arr_cookie != null && arr_cookie.length > 0) {
            for (Cookie cookie : arr_cookie) {
                if (!cookie.getName().equals(key)) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String getValue(HttpServletRequest request, String key) {
        Cookie cookie = CookieTool.get(request, key);
        if (cookie == null) {
            return null;
        }
        String value = cookie.getValue();
        try {
            value = URLDecoder.decode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return value;
    }
}

