/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.io;

import com.xxl.tool.core.AssertTool;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamTool {
    public static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        AssertTool.notNull(in, "No InputStream specified");
        AssertTool.notNull(out, "No OutputStream specified");
        try {
            int bytesRead;
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            StreamTool.close(in);
            StreamTool.close(out);
        }
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        AssertTool.notNull(in, "No input byte array specified");
        AssertTool.notNull(out, "No OutputStream specified");
        try {
            out.write(in);
        }
        finally {
            StreamTool.close(out);
        }
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        StreamTool.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

