/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class GsonTool {
    private static Gson gson = null;

    public static String toJson(Object src) {
        return gson.toJson(src);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)gson.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Class<T> classOfT, Class argClassOfT) {
        ParameterizedType4ReturnT type = new ParameterizedType4ReturnT(classOfT, new Class[]{argClassOfT});
        return (T)gson.fromJson(json, (Type)type);
    }

    public static <T> ArrayList<T> fromJsonList(String json, Class<T> classOfT) {
        Type type = TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{classOfT}).getType();
        return (ArrayList)gson.fromJson(json, type);
    }

    public static <K, V> HashMap<K, V> fromJsonMap(String json, Class<K> keyClass, Class<V> valueClass) {
        Type type = TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{keyClass, valueClass}).getType();
        return (HashMap)gson.fromJson(json, type);
    }

    static {
        gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").disableHtmlEscaping().create();
    }

    public static class ParameterizedType4ReturnT
    implements ParameterizedType {
        private final Class raw;
        private final Type[] args;

        public ParameterizedType4ReturnT(Class raw, Type[] args) {
            this.raw = raw;
            this.args = args != null ? args : new Type[]{};
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.args;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }
}

