/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.fiber;

import co.paralleluniverse.common.monitoring.MonitorType;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberForkJoinScheduler;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.strands.SuspendableRunnable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiberTool {
    private static Logger logger = LoggerFactory.getLogger(FiberTool.class);
    private static final FiberScheduler instance = new FiberForkJoinScheduler("fiber-helper-pool", 20, null, MonitorType.JMX, false);

    private static FiberScheduler defaultScheduler() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean submit(List<SuspendableRunnable> fiberTaskList, long maxWaitSeconds) {
        if (fiberTaskList == null || fiberTaskList.size() == 0) {
            return false;
        }
        if (maxWaitSeconds < 1L) {
            throw new RuntimeException("maxWaitSeconds is invalid.");
        }
        final CountDownLatch countDownLatch = new CountDownLatch(fiberTaskList.size());
        ArrayList<Fiber> fiberList = new ArrayList<Fiber>();
        for (SuspendableRunnable fiberTask : fiberTaskList) {
            Fiber fiber = new Fiber<Void>("FiberTask", FiberTool.defaultScheduler(), fiberTask){

                protected void onCompletion() {
                    countDownLatch.countDown();
                    super.onCompletion();
                }

                protected void onException(Throwable t) {
                    countDownLatch.countDown();
                    logger.error(t.getMessage(), t);
                    super.onException(t);
                }
            }.start();
            fiberList.add(fiber);
        }
        try {
            countDownLatch.await(maxWaitSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            for (Fiber fiber : fiberList) {
                if (!fiber.isAlive()) continue;
                try {
                    fiber.cancel(true);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }
}

