/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.excel;

import com.xxl.tool.excel.annotation.ExcelField;
import com.xxl.tool.excel.annotation.ExcelSheet;
import com.xxl.tool.excel.util.FieldReflectionUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTool {
    private static Logger logger = LoggerFactory.getLogger(ExcelTool.class);

    private static Workbook exportWorkbook(boolean xlsx, List<List<?>> sheetDataListArr) {
        if (sheetDataListArr == null || sheetDataListArr.size() == 0) {
            throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data array can not be empty.");
        }
        XSSFWorkbook workbook = xlsx ? new XSSFWorkbook() : new HSSFWorkbook();
        for (List<?> dataList : sheetDataListArr) {
            ExcelTool.makeSheet((Workbook)workbook, dataList);
        }
        return workbook;
    }

    private static void makeSheet(Workbook workbook, List<?> sheetDataList) {
        Cell cellX;
        int i;
        Sheet existSheet;
        if (sheetDataList == null || sheetDataList.size() == 0) {
            throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data can not be empty.");
        }
        Class<?> sheetClass = sheetDataList.get(0).getClass();
        ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
        String sheetName = sheetDataList.get(0).getClass().getSimpleName();
        int headColorIndex = -1;
        if (excelSheet != null) {
            if (excelSheet.name() != null && excelSheet.name().trim().length() > 0) {
                sheetName = excelSheet.name().trim();
            }
            headColorIndex = excelSheet.headColor().getIndex();
        }
        if ((existSheet = workbook.getSheet(sheetName)) != null) {
            for (int i2 = 2; i2 <= 1000; ++i2) {
                String newSheetName = sheetName.concat(String.valueOf(i2));
                existSheet = workbook.getSheet(newSheetName);
                if (existSheet != null) continue;
                sheetName = newSheetName;
                break;
            }
        }
        Sheet sheet = workbook.createSheet(sheetName);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (sheetClass.getDeclaredFields() != null && sheetClass.getDeclaredFields().length > 0) {
            for (Field field : sheetClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        if (fields == null || fields.size() == 0) {
            throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data field can not be empty.");
        }
        CellStyle[] fieldDataStyleArr = new CellStyle[fields.size()];
        int[] fieldWidthArr = new int[fields.size()];
        Row headRow = sheet.createRow(0);
        for (i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            ExcelField excelField = field.getAnnotation(ExcelField.class);
            String fieldName = field.getName();
            int fieldWidth = 0;
            HorizontalAlignment align = null;
            if (excelField != null) {
                if (excelField.name() != null && excelField.name().trim().length() > 0) {
                    fieldName = excelField.name().trim();
                }
                fieldWidth = excelField.width();
                align = excelField.align();
            }
            fieldWidthArr[i] = fieldWidth;
            CellStyle fieldDataStyle = workbook.createCellStyle();
            if (align != null) {
                fieldDataStyle.setAlignment(align);
            }
            fieldDataStyleArr[i] = fieldDataStyle;
            CellStyle headStyle = workbook.createCellStyle();
            headStyle.cloneStyleFrom(fieldDataStyle);
            if (headColorIndex > -1) {
                headStyle.setFillForegroundColor((short)headColorIndex);
                headStyle.setFillBackgroundColor((short)headColorIndex);
                headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            cellX = headRow.createCell(i, CellType.STRING);
            cellX.setCellStyle(headStyle);
            cellX.setCellValue(String.valueOf(fieldName));
        }
        for (int dataIndex = 0; dataIndex < sheetDataList.size(); ++dataIndex) {
            int rowIndex = dataIndex + 1;
            Object rowData = sheetDataList.get(dataIndex);
            Row rowX = sheet.createRow(rowIndex);
            for (int i3 = 0; i3 < fields.size(); ++i3) {
                Field field = (Field)fields.get(i3);
                try {
                    field.setAccessible(true);
                    Object fieldValue = field.get(rowData);
                    String fieldValueString = FieldReflectionUtil.formatValue(field, fieldValue);
                    cellX = rowX.createCell(i3, CellType.STRING);
                    cellX.setCellValue(fieldValueString);
                    cellX.setCellStyle(fieldDataStyleArr[i3]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        for (i = 0; i < fields.size(); ++i) {
            int fieldWidth = fieldWidthArr[i];
            if (fieldWidth > 0) {
                sheet.setColumnWidth(i, fieldWidth);
                continue;
            }
            sheet.autoSizeColumn((int)((short)i));
        }
    }

    public static void exportToFile(boolean xlsx, List<List<?>> sheetDataListArr, String filePath) {
        Workbook workbook = ExcelTool.exportWorkbook(xlsx, sheetDataListArr);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
            workbook.write((OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static void exportToFile(List<List<?>> sheetDataListArr, String filePath) {
        ExcelTool.exportToFile(true, sheetDataListArr, filePath);
    }

    public static byte[] exportToBytes(boolean xlsx, List<List<?>> sheetDataListArr) {
        Workbook workbook = ExcelTool.exportWorkbook(xlsx, sheetDataListArr);
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] result = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = result = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] exportToBytes(List<List<?>> sheetDataListArr) {
        return ExcelTool.exportToBytes(true, sheetDataListArr);
    }

    private static List<Object> importExcel(Workbook workbook, Class<?> sheetClass) {
        List<Object> sheetDataList = ExcelTool.importSheet(workbook, sheetClass);
        return sheetDataList;
    }

    private static List<Object> importSheet(Workbook workbook, Class<?> sheetClass) {
        try {
            ExcelSheet excelSheet = sheetClass.getAnnotation(ExcelSheet.class);
            String sheetName = excelSheet != null && excelSheet.name() != null && excelSheet.name().trim().length() > 0 ? excelSheet.name().trim() : sheetClass.getSimpleName();
            ArrayList<Field> fields = new ArrayList<Field>();
            if (sheetClass.getDeclaredFields() != null && sheetClass.getDeclaredFields().length > 0) {
                for (Field field : sheetClass.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers())) continue;
                    fields.add(field);
                }
            }
            if (fields == null || fields.size() == 0) {
                throw new RuntimeException(">>>>>>>>>>> xxl-excel error, data field can not be empty.");
            }
            Sheet sheet = workbook.getSheet(sheetName);
            if (sheet == null) {
                return null;
            }
            Iterator sheetIterator = sheet.rowIterator();
            int rowIndex = 0;
            ArrayList<Object> dataList = new ArrayList<Object>();
            while (sheetIterator.hasNext()) {
                Row rowX = (Row)sheetIterator.next();
                if (rowIndex > 0) {
                    Object rowObj = sheetClass.newInstance();
                    for (int i = 0; i < fields.size(); ++i) {
                        Cell cell = rowX.getCell(i);
                        if (cell == null) continue;
                        cell.setCellType(CellType.STRING);
                        String fieldValueStr = cell.getStringCellValue();
                        Field field = (Field)fields.get(i);
                        Object fieldValue = FieldReflectionUtil.parseValue(field, fieldValueStr);
                        if (fieldValue == null) continue;
                        field.setAccessible(true);
                        field.set(rowObj, fieldValue);
                    }
                    dataList.add(rowObj);
                }
                ++rowIndex;
            }
            return dataList;
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Object> importExcel(File excelFile, Class<?> sheetClass) {
        try {
            Workbook workbook = WorkbookFactory.create((File)excelFile);
            List<Object> dataList = ExcelTool.importExcel(workbook, sheetClass);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EncryptedDocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static List<Object> importExcel(String filePath, Class<?> sheetClass) {
        File excelFile = new File(filePath);
        List<Object> dataList = ExcelTool.importExcel(excelFile, sheetClass);
        return dataList;
    }

    public static List<Object> importExcel(InputStream inputStream, Class<?> sheetClass) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            List<Object> dataList = ExcelTool.importExcel(workbook, sheetClass);
            return dataList;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EncryptedDocumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

