/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.core;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;

public class MapTool {
    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapTool.isEmpty(map);
    }

    public static <K> String getString(Map<? super K, ?> map, K key) {
        Object value;
        if (map != null && (value = map.get(key)) != null) {
            return value.toString();
        }
        return null;
    }

    public static <K> Boolean getBoolean(Map<? super K, ?> map, K key) {
        Object value;
        if (map != null && (value = map.get(key)) != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.valueOf((String)value);
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                return n.intValue() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    public static <K> Number getNumber(Map<? super K, ?> map, K key) {
        Object value;
        if (map != null && (value = map.get(key)) != null) {
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof String) {
                try {
                    String text = (String)value;
                    return NumberFormat.getInstance().parse(text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static <K> Byte getByte(Map<? super K, ?> map, K key) {
        Number value = MapTool.getNumber(map, key);
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        return value.byteValue();
    }

    public static <K> Short getShort(Map<? super K, ?> map, K key) {
        Number value = MapTool.getNumber(map, key);
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        return value.shortValue();
    }

    public static <K> Integer getInteger(Map<? super K, ?> map, K key) {
        Number value = MapTool.getNumber(map, key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return value.intValue();
    }

    public static <K> Long getLong(Map<? super K, ?> map, K key) {
        Number value = MapTool.getNumber(map, key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return value.longValue();
    }

    public static <K> Float getFloat(Map<? super K, ?> map, K key) {
        Number value = MapTool.getNumber(map, key);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        return Float.valueOf(value.floatValue());
    }

    public static <K> Double getDouble(Map<? super K, ?> map, K key) {
        Number value = MapTool.getNumber(map, key);
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return value.doubleValue();
    }
}

