/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.sso.core.util;

import com.xxl.tool.core.StringTool;
import com.xxl.tool.serializer.impl.JavaSerializer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisTool {
    private static final Logger logger = LoggerFactory.getLogger(JedisTool.class);
    private String nodes;
    private String user;
    private String password;
    private int connectionTimeout = 2000;
    private int soTimeout = 2000;
    private int maxAttempts = 3;
    private Set<HostAndPort> clusterNodes = new HashSet<HostAndPort>();
    private JavaSerializer serializer = new JavaSerializer();
    private JedisPool jedisPool;
    private JedisCluster jedisCluster;

    public JedisTool(String nodes, String user, String password) {
        this.nodes = nodes;
        if (StringTool.isNotBlank((String)user)) {
            this.user = user;
        }
        if (StringTool.isNotBlank((String)password)) {
            this.password = password;
        }
    }

    public void start() {
        GenericObjectPoolConfig poolConfig;
        if (this.nodes != null && !this.nodes.trim().isEmpty()) {
            for (String node : this.nodes.split(",")) {
                String[] parts = node.split(":");
                if (parts.length != 2) continue;
                String host = parts[0];
                int port = Integer.parseInt(parts[1]);
                this.clusterNodes.add(new HostAndPort(host, port));
            }
        }
        if (this.clusterNodes == null || this.clusterNodes.isEmpty()) {
            throw new IllegalArgumentException("clusterNodes can not be null or empty.");
        }
        if (this.clusterNodes.size() > 1) {
            try {
                poolConfig = new GenericObjectPoolConfig();
                DefaultJedisClientConfig clientConfig = DefaultJedisClientConfig.builder().timeoutMillis(this.soTimeout).connectionTimeoutMillis(this.connectionTimeout).user(this.user).password(this.password).build();
                this.jedisCluster = new JedisCluster(this.clusterNodes, (JedisClientConfig)clientConfig, this.maxAttempts, poolConfig);
                logger.info(">>>>>>>>>>> JedisTool(JedisCluster) initialized successfully.");
            }
            catch (Exception e) {
                logger.error(">>>>>>>>>>> JedisTool(JedisCluster) initialized error.", (Throwable)e);
                throw new RuntimeException("JedisTool(JedisCluster) initialized error.", e);
            }
        }
        try {
            poolConfig = new JedisPoolConfig();
            DefaultJedisClientConfig clientConfig = DefaultJedisClientConfig.builder().timeoutMillis(this.soTimeout).connectionTimeoutMillis(this.connectionTimeout).user(this.user).password(this.password).build();
            this.jedisPool = new JedisPool(poolConfig, (HostAndPort)this.clusterNodes.stream().findFirst().get(), (JedisClientConfig)clientConfig);
            logger.info(">>>>>>>>>>> JedisTool(jedisPool) initialized successfully.");
        }
        catch (Exception e) {
            logger.error(">>>>>>>>>>> JedisTool(jedisPool) initialized error.", (Throwable)e);
            throw new RuntimeException("JedisTool(jedisPool) initialized error.", e);
        }
    }

    public void stop() {
        try {
            if (this.jedisCluster != null) {
                this.jedisCluster.close();
            }
            if (this.jedisPool != null) {
                this.jedisPool.close();
            }
            logger.info(">>>>>>>>>>> JedisTool stop finish.");
        }
        catch (Exception e) {
            logger.error(">>>>>>>>>>> JedisTool stop error.", (Throwable)e);
        }
    }

    public void set(String key, Object value, long seconds) {
        block15: {
            if (this.jedisCluster != null) {
                try {
                    byte[] valueBytes = this.serializer.serialize(value);
                    if (seconds < 0L) {
                        this.jedisCluster.set(key.getBytes(StandardCharsets.UTF_8), valueBytes);
                        break block15;
                    }
                    this.jedisCluster.setex(key.getBytes(StandardCharsets.UTF_8), seconds, valueBytes);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                try (Jedis jedis = this.jedisPool.getResource();){
                    byte[] valueBytes = this.serializer.serialize(value);
                    if (seconds < 0L) {
                        jedis.set(key.getBytes(StandardCharsets.UTF_8), valueBytes);
                    } else {
                        long milliseconds = seconds * 1000L;
                        jedis.psetex(key.getBytes(StandardCharsets.UTF_8), milliseconds, valueBytes);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String key) {
        if (this.jedisCluster != null) {
            try {
                byte[] valueBytes2 = this.jedisCluster.get(key.getBytes(StandardCharsets.UTF_8));
                if (valueBytes2 != null) return this.serializer.deserialize(valueBytes2);
                return null;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }
        try (Jedis jedis = this.jedisPool.getResource();){
            byte[] valueBytes = jedis.get(key.getBytes(StandardCharsets.UTF_8));
            if (valueBytes == null) {
                Object var4_8 = null;
                return var4_8;
            }
            Object object = this.serializer.deserialize(valueBytes);
            return object;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void del(String key) {
        if (this.jedisCluster != null) {
            try {
                this.jedisCluster.del(key.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try (Jedis jedis = this.jedisPool.getResource();){
                jedis.del(key.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

