/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.serialize.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.XxlRpcException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class KryoSerializer
extends Serializer {
    private final ThreadLocal<Kryo> kryoLocal = new ThreadLocal<Kryo>(){

        @Override
        protected Kryo initialValue() {
            Kryo kryo = new Kryo();
            kryo.setReferences(true);
            kryo.setRegistrationRequired(false);
            return kryo;
        }
    };

    @Override
    public <T> byte[] serialize(T obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)os);
        try {
            byte[] result;
            this.kryoLocal.get().writeObject(output, obj);
            output.flush();
            byte[] byArray = result = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new XxlRpcException(e);
        }
        finally {
            try {
                output.close();
            }
            catch (Exception e) {
                throw new XxlRpcException(e);
            }
            try {
                os.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e);
            }
        }
    }

    @Override
    public <T> Object deserialize(byte[] bytes, Class<T> clazz) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Input input = new Input((InputStream)is);
        try {
            Object result;
            Object object = result = this.kryoLocal.get().readObject(input, clazz);
            return object;
        }
        catch (Exception e) {
            throw new XxlRpcException(e);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {
                throw new XxlRpcException(e);
            }
            try {
                is.close();
            }
            catch (IOException e) {
                throw new XxlRpcException(e);
            }
        }
    }
}

