/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.impl.mina.client;

import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.net.common.ConnectClient;
import com.xxl.rpc.remoting.net.impl.mina.client.MinaClientHandler;
import com.xxl.rpc.remoting.net.impl.mina.codec.MinaDecoder;
import com.xxl.rpc.remoting.net.impl.mina.codec.MinaEncoder;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.serialize.Serializer;
import com.xxl.rpc.util.IpUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.transport.socket.DefaultSocketSessionConfig;
import org.apache.mina.transport.socket.nio.NioSocketConnector;

public class MinaConnectClient
extends ConnectClient {
    private NioSocketConnector connector;
    private IoSession ioSession;

    @Override
    public void init(String address, final Serializer serializer, XxlRpcInvokerFactory xxlRpcInvokerFactory) {
        Object[] array = IpUtil.parseIpPort(address);
        String host = (String)array[0];
        int port = (Integer)array[1];
        this.connector = new NioSocketConnector();
        this.connector.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter(new ProtocolCodecFactory(){

            public ProtocolEncoder getEncoder(IoSession session) throws Exception {
                return new MinaEncoder(XxlRpcRequest.class, serializer);
            }

            public ProtocolDecoder getDecoder(IoSession session) throws Exception {
                return new MinaDecoder(XxlRpcResponse.class, serializer);
            }
        }));
        this.connector.setHandler((IoHandler)new MinaClientHandler(xxlRpcInvokerFactory));
        this.connector.setConnectTimeoutMillis(5000L);
        DefaultSocketSessionConfig sessionConfiguration = (DefaultSocketSessionConfig)this.connector.getSessionConfig();
        sessionConfiguration.setTcpNoDelay(true);
        sessionConfiguration.setKeepAlive(true);
        sessionConfiguration.setSoLinger(-1);
        ConnectFuture future = this.connector.connect((SocketAddress)new InetSocketAddress(host, port));
        future.awaitUninterruptibly(5L, TimeUnit.SECONDS);
        this.ioSession = future.getSession();
        if (!this.isValidate()) {
            this.close();
            return;
        }
        logger.debug(">>>>>>>>>>> xxl-rpc mina client proxy, connect to server success at host:{}, port:{}", (Object)host, (Object)port);
    }

    @Override
    public boolean isValidate() {
        if (this.connector != null && this.ioSession != null) {
            return this.connector.isActive() && this.ioSession.isConnected();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.ioSession != null && this.ioSession.isConnected()) {
            this.ioSession.closeOnFlush();
        }
        if (this.connector != null && this.connector.isActive()) {
            this.connector.dispose();
        }
        logger.debug(">>>>>>>>>>> xxl-rpc mina client close.");
    }

    @Override
    public void send(XxlRpcRequest xxlRpcRequest) {
        this.ioSession.write((Object)xxlRpcRequest);
    }
}

