/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker.impl;

import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.remoting.invoker.XxlRpcInvokerFactory;
import com.xxl.rpc.remoting.invoker.annotation.XxlRpcReference;
import com.xxl.rpc.remoting.invoker.reference.XxlRpcReferenceBean;
import com.xxl.rpc.remoting.provider.XxlRpcProviderFactory;
import com.xxl.rpc.util.XxlRpcException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.util.ReflectionUtils;

public class XxlRpcSpringInvokerFactory
extends InstantiationAwareBeanPostProcessorAdapter
implements InitializingBean,
DisposableBean,
BeanFactoryAware {
    private Logger logger = LoggerFactory.getLogger(XxlRpcSpringInvokerFactory.class);
    private Class<? extends ServiceRegistry> serviceRegistryClass;
    private Map<String, String> serviceRegistryParam;
    private XxlRpcInvokerFactory xxlRpcInvokerFactory;
    private BeanFactory beanFactory;

    public void setServiceRegistryClass(Class<? extends ServiceRegistry> serviceRegistryClass) {
        this.serviceRegistryClass = serviceRegistryClass;
    }

    public void setServiceRegistryParam(Map<String, String> serviceRegistryParam) {
        this.serviceRegistryParam = serviceRegistryParam;
    }

    public void afterPropertiesSet() throws Exception {
        this.xxlRpcInvokerFactory = new XxlRpcInvokerFactory(this.serviceRegistryClass, this.serviceRegistryParam);
        this.xxlRpcInvokerFactory.start();
    }

    public boolean postProcessAfterInstantiation(final Object bean, final String beanName) throws BeansException {
        final HashSet<String> serviceKeyList = new HashSet<String>();
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                if (field.isAnnotationPresent(XxlRpcReference.class)) {
                    Class<?> iface = field.getType();
                    if (!iface.isInterface()) {
                        throw new XxlRpcException("xxl-rpc, reference(XxlRpcReference) must be interface.");
                    }
                    XxlRpcReference rpcReference = field.getAnnotation(XxlRpcReference.class);
                    XxlRpcReferenceBean referenceBean = new XxlRpcReferenceBean(rpcReference.netType(), rpcReference.serializer().getSerializer(), rpcReference.callType(), rpcReference.loadBalance(), iface, rpcReference.version(), rpcReference.timeout(), rpcReference.address(), rpcReference.accessToken(), null, XxlRpcSpringInvokerFactory.this.xxlRpcInvokerFactory);
                    Object serviceProxy = referenceBean.getObject();
                    field.setAccessible(true);
                    field.set(bean, serviceProxy);
                    XxlRpcSpringInvokerFactory.this.logger.info(">>>>>>>>>>> xxl-rpc, invoker factory init reference bean success. serviceKey = {}, bean.field = {}.{}", new Object[]{XxlRpcProviderFactory.makeServiceKey(iface.getName(), rpcReference.version()), beanName, field.getName()});
                    String serviceKey = XxlRpcProviderFactory.makeServiceKey(iface.getName(), rpcReference.version());
                    serviceKeyList.add(serviceKey);
                }
            }
        });
        if (this.xxlRpcInvokerFactory.getServiceRegistry() != null) {
            try {
                this.xxlRpcInvokerFactory.getServiceRegistry().discovery(serviceKeyList);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessAfterInstantiation(bean, beanName);
    }

    public void destroy() throws Exception {
        this.xxlRpcInvokerFactory.stop();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

