/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.invoker;

import com.xxl.rpc.registry.ServiceRegistry;
import com.xxl.rpc.registry.impl.LocalServiceRegistry;
import com.xxl.rpc.remoting.net.params.BaseCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcFutureResponse;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.util.XxlRpcException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XxlRpcInvokerFactory {
    private static Logger logger = LoggerFactory.getLogger(XxlRpcInvokerFactory.class);
    private static volatile XxlRpcInvokerFactory instance = new XxlRpcInvokerFactory(LocalServiceRegistry.class, null);
    private Class<? extends ServiceRegistry> serviceRegistryClass;
    private Map<String, String> serviceRegistryParam;
    private ServiceRegistry serviceRegistry;
    private List<BaseCallback> stopCallbackList = new ArrayList<BaseCallback>();
    private ConcurrentMap<String, XxlRpcFutureResponse> futureResponsePool = new ConcurrentHashMap<String, XxlRpcFutureResponse>();
    private ThreadPoolExecutor responseCallbackThreadPool = null;

    public static XxlRpcInvokerFactory getInstance() {
        return instance;
    }

    public XxlRpcInvokerFactory() {
    }

    public XxlRpcInvokerFactory(Class<? extends ServiceRegistry> serviceRegistryClass, Map<String, String> serviceRegistryParam) {
        this.serviceRegistryClass = serviceRegistryClass;
        this.serviceRegistryParam = serviceRegistryParam;
    }

    public void start() throws Exception {
        if (this.serviceRegistryClass != null) {
            this.serviceRegistry = this.serviceRegistryClass.newInstance();
            this.serviceRegistry.start(this.serviceRegistryParam);
        }
    }

    public void stop() throws Exception {
        if (this.serviceRegistry != null) {
            this.serviceRegistry.stop();
        }
        if (this.stopCallbackList.size() > 0) {
            for (BaseCallback callback : this.stopCallbackList) {
                try {
                    callback.run();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.stopCallbackThreadPool();
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void addStopCallBack(BaseCallback callback) {
        this.stopCallbackList.add(callback);
    }

    public void setInvokerFuture(String requestId, XxlRpcFutureResponse futureResponse) {
        this.futureResponsePool.put(requestId, futureResponse);
    }

    public void removeInvokerFuture(String requestId) {
        this.futureResponsePool.remove(requestId);
    }

    public void notifyInvokerFuture(String requestId, final XxlRpcResponse xxlRpcResponse) {
        final XxlRpcFutureResponse futureResponse = (XxlRpcFutureResponse)this.futureResponsePool.get(requestId);
        if (futureResponse == null) {
            return;
        }
        if (futureResponse.getInvokeCallback() != null) {
            try {
                this.executeResponseCallback(new Runnable(){

                    @Override
                    public void run() {
                        if (xxlRpcResponse.getErrorMsg() != null) {
                            futureResponse.getInvokeCallback().onFailure(new XxlRpcException(xxlRpcResponse.getErrorMsg()));
                        } else {
                            futureResponse.getInvokeCallback().onSuccess(xxlRpcResponse.getResult());
                        }
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            futureResponse.setResponse(xxlRpcResponse);
        }
        this.futureResponsePool.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeResponseCallback(Runnable runnable) {
        if (this.responseCallbackThreadPool == null) {
            XxlRpcInvokerFactory xxlRpcInvokerFactory = this;
            synchronized (xxlRpcInvokerFactory) {
                if (this.responseCallbackThreadPool == null) {
                    this.responseCallbackThreadPool = new ThreadPoolExecutor(10, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            return new Thread(r, "xxl-rpc, XxlRpcInvokerFactory-responseCallbackThreadPool-" + r.hashCode());
                        }
                    }, new RejectedExecutionHandler(){

                        @Override
                        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                            throw new XxlRpcException("xxl-rpc Invoke Callback Thread pool is EXHAUSTED!");
                        }
                    });
                }
            }
        }
        this.responseCallbackThreadPool.execute(runnable);
    }

    public void stopCallbackThreadPool() {
        if (this.responseCallbackThreadPool != null) {
            this.responseCallbackThreadPool.shutdown();
        }
    }
}

