/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.biz.client;

import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.model.IdleBeatParam;
import com.xxl.job.core.biz.model.KillParam;
import com.xxl.job.core.biz.model.LogParam;
import com.xxl.job.core.biz.model.LogResult;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.biz.model.TriggerParam;
import com.xxl.job.core.util.XxlJobRemotingUtil;

public class ExecutorBizClient
implements ExecutorBiz {
    private String addressUrl;
    private String accessToken;
    private int timeout;

    public ExecutorBizClient() {
    }

    public ExecutorBizClient(String addressUrl, String accessToken, int timeout) {
        this.addressUrl = addressUrl;
        this.accessToken = accessToken;
        this.timeout = timeout;
        if (!this.addressUrl.endsWith("/")) {
            this.addressUrl = this.addressUrl + "/";
        }
        if (this.timeout < 1 || this.timeout > 10) {
            this.timeout = 3;
        }
    }

    @Override
    public ReturnT<String> beat() {
        return XxlJobRemotingUtil.postBody(this.addressUrl + "beat", this.accessToken, this.timeout, "", String.class);
    }

    @Override
    public ReturnT<String> idleBeat(IdleBeatParam idleBeatParam) {
        return XxlJobRemotingUtil.postBody(this.addressUrl + "idleBeat", this.accessToken, this.timeout, idleBeatParam, String.class);
    }

    @Override
    public ReturnT<String> run(TriggerParam triggerParam) {
        return XxlJobRemotingUtil.postBody(this.addressUrl + "run", this.accessToken, this.timeout, triggerParam, String.class);
    }

    @Override
    public ReturnT<String> kill(KillParam killParam) {
        return XxlJobRemotingUtil.postBody(this.addressUrl + "kill", this.accessToken, this.timeout, killParam, String.class);
    }

    @Override
    public ReturnT<LogResult> log(LogParam logParam) {
        return XxlJobRemotingUtil.postBody(this.addressUrl + "log", this.accessToken, this.timeout, logParam, LogResult.class);
    }
}

