/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.collection.MapBuilder;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.Editor;
import com.xiaoleilu.hutool.lang.Filter;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.ReflectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapUtil {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public static boolean isEmpty(Map<?, ?> map) {
        return null == map || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return null != map && false == map.isEmpty();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        int initialCapacity = (int)((float)size / 0.75f);
        return isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return MapUtil.newHashMap(size, false);
    }

    public static <K, V> HashMap<K, V> newHashMap(boolean isOrder) {
        return MapUtil.newHashMap(16, false);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        try {
            return (Map)ReflectUtil.newInstance(mapType, new Object[0]);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <K, V> HashMap<K, V> of(K key, V value) {
        return MapUtil.of(key, value, false);
    }

    public static <K, V> HashMap<K, V> of(K key, V value, boolean isOrder) {
        HashMap<K, V> map = MapUtil.newHashMap(isOrder);
        map.put(key, value);
        return map;
    }

    public static HashMap<Object, Object> of(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <K, V> Map<K, List<V>> toListMap(Iterable<? extends Map<K, V>> mapList) {
        HashMap<K, ArrayList<Object>> resultMap = new HashMap<K, ArrayList<Object>>();
        if (CollectionUtil.isEmpty(mapList)) {
            return resultMap;
        }
        for (Map<K, V> map : mapList) {
            Set<Map.Entry<K, V>> entrySet = map.entrySet();
            for (Map.Entry<K, V> entry : entrySet) {
                K key = entry.getKey();
                ArrayList<Object> valueList = (ArrayList<Object>)resultMap.get(key);
                if (null == valueList) {
                    valueList = CollectionUtil.newArrayList(entry.getValue());
                    resultMap.put(key, valueList);
                    continue;
                }
                valueList.add(entry.getValue());
            }
        }
        return resultMap;
    }

    public static <K, V> List<Map<K, V>> toMapList(Map<K, ? extends Iterable<V>> listMap) {
        ArrayList<Map<K, V>> resultList = new ArrayList<Map<K, V>>();
        if (MapUtil.isEmpty(listMap)) {
            return resultList;
        }
        boolean isEnd = true;
        int index = 0;
        do {
            isEnd = true;
            HashMap map = new HashMap();
            for (Map.Entry<K, Iterable<V>> entry : listMap.entrySet()) {
                ArrayList<V> vList = CollectionUtil.newArrayList(entry.getValue());
                int vListSize = vList.size();
                if (index >= vListSize) continue;
                map.put(entry.getKey(), vList.get(index));
                if (index == vListSize - 1) continue;
                isEnd = false;
            }
            if (!map.isEmpty()) {
                resultList.add(map);
            }
            ++index;
        } while (!isEnd);
        return resultList;
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapUtil.join(map, separator, keyValueSeparator, false);
    }

    public static <K, V> String joinIgnoreNull(Map<K, V> map, String separator, String keyValueSeparator) {
        return MapUtil.join(map, separator, keyValueSeparator, true);
    }

    public static <K, V> String join(Map<K, V> map, String separator, String keyValueSeparator, boolean isIgnoreNull) {
        StringBuilder strBuilder = StrUtil.builder();
        boolean isFirst = true;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (isIgnoreNull && (entry.getKey() == null || entry.getValue() == null)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                strBuilder.append(separator);
            }
            strBuilder.append(Convert.toStr(entry.getKey())).append(keyValueSeparator).append(Convert.toStr(entry.getValue()));
        }
        return strBuilder.toString();
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        Map<K, V> map2 = ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Filter<Map.Entry<K, V>> filter) {
        Map<K, V> map2 = ObjectUtil.clone(map);
        if (MapUtil.isEmpty(map2)) {
            return map2;
        }
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.accept(entry)) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static <K, V> MapBuilder<K, V> builder() {
        return MapUtil.builder(new HashMap());
    }

    public static <K, V> MapBuilder<K, V> builder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public static <K, V> MapBuilder<K, V> builder(K k, V v) {
        return MapUtil.builder(new HashMap()).put(k, v);
    }
}

