/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.bean.BeanDesc;
import com.xiaoleilu.hutool.bean.BeanDescCache;
import com.xiaoleilu.hutool.bean.BeanInfoCache;
import com.xiaoleilu.hutool.bean.BeanResolver;
import com.xiaoleilu.hutool.bean.DynaBean;
import com.xiaoleilu.hutool.collection.CaseInsensitiveMap;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.TypeUtil;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;

@Deprecated
public class BeanUtil {
    public static boolean isBean(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static DynaBean createDynaBean(Object bean) {
        return new DynaBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static boolean hasNull(Object bean, boolean ignoreError) {
        Field[] fields = ClassUtil.getDeclaredFields(bean.getClass());
        Object fieldValue = null;
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                fieldValue = field.get(bean);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null != fieldValue) continue;
            return true;
        }
        return false;
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        BeanDesc beanDesc = BeanDescCache.INSTANCE.getBeanDesc(clazz);
        if (null == beanDesc) {
            beanDesc = new BeanDesc(clazz);
            BeanDescCache.INSTANCE.putBeanDesc(clazz, beanDesc);
        }
        return beanDesc;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        return Introspector.getBeanInfo(clazz).getPropertyDescriptors();
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws IntrospectionException {
        Map<String, PropertyDescriptor> map = BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase);
        if (null == map) {
            map = BeanUtil.internalGetPropertyDescriptorMap(clazz, ignoreCase);
            BeanInfoCache.INSTANCE.putPropertyDescriptorMap(clazz, map, ignoreCase);
        }
        return map;
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws IntrospectionException {
        return BeanUtil.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws IntrospectionException {
        Map<String, PropertyDescriptor> map = BeanUtil.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean, String fieldName) {
        if (null == bean || StrUtil.isBlank(fieldName)) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldName);
        }
        if (bean instanceof List) {
            return ((List)bean).get(Integer.parseInt(fieldName));
        }
        if (bean instanceof Collection) {
            return ((Collection)bean).toArray()[Integer.parseInt(fieldName)];
        }
        if (ArrayUtil.isArray(bean)) {
            return Array.get(bean, Integer.parseInt(fieldName));
        }
        try {
            Field field = ClassUtil.getDeclaredField(bean.getClass(), fieldName);
            if (null != field) {
                field.setAccessible(true);
                return field.get(bean);
            }
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        return null;
    }

    public static Object getProperty(Object bean, String expression) {
        return BeanResolver.resolveBean(bean, expression);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T mapToBeanIgnoreCase(Map<?, ?> map, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMapIgnoreCase(map, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T fillBeanWithMap(final Map<?, ?> map, T bean, CopyOptions copyOptions) {
        return BeanUtil.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                return map.get(key);
            }

            @Override
            public boolean containsKey(String key) {
                return map.containsKey(key);
            }
        }, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        if (isToCamelCase) {
            HashMap map2 = new HashMap();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object key = entry.getKey();
                if (null != key && key instanceof String) {
                    String keyStr = (String)key;
                    map2.put(StrUtil.toCamelCase(keyStr), entry.getValue());
                    continue;
                }
                map2.put((String)key, entry.getValue());
            }
            return BeanUtil.fillBeanWithMap(map2, bean, isIgnoreError);
        }
        return BeanUtil.fillBeanWithMap(map, bean, isIgnoreError);
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(new CaseInsensitiveMap(map), bean, isIgnoreError);
    }

    public static <T> T fillBeanWithRequestParam(final ServletRequest request, T bean, CopyOptions copyOptions) {
        final String beanName = StrUtil.lowerFirst(bean.getClass().getSimpleName());
        return BeanUtil.fillBean(bean, new ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                String value = request.getParameter(key);
                if (StrUtil.isEmpty(value) && StrUtil.isEmpty(value = request.getParameter(beanName + "." + key))) {
                    value = null;
                }
                return value;
            }

            @Override
            public boolean containsKey(String key) {
                return null != request.getParameter(key);
            }
        }, copyOptions);
    }

    public static <T> T fillBeanWithRequestParam(ServletRequest request, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithRequestParam(request, bean, CopyOptions.create().setIgnoreError(isIgnoreError));
    }

    public static <T> T requestParamToBean(ServletRequest request, Class<T> beanClass, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithRequestParam(request, ClassUtil.newInstance(beanClass), isIgnoreError);
    }

    public static <T> T toBean(Class<T> beanClass, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        return BeanUtil.fillBean(ClassUtil.newInstance(beanClass), valueProvider, copyOptions);
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        Class actualEditable = bean.getClass();
        if (copyOptions.editable != null) {
            if (!copyOptions.editable.isInstance(bean)) {
                throw new IllegalArgumentException(StrUtil.format((CharSequence)"Target class [{}] not assignable to Editable class [{}]", bean.getClass().getName(), copyOptions.editable.getName()));
            }
            actualEditable = copyOptions.editable;
        }
        HashSet<String> ignoreSet = copyOptions.ignoreProperties != null ? CollectionUtil.newHashSet(copyOptions.ignoreProperties) : null;
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(actualEditable).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Method setterMethod;
            Object value;
            String fieldName = prop.getFieldName();
            if (null != ignoreSet && ignoreSet.contains(fieldName) || !valueProvider.containsKey(fieldName) || null == (value = valueProvider.value(fieldName, TypeUtil.getFirstParamType(setterMethod = prop.getSetter()))) && copyOptions.ignoreNullValue) continue;
            try {
                Class<?> propClass = prop.getFieldClass();
                if (!propClass.isInstance(value) && null == (value = Convert.convert(propClass, value)) && copyOptions.ignoreNullValue || null == setterMethod) continue;
                setterMethod.invoke(bean, value);
            }
            catch (Exception e) {
                if (copyOptions.ignoreError) continue;
                throw new UtilException(e, "Inject [{}] error!", prop.getFieldName());
            }
        }
        return bean;
    }

    public static <T> Map<String, Object> beanToMap(T bean) {
        return BeanUtil.beanToMap(bean, false, false);
    }

    public static <T> Map<String, Object> beanToMap(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Collection<BeanDesc.PropDesc> props = BeanUtil.getBeanDesc(bean.getClass()).getProps();
        for (BeanDesc.PropDesc prop : props) {
            Object value;
            String key = prop.getFieldName();
            Method getter = prop.getGetter();
            if (null == getter) continue;
            try {
                value = getter.invoke(bean, new Object[0]);
            }
            catch (Exception ignore) {
                continue;
            }
            if (ignoreNullValue && (null == value || value.equals(bean))) continue;
            map.put(isToUnderlineCase ? StrUtil.toUnderlineCase(key) : key, value);
        }
        return map;
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtil.copyProperties(source, target, CopyOptions.create());
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, CopyOptions.create().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        BeanUtil.copyProperties(source, target, false, copyOptions);
    }

    public static void copyProperties(final Object source, Object target, boolean ignoreCase, CopyOptions copyOptions) {
        if (null == copyOptions) {
            copyOptions = new CopyOptions();
        }
        final boolean ignoreError = copyOptions.ignoreError;
        final Map<String, BeanDesc.PropDesc> sourcePdMap = BeanUtil.getBeanDesc(source.getClass()).getPropMap(ignoreCase);
        BeanUtil.fillBean(target, new ValueProvider<String>(){

            @Override
            public Object value(String key, Type valueType) {
                block3: {
                    Method getter;
                    BeanDesc.PropDesc sourcePd = (BeanDesc.PropDesc)sourcePdMap.get(key);
                    if (null != sourcePd && null != (getter = sourcePd.getGetter())) {
                        try {
                            return getter.invoke(source, new Object[0]);
                        }
                        catch (Exception e) {
                            if (ignoreError) break block3;
                            throw new UtilException(e, "Inject [{}] error!", key);
                        }
                    }
                }
                return null;
            }

            @Override
            public boolean containsKey(String key) {
                return sourcePdMap.containsKey(key);
            }
        }, copyOptions);
    }

    public static class CopyOptions {
        private Class<?> editable;
        private boolean ignoreNullValue;
        private String[] ignoreProperties;
        private boolean ignoreError;

        public static CopyOptions create() {
            return new CopyOptions();
        }

        public static CopyOptions create(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
            return new CopyOptions(editable, ignoreNullValue, ignoreProperties);
        }

        public CopyOptions() {
        }

        public CopyOptions(Class<?> editable, boolean ignoreNullValue, String ... ignoreProperties) {
            this.editable = editable;
            this.ignoreNullValue = ignoreNullValue;
            this.ignoreProperties = ignoreProperties;
        }

        public CopyOptions setEditable(Class<?> editable) {
            this.editable = editable;
            return this;
        }

        public CopyOptions setIgnoreNullValue(boolean ignoreNullVall) {
            this.ignoreNullValue = ignoreNullVall;
            return this;
        }

        public CopyOptions setIgnoreProperties(String ... ignoreProperties) {
            this.ignoreProperties = ignoreProperties;
            return this;
        }

        public CopyOptions setIgnoreError(boolean ignoreError) {
            this.ignoreError = ignoreError;
            return this;
        }
    }

    public static interface ValueProvider<T> {
        public Object value(T var1, Type var2);

        public boolean containsKey(T var1);
    }
}

