/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.extra.mail;

import com.xiaoleilu.hutool.extra.mail.GlobalMailAccount;
import com.xiaoleilu.hutool.extra.mail.MailAccount;
import com.xiaoleilu.hutool.extra.mail.UserPassAuthenticator;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MailUtil {
    private static Log log = LogFactory.get();

    public static void send(String to, String subject, String content, boolean isHtml) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(to);
        MailUtil.send(list, subject, content, isHtml);
    }

    public static void send(Collection<String> tos, String subject, String content, boolean isHtml) {
        try {
            MailUtil.send(GlobalMailAccount.INSTANCE.getAccount(), tos, subject, content, isHtml);
        }
        catch (MessagingException e) {
            log.error("Send mail error!", new Object[]{e});
        }
    }

    public static void send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml) throws MessagingException {
        Session session = MailUtil.createSession(mailAccount);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(mailAccount.getFrom()));
        msg.setSubject(subject);
        msg.setSentDate(new Date());
        if (isHtml) {
            MimeBodyPart html = new MimeBodyPart();
            html.setContent((Object)content, "text/html; charset=utf-8");
            MimeMultipart mainPart = new MimeMultipart();
            mainPart.addBodyPart((BodyPart)html);
        } else {
            msg.setText(content);
        }
        for (String to : tos) {
            msg.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(to));
            Transport.send((Message)msg);
            log.debug("Send mail to {} successed.", to);
        }
    }

    public static Session createSession(MailAccount mailAccount) {
        return Session.getDefaultInstance((Properties)mailAccount.getSmtpProps(), (Authenticator)(mailAccount.isAuth() ? new UserPassAuthenticator(mailAccount.getUser(), mailAccount.getPass()) : null));
    }
}

