/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.aop;

import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.util.ReflectUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Aspect
implements InvocationHandler {
    private Object target;

    public Aspect(Object target) {
        this.target = target;
    }

    public Object getTarget() {
        return this.target;
    }

    public abstract boolean before(Object var1, Method var2, Object[] var3);

    public abstract boolean after(Object var1, Method var2, Object[] var3);

    public abstract boolean afterException(Object var1, Method var2, Object[] var3, Throwable var4);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (this.before(this.target, method, args)) {
            try {
                result = ReflectUtil.invoke(this.target, method, args);
            }
            catch (UtilException e) {
                Throwable cause = e.getCause();
                if (e.getCause() instanceof InvocationTargetException) {
                    this.afterException(this.target, method, args, ((InvocationTargetException)cause).getTargetException());
                }
                throw e;
            }
        }
        if (this.after(this.target, method, args)) {
            return result;
        }
        return null;
    }
}

