/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import java.util.List;
import java.util.StringJoiner;

public class SqlWrapperUtils {
    public static final String DESC_INSERT = "INSERT INTO ";
    public static final String DESC_VALUES = " VALUES ";
    public static final String DESC_INSERT_OR_UPDATE = " ON duplicate key UPDATE ";

    public String insertOrUpdate(String tableName, List<String> tableColumns, List<Object> valueColumns, List<Object> destKeys, List<Object> destvalues) {
        StringBuilder builder = new StringBuilder();
        builder.append(DESC_INSERT).append(tableName);
        StringJoiner paramsStr = new StringJoiner("`,`", "(`", "`)");
        tableColumns.forEach(paramsStr::add);
        builder.append(paramsStr.toString()).append(DESC_VALUES);
        StringJoiner valuesStr = new StringJoiner(",", "(", ")");
        for (Object valueColumn : valueColumns) {
            StringBuilder valueParamBuilder = new StringBuilder();
            String filedType = valueColumn.getClass().getSimpleName();
            if (filedType.equals("Integer") || filedType.equals("Long")) {
                valueParamBuilder.append(valueColumn);
            } else if (filedType.equals("String") || filedType.equals("Boolean")) {
                valueParamBuilder.append("'").append(valueColumn).append("'");
            }
            valuesStr.add(valueParamBuilder);
        }
        builder.append(valuesStr.toString()).append(DESC_INSERT_OR_UPDATE);
        StringJoiner kvStr = new StringJoiner(",", "", "");
        for (int i = 0; i < destKeys.size(); ++i) {
            StringBuilder kvBuilder = new StringBuilder();
            kvBuilder.append(destKeys.get(i)).append("=");
            Object value = destvalues.get(i);
            String filedValueType = value.getClass().getSimpleName();
            if (filedValueType.equals("Integer") || filedValueType.equals("Long")) {
                kvBuilder.append(value);
            } else if (filedValueType.equals("String") || filedValueType.equals("Boolean")) {
                kvBuilder.append("'").append(value).append("'");
            }
            kvStr.add(kvBuilder);
        }
        builder.append(kvStr.toString()).append(";");
        return builder.toString();
    }
}

