/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PagingListStreamUtil<T> {
    private int totalPage = 0;
    private int curPageNo = 0;
    private int pageSize = 0;
    private static final int DEFAULT_PAGE_SIZE = 500;
    private List<T> currentPageData;
    private List<T> instanceList = null;

    public PagingListStreamUtil(List<T> pageResult, int pageSize) {
        this.pageSize = pageSize;
        this.instanceList = pageResult;
        this.init(pageResult, pageSize);
    }

    public PagingListStreamUtil(List<T> pageResult) {
        this(pageResult, 500);
    }

    private void init(List<T> pageResult, int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Paging size must be greater than zero.");
        }
        if (null == pageResult) {
            throw new NullPointerException("Paging resource list must be not null.");
        }
        this.totalPage = pageResult.size() % pageSize > 0 ? pageResult.size() / pageSize + 1 : pageResult.size() / pageSize;
    }

    private int getSurplusPage() {
        if (this.instanceList.size() % this.pageSize > 0) {
            return this.instanceList.size() / this.pageSize + 1;
        }
        return this.instanceList.size() / this.pageSize;
    }

    public boolean hasNext() {
        return this.instanceList.size() > 0;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public List<T> next() {
        List pagingData = this.instanceList.stream().limit(this.pageSize).collect(Collectors.toList());
        this.instanceList = this.instanceList.stream().skip(this.pageSize).collect(Collectors.toList());
        return pagingData;
    }

    public int getCurPageNo() {
        return this.totalPage - this.getSurplusPage();
    }

    public List<T> getCurrentPageData() {
        return this.currentPageData;
    }

    public void setCurrentPageData(List<T> currentPageData) {
        this.currentPageData = currentPageData;
    }

    public void setCurPageNo(int curPageNo) {
        this.curPageNo = curPageNo < 1 ? 1 : (curPageNo > this.totalPage ? this.totalPage : curPageNo);
        this.setCurrentPageData(this.currentPageData());
    }

    public List<T> currentPageData() {
        if (this.pageSize == 0 || this.totalPage == 1 || this.totalPage == 0) {
            return this.instanceList;
        }
        ArrayList currentPageData = new ArrayList();
        this.instanceList.stream().skip((this.curPageNo - 1) * this.pageSize).limit(this.pageSize).forEach(e -> currentPageData.add(e));
        return currentPageData;
    }
}

