/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import com.webank.wedatasphere.schedulis.common.log.LogFilterEntity;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.core.filter.RegexFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static Logger logger = LoggerFactory.getLogger(LogUtils.class);
    private static final LoggerContext ctx = LoggerContext.getContext((boolean)false);
    private static final Configuration config = ctx.getConfiguration();

    public static void createFlowLog(String logDir, String logFileName, String logName) {
        if (config.getAppender(logName) != null) {
            return;
        }
        PatternLayout layout = PatternLayout.newBuilder().withCharset(Charset.forName("UTF-8")).withConfiguration(config).withPattern("%d{dd-MM-yyyy HH:mm:ss z} %c{1} %p - %m\n").build();
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withName(logName)).withImmediateFlush(true)).withFileName(String.format(logDir + File.separator + "%s", logFileName)).withLayout((Layout)layout)).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef[] refs = new AppenderRef[]{AppenderRef.createAppenderRef((String)logName, (Level)Level.ALL, null)};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)logName, (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, Level.ALL, null);
        config.addLogger(logName, loggerConfig);
        ctx.updateLoggers(config);
    }

    public static void createJobLog(String logDir, String logFileName, String logName, String logFileSize, int logFileNum, List<LogFilterEntity> logFilterEntityList) {
        if (config.getAppender(logName) != null) {
            return;
        }
        PatternLayout layout = PatternLayout.newBuilder().withCharset(Charset.forName("UTF-8")).withConfiguration(config).withPattern("%d{dd-MM-yyyy HH:mm:ss z} %c{1} %p - %m\n").build();
        SizeBasedTriggeringPolicy tp = SizeBasedTriggeringPolicy.createPolicy((String)logFileSize);
        CompositeTriggeringPolicy policyComposite = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{tp});
        DefaultRolloverStrategy defaultRolloverStrategy = DefaultRolloverStrategy.newBuilder().withMax(String.valueOf(logFileNum)).build();
        CompositeFilter compositeFilter = null;
        if (CollectionUtils.isNotEmpty(logFilterEntityList)) {
            ArrayList<RegexFilter> filterList = new ArrayList<RegexFilter>();
            for (int i = 0; i < logFilterEntityList.size(); ++i) {
                try {
                    LogFilterEntity logFilterEntity = logFilterEntityList.get(i);
                    RegexFilter filter = i < logFilterEntityList.size() - 1 ? RegexFilter.createFilter((String)logFilterEntity.getCompareText(), null, (Boolean)false, (Filter.Result)Filter.Result.DENY, (Filter.Result)Filter.Result.NEUTRAL) : RegexFilter.createFilter((String)logFilterEntity.getCompareText(), null, (Boolean)false, (Filter.Result)Filter.Result.DENY, (Filter.Result)Filter.Result.ACCEPT);
                    filterList.add(filter);
                    continue;
                }
                catch (Exception e) {
                    logger.warn("create log filter failed.", (Throwable)e);
                }
            }
            compositeFilter = CompositeFilter.createFilters((Filter[])filterList.toArray(new Filter[filterList.size()]));
        }
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withName(logName)).withImmediateFlush(true)).withFileName(String.format(logDir + File.separator + "%s", logFileName)).withFilePattern(logDir + File.separator + logFileName + ".%i").withLayout((Layout)layout)).withPolicy((TriggeringPolicy)policyComposite).withStrategy((RolloverStrategy)defaultRolloverStrategy).build();
        appender.start();
        config.addAppender((Appender)appender);
        AppenderRef[] refs = new AppenderRef[]{AppenderRef.createAppenderRef((String)logName, (Level)Level.ALL, null)};
        LoggerConfig loggerConfig = LoggerConfig.createLogger((boolean)false, (Level)Level.ALL, (String)logName, (String)"true", (AppenderRef[])refs, null, (Configuration)config, null);
        loggerConfig.addAppender((Appender)appender, Level.ALL, (Filter)compositeFilter);
        config.addLogger(logName, loggerConfig);
        ctx.updateLoggers(config);
    }

    public static void stopLog(String logName) {
        if (config.getAppender(logName) == null) {
            return;
        }
        config.getAppender(logName).stop();
        config.getLoggerConfig(logName).removeAppender(logName);
        config.removeLogger(logName);
        ctx.updateLoggers();
    }
}

