/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import com.webank.wedatasphere.schedulis.common.log.LogCodeType;
import com.webank.wedatasphere.schedulis.common.log.LogFilterEntity;
import com.webank.wedatasphere.schedulis.common.log.OperateType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogErrorCodeFilterUtils {
    public static String handleLogDataFilter(String logData, String logType, List<LogFilterEntity> logFilterList) {
        String logResult = "";
        if ("error".equals(logType)) {
            logResult = LogErrorCodeFilterUtils.handleErrorLog(logData, logFilterList);
        } else if ("info".equals(logType)) {
            logResult = LogErrorCodeFilterUtils.handleInfoLog(logData, logFilterList);
        }
        return logResult;
    }

    private static String handleInfoLog(String logData, List<LogFilterEntity> logFilterList) {
        String infoLog = "";
        StringBuilder sb = new StringBuilder();
        String[] handleData = logData.split("\n");
        String infoBegin = "";
        for (String lineLog : handleData) {
            if (lineLog.contains("Error in query")) {
                infoBegin = "ErrorQuery";
            }
            if (!lineLog.contains(" INFO - ") || lineLog.contains("Exception") || lineLog.contains(" INFO - \t") || lineLog.contains("Error")) continue;
            if ("ErrorQuery".equals(infoBegin)) {
                infoBegin = "End";
                continue;
            }
            if ("".equals(lineLog = LogErrorCodeFilterUtils.handleAllLogFilter(lineLog, logFilterList))) continue;
            sb.append(lineLog).append("\n");
        }
        infoLog = sb.toString();
        return infoLog;
    }

    private static String handleErrorLog(String logData, List<LogFilterEntity> logFilterList) {
        String errorLog = "";
        String nowCutType = "";
        StringBuilder sb = new StringBuilder();
        String[] handleData = logData.split("\n");
        String errorBegin = "";
        for (String lineLog : handleData) {
            if (lineLog.contains(" ERROR - ")) {
                errorBegin = "START";
                nowCutType = "ERROR";
                sb.append(LogErrorCodeFilterUtils.handleExecptionLogFilter(lineLog, logFilterList)).append("\n");
                LogErrorCodeFilterUtils.handleExecptionLogFilterAndErrorCode(sb, lineLog, logFilterList);
            } else if ((lineLog.contains(" ERROR - ") || lineLog.contains(" INFO - ")) && "START".equals(errorBegin) && "ERROR".equals(nowCutType)) {
                errorBegin = "END";
            } else if ("START".equals(errorBegin) && "ERROR".equals(nowCutType)) {
                sb.append(LogErrorCodeFilterUtils.handleExecptionLogFilter(lineLog, logFilterList)).append("\n");
                LogErrorCodeFilterUtils.handleExecptionLogFilterAndErrorCode(sb, lineLog, logFilterList);
            }
            if (lineLog.contains(" INFO - ") && (lineLog.contains("Exception") || lineLog.contains("Error"))) {
                errorBegin = "START";
                nowCutType = "INFO";
                if (lineLog.contains("Error in query")) {
                    errorBegin = "ErrorQuery";
                }
                sb.append(LogErrorCodeFilterUtils.handleExecptionLogFilter(lineLog, logFilterList)).append("\n");
                LogErrorCodeFilterUtils.handleExecptionLogFilterAndErrorCode(sb, lineLog, logFilterList);
                continue;
            }
            if (lineLog.contains(" INFO - ") && !lineLog.contains("Exception") && !lineLog.contains(" INFO - \t") && "INFO".equals(nowCutType) && !"ErrorQuery".equals(errorBegin)) {
                errorBegin = "END";
                continue;
            }
            if (!"START".equals(errorBegin) && !"ErrorQuery".equals(errorBegin) || !"INFO".equals(nowCutType)) continue;
            sb.append(LogErrorCodeFilterUtils.handleExecptionLogFilter(lineLog, logFilterList)).append("\n");
            LogErrorCodeFilterUtils.handleExecptionLogFilterAndErrorCode(sb, lineLog, logFilterList);
            if (!"ErrorQuery".equals(errorBegin)) continue;
            errorBegin = "END";
        }
        errorLog = sb.toString();
        return errorLog;
    }

    private static void handleExecptionLogFilterAndErrorCode(StringBuilder sb, String logLine, List<LogFilterEntity> logFilterList) {
        for (LogFilterEntity logFilter : logFilterList) {
            List<String> result;
            if (LogCodeType.ERROR != logFilter.getCodeType() || (result = LogErrorCodeFilterUtils.regexMathc(logLine, logFilter.getCompareText())).size() <= 0 || OperateType.ADD != logFilter.getOperateType()) continue;
            sb.append("<font color='red'>");
            sb.append("\u9519\u8bef\u7801: " + logFilter.getLogCode() + " \u9519\u8bef\u8bf4\u660e: " + LogErrorCodeFilterUtils.logKeyWordReplace(logFilter.getLogNotice(), result) + "\n");
            sb.append("</font>");
        }
    }

    private static String handleExecptionLogFilter(String logLine, List<LogFilterEntity> logFilterList) {
        String filterLog = logLine;
        for (LogFilterEntity logFilter : logFilterList) {
            if (LogCodeType.ERROR != logFilter.getCodeType() || !logLine.contains(logFilter.getCompareText()) || OperateType.REMOVE != logFilter.getOperateType()) continue;
            int azkabanLog = logLine.indexOf(logFilter.getCompareText()) + logFilter.getCompareText().length();
            filterLog = logLine.substring(azkabanLog, logLine.length());
        }
        return filterLog;
    }

    private static String handleAllLogFilter(String logLine, List<LogFilterEntity> logFilterList) {
        String filterLog = logLine;
        for (LogFilterEntity logFilter : logFilterList) {
            if (LogCodeType.INFO != logFilter.getCodeType() || !filterLog.contains(logFilter.getCompareText())) continue;
            if (OperateType.REMOVE == logFilter.getOperateType()) {
                int azkabanLog = filterLog.indexOf(logFilter.getCompareText()) + logFilter.getCompareText().length();
                filterLog = filterLog.substring(azkabanLog, filterLog.length());
            }
            if (OperateType.REMOVE_ALL != logFilter.getOperateType()) continue;
            filterLog = "";
        }
        return filterLog;
    }

    private static List<String> regexMathc(String linglog, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern datePattern = Pattern.compile(regex);
        Matcher dateMatcher = datePattern.matcher(linglog);
        while (dateMatcher.find()) {
            result.add(dateMatcher.group().trim());
        }
        return result;
    }

    private static String logKeyWordReplace(String logNotic, List<String> keyWord) {
        for (int i = 0; i < keyWord.size(); ++i) {
            logNotic = logNotic.replace("#" + i + "#", keyWord.get(i));
        }
        return logNotic;
    }

    public static String handleErrorLogMarkedRed(String logData) {
        String logResult = "";
        logResult = LogErrorCodeFilterUtils.errorLogRedFont(logData);
        return logResult;
    }

    private static String errorLogRedFont(String logData) {
        String errorLog = "";
        String nowCutType = "";
        StringBuilder sb = new StringBuilder();
        String[] handleData = logData.split("\n");
        String errorBegin = "";
        for (String lineLog : handleData) {
            if (lineLog.contains(" ERROR - ")) {
                errorBegin = "START";
                nowCutType = "ERROR";
                LogErrorCodeFilterUtils.handleExecptionLogRedFont(sb, lineLog);
                continue;
            }
            if ((lineLog.contains(" ERROR - ") || lineLog.contains(" INFO - ")) && "START".equals(errorBegin) && "ERROR".equals(nowCutType)) {
                errorBegin = "END";
                sb.append(lineLog).append("\n");
                continue;
            }
            if ("START".equals(errorBegin) && "ERROR".equals(nowCutType)) {
                LogErrorCodeFilterUtils.handleExecptionLogRedFont(sb, lineLog);
                continue;
            }
            if (lineLog.contains(" INFO - ") && (lineLog.contains("Exception") || lineLog.contains("Error") || lineLog.contains("Execution"))) {
                errorBegin = "START";
                nowCutType = "INFO";
                if (lineLog.contains("Error in query")) {
                    errorBegin = "ErrorQuery";
                }
                LogErrorCodeFilterUtils.handleExecptionLogRedFont(sb, lineLog);
                continue;
            }
            if (lineLog.contains(" INFO - ") && !lineLog.contains("Exception") && !lineLog.contains(" INFO - \t") && "INFO".equals(nowCutType) && !"ErrorQuery".equals(errorBegin)) {
                errorBegin = "END";
                sb.append(lineLog).append("\n");
                continue;
            }
            if (("START".equals(errorBegin) || "ErrorQuery".equals(errorBegin)) && "INFO".equals(nowCutType)) {
                LogErrorCodeFilterUtils.handleExecptionLogRedFont(sb, lineLog);
                if (!"ErrorQuery".equals(errorBegin)) continue;
                errorBegin = "END";
                continue;
            }
            sb.append(lineLog).append("\n");
        }
        errorLog = sb.toString();
        return errorLog;
    }

    private static void handleExecptionLogRedFont(StringBuilder sb, String lineLog) {
        sb.append("<font color='red'>");
        sb.append(lineLog);
        sb.append("</font>").append("\n");
    }

    public static String handleYarnLogDataFilter(String logData) {
        String logResult = "";
        StringBuilder sb = new StringBuilder();
        HashSet<String> yarnSet = new HashSet<String>();
        String[] handleData = logData.split("\n");
        Pattern APPLICATION_ID_PATTERN = Pattern.compile("(application_\\d+_\\d+).*");
        for (String lineLog : handleData) {
            Matcher m = APPLICATION_ID_PATTERN.matcher(lineLog);
            if (!m.find()) continue;
            String appId = m.group(1);
            yarnSet.add(appId);
        }
        Pattern Job_ID_PATTERN = Pattern.compile("(job_\\d+_\\d+).*");
        for (String lineLog : handleData) {
            Matcher m = Job_ID_PATTERN.matcher(lineLog);
            if (!m.find()) continue;
            String appId = m.group(1);
            appId = appId.replace("job", "application");
            yarnSet.add(appId);
        }
        for (String appId : yarnSet) {
            sb.append(appId).append("\n");
        }
        logResult = sb.toString();
        return logResult;
    }
}

