/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import azkaban.utils.Props;
import java.nio.charset.Charset;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapCheckCenter {
    private static final Logger logger = LoggerFactory.getLogger((String)LdapCheckCenter.class.getName());
    private static volatile LDAPConnectionFactory lcf;

    public static boolean checkLogin(Props props, String userName, String password) {
        String ip = props.getString("ladp.ip");
        int port = props.getInt("ladp.port");
        LdapCheckCenter.setupLCF(ip, port);
        Connection conn = null;
        try {
            conn = lcf.getConnection();
        }
        catch (LdapException e) {
            logger.error("LdapCheckCenter LDAP-->connecting failed. please check ip :" + ip + " port: " + port, (Throwable)e);
            return false;
        }
        logger.info("LdapCheckCenter LDAP-->Connect to host: " + ip + " success");
        SimpleBindRequest request3 = Requests.newSimpleBindRequest((String)userName, (byte[])password.getBytes(Charset.defaultCharset()));
        try {
            conn.bind((BindRequest)request3);
            logger.info("LdapCheckCenter LDAP-->auth " + userName + " success. ");
            return true;
        }
        catch (LdapException e) {
            logger.error("LdapCheckCenter LDAP-->Bind " + userName + " failed.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LDAPConnectionFactory setupLCF(String ip, int port) {
        if (lcf != null) return lcf;
        Class<LDAPConnectionFactory> clazz = LDAPConnectionFactory.class;
        synchronized (LDAPConnectionFactory.class) {
            if (lcf != null) return lcf;
            lcf = new LDAPConnectionFactory(ip, port);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return lcf;
        }
    }
}

