/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import com.webank.wedatasphere.schedulis.common.utils.GsonUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.CompressionCodecs;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class JwtTokenUtils {
    private Key key;
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;

    public static String getTokenByJson(Map<String, Object> claimMaps, String encryKey, int secondTimeOut) {
        return JwtTokenUtils.getToken(claimMaps, true, encryKey, secondTimeOut);
    }

    public static String getToken(Map<String, Object> claimMaps, boolean isJsonMpas, String encryKey, int secondTimeOut) {
        if (isJsonMpas) {
            claimMaps.forEach((key, val) -> claimMaps.put((String)key, GsonUtils.toJson(val)));
        }
        long currentTime = System.currentTimeMillis();
        byte[] apiKeySecretBytes = encryKey.getBytes(StandardCharsets.UTF_8);
        return Jwts.builder().setId(UUID.randomUUID().toString()).setIssuedAt(new Date(currentTime)).setExpiration(new Date(currentTime + (long)(secondTimeOut * 1000))).setSubject("webserver_to_executorserver").setAudience("executorservercontainer").setIssuer("webservercontainer").compressWith(CompressionCodecs.GZIP).signWith(SignatureAlgorithm.HS256, apiKeySecretBytes).addClaims(claimMaps).compact();
    }

    private static Jws<Claims> getJws(String token, String encryKey) {
        byte[] apiKeySecretBytes = encryKey.getBytes(StandardCharsets.UTF_8);
        return Jwts.parser().setSigningKey(apiKeySecretBytes).parseClaimsJws(token);
    }

    public static String getSignature(String token, String encryKey) {
        try {
            return JwtTokenUtils.getJws(token, encryKey).getSignature();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static JwsHeader getHeader(String token, String encryKey) {
        try {
            return (JwsHeader)JwtTokenUtils.getJws(token, encryKey).getHeader();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Claims getClaimsBody(String token, String encryKey) {
        return (Claims)JwtTokenUtils.getJws(token, encryKey).getBody();
    }

    public static Object getVal(String token, String encryKey, String key) {
        return ((Claims)JwtTokenUtils.getJws(token, encryKey).getBody()).get((Object)key);
    }

    public static <T> T getValByT(String token, String encryKey, String key, Class<T> tClass) {
        try {
            String strJson = JwtTokenUtils.getVal(token, encryKey, key).toString();
            return GsonUtils.fromJson(strJson, tClass);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isExpiration(String token, String encryKey) {
        try {
            return JwtTokenUtils.getClaimsBody(token, encryKey).getExpiration().before(new Date());
        }
        catch (ExpiredJwtException ex) {
            return true;
        }
    }

    public static String getSubject(String token, String encryKey) {
        try {
            return JwtTokenUtils.getClaimsBody(token, encryKey).getSubject();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static void main(String[] args) {
        String token = JwtTokenUtils.getToken(null, false, "dws-wtss|WeBankBDPWTSS&DWS@2019", 604800);
        System.out.println("testEncode: " + token);
        Claims claims = (Claims)JwtTokenUtils.getJws(token, "dws-wtss|WeBankBDPWTSS&DWS@2019").getBody();
        System.out.println("ID: " + claims.getId());
        System.out.println("Subject: " + claims.getSubject());
        System.out.println("Issuer: " + claims.getIssuer());
        System.out.println("Audience: " + claims.getAudience());
        System.out.println("Expiration: " + claims.getExpiration());
    }
}

