/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import azkaban.executor.ExecutableFlow;
import azkaban.executor.Status;
import azkaban.utils.Props;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.webank.wedatasphere.schedulis.common.utils.GsonUtils;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    public static Map<String, String> getReturnMap(String dataStr) {
        HashMap<String, String> dataMap = new HashMap();
        GsonBuilder gb = new GsonBuilder();
        Gson g = gb.create();
        dataMap = (Map)g.fromJson(dataStr, new TypeToken<Map<String, String>>(){}.getType());
        return dataMap;
    }

    public static String httpClientIMSHandle(String actionUrl, RequestBody requestBody, Map<String, String> urlMap) throws Exception {
        String maskUrl = actionUrl;
        OkHttpClient okHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).build();
        Request request = new Request.Builder().url(maskUrl).post(requestBody).build();
        Call call = okHttpClient.newCall(request);
        Response response = call.execute();
        return response.body().string();
    }

    public static String getValue(Props props, String key) {
        if (StringUtils.isNotBlank((String)props.get((Object)key))) {
            return props.get((Object)key) == null ? props.get((Object)key) : props.get((Object)key).trim();
        }
        if (props.getParent() != null && StringUtils.isNotBlank((String)props.getParent().get((Object)key))) {
            return props.getParent().get((Object)key) == null ? props.getParent().get((Object)key) : props.getParent().get((Object)key).trim();
        }
        return null;
    }

    public static void registerToIMS(ExecutableFlow executableFlow, Props azkabanProps, Props flowPros, Logger logger) {
        String request = null;
        String actionUrl = null;
        try {
            if (executableFlow.getFlowType() != 3) {
                logger.info("\u975e\u5b9a\u65f6\u8c03\u5ea6\u4efb\u52a1, \u65e0\u9700\u4e0a\u62a5IMS");
                return;
            }
            if (flowPros == null || HttpUtils.getValue(flowPros, "reportIMS") == null || !HttpUtils.getValue(flowPros, "reportIMS").trim().toLowerCase().equals("true")) {
                logger.info("\u6ca1\u6709\u8bbe\u7f6e\u4e0a\u62a5IMS.");
                return;
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            ArrayList<HashMap<String, String>> dataList = new ArrayList<HashMap<String, String>>();
            String subSystemId = HttpUtils.getValue(flowPros, "subSystemId");
            dataMap.put("subsystem_id", subSystemId == null ? azkabanProps.get((Object)"ims.job.report.subSystemId") : subSystemId);
            dataMap.put("jobCode", executableFlow.getFlowId());
            dataMap.put("jobZhName", executableFlow.getFlowId());
            dataMap.put("planStartTime", HttpUtils.getValue(flowPros, "planStartTime"));
            dataMap.put("planFinishTime", HttpUtils.getValue(flowPros, "planFinishTime"));
            dataMap.put("lastStartTime", HttpUtils.getValue(flowPros, "lastStartTime"));
            dataMap.put("lastFinishTime", HttpUtils.getValue(flowPros, "lastFinishTime"));
            dataMap.put("groupName", executableFlow.getProjectName());
            dataMap.put("number", HttpUtils.getValue(flowPros, "dcnNumber"));
            dataList.add(dataMap);
            request = GsonUtils.toJson(dataList);
            actionUrl = azkabanProps.getString("ims.job.register.url", null);
            if (actionUrl == null) {
                logger.error("\u83b7\u53d6\u6ce8\u518c\u63a5\u53e3\u5931\u8d25");
                return;
            }
            logger.info("url is : " + actionUrl + " requestBody is " + request);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6ims\u914d\u7f6e\u53c2\u6570\u5931\u8d25" + e);
            return;
        }
        try {
            MediaType applicationJson = MediaType.parse((String)"application/json;charset=utf-8");
            RequestBody requestBody = RequestBody.create((MediaType)applicationJson, (String)request);
            logger.info("register to IMS, flowId is " + executableFlow.getFlowId());
            String result = HttpUtils.httpClientIMSHandle(actionUrl, requestBody, null);
            logger.info("register result is : " + result);
        }
        catch (Exception e) {
            logger.error("registerToIMS, failed," + e);
        }
    }

    public static void uploadFlowStatusToIMS(ExecutableFlow executableFlow, Props azkabanProps, Props flowPros, Logger logger) {
        String dcnNumbers = null;
        String jobCode = null;
        String jobDate = null;
        String alertLevel = null;
        String actionUrl = null;
        String subSystemId = null;
        String localHost = null;
        String status = null;
        try {
            if (executableFlow.getFlowType() != 3) {
                logger.info("\u975e\u5b9a\u65f6\u8c03\u5ea6\u4efb\u52a1, \u65e0\u9700\u4e0a\u62a5IMS");
                return;
            }
            if (flowPros == null || HttpUtils.getValue(flowPros, "reportIMS") == null || !HttpUtils.getValue(flowPros, "reportIMS").trim().toLowerCase().equals("true")) {
                return;
            }
            try {
                localHost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                logger.error("cant not get localhost, + " + e);
            }
            logger.info("flow status is " + (Object)((Object)executableFlow.getStatus()));
            Object startTime = null;
            Object entTime = null;
            switch (executableFlow.getStatus()) {
                case PREPARING: 
                case READY: {
                    status = "1";
                    break;
                }
                case KILLED: 
                case FAILED: {
                    status = "3";
                    break;
                }
                case SUCCEEDED: {
                    status = "2";
                    break;
                }
                default: {
                    status = "4";
                }
            }
            dcnNumbers = HttpUtils.getValue(flowPros, "dcnNumber") == null ? "-1" : HttpUtils.getValue(flowPros, "dcnNumber");
            jobCode = executableFlow.getFlowId();
            jobDate = DateTimeFormat.forPattern((String)"yyyyMMdd").print(new Date().getTime());
            alertLevel = HttpUtils.getValue(flowPros, "alertLevel") == null ? "2" : HttpUtils.getValue(flowPros, "alertLevel");
            actionUrl = azkabanProps.get((Object)"ims.job.report.url");
            String string = subSystemId = HttpUtils.getValue(flowPros, "subSystemId") == null ? azkabanProps.get((Object)"ims.job.report.subSystemId") : HttpUtils.getValue(flowPros, "subSystemId");
            if (actionUrl == null) {
                logger.error("\u83b7\u53d6\u6ce8\u518c\u63a5\u53e3\u5931\u8d25");
                return;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6ims\u914d\u7f6e\u53c2\u6570\u5931\u8d25" + e);
            return;
        }
        try {
            for (String dcnNumber : dcnNumbers.split(",")) {
                FormBody requestBody = new FormBody.Builder().add("subSystemId", subSystemId).add("jobCode", jobCode).add("jobDate", jobDate).add("ip", localHost).add("dcnNumber", dcnNumber).add("status", status).add("alertLevel", alertLevel).build();
                logger.info(String.format("url is : " + actionUrl + ", params is : subSystemId=%s&jobCode=%s&jobDate=%s&ip=%s&dcnNumber=%s&status=%s&alertLevel=%s", subSystemId, jobCode, jobDate, localHost, dcnNumber, status, alertLevel));
                logger.info("upload flow status to IMS, flowId is " + executableFlow.getFlowId());
                String result = HttpUtils.httpClientIMSHandle(actionUrl, (RequestBody)requestBody, null);
                logger.info("result is : " + result);
            }
        }
        catch (Exception e) {
            logger.error("send request failed," + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFlowStatusToIMS(ExecutableFlow executableFlow, Props azkabanProps) {
        logger.info("===============\u5f00\u59cb\u5411IMS\u4e0a\u62a5\u5de5\u4f5c\u6d41\uff1a" + executableFlow.getFlowId());
        try {
            String actionUrl = azkabanProps.get((Object)"ims.job.report.url");
            logger.info("===============IMS\u4e0a\u62a5\u5730\u5740\uff1a" + actionUrl);
            String subSystemId = azkabanProps.get((Object)"ims.job.report.subSystemId");
            logger.info("===============IMS\u4e0a\u62a5\u5b50\u7cfb\u7edfId\uff1a" + subSystemId);
            logger.info("===============IMS\u4e0a\u62a5\u5b50\u5de5\u4f5c\u6d41\uff1a" + executableFlow.getFlowId());
            Date date = new Date(executableFlow.getStartTime());
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            LocalDate localDate = instant.atZone(zone).toLocalDate();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
            String jobDate = localDate.format(dtf);
            logger.info("===============IMS\u4e0a\u62a5\u5b50\u65e5\u671f\uff1a" + jobDate);
            String ip = InetAddress.getLocalHost().getHostAddress();
            logger.info("===============IMS\u4e0a\u62a5\u5b50IP\uff1a" + ip);
            int status = 1;
            if (Status.FAILED == executableFlow.getStatus()) {
                status = 3;
            } else if (Status.SUCCEEDED == executableFlow.getStatus()) {
                status = 2;
            }
            String alertLevel = azkabanProps.get((Object)"ims.job.report.alertLevel");
            String remark = "\u9879\u76ee\u540d: " + executableFlow.getProjectName() + ", \u5de5\u4f5c\u6d41\u540d\u79f0\uff1a " + executableFlow.getFlowId();
            FormBody requestBody = new FormBody.Builder().add("subSystemId", subSystemId).add("jobCode", executableFlow.getFlowId()).add("jobDate", jobDate).add("ip", ip).add("status", status + "").add("alertLevel", alertLevel).add("remark", remark).build();
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("", executableFlow.getFlowId());
            String result = HttpUtils.httpClientIMSHandle(actionUrl, (RequestBody)requestBody, urlMap);
            logger.info("===============IMS\u4e0a\u62a5\u7ed3\u679c\uff1a" + result);
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5de5\u4f5c\u6d41\u544a\u8b66\u4e0a\u62a5\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        }
        finally {
            logger.info("===============IMS\u4e0a\u62a5\u7ed3\u675f");
        }
    }

    public static String getLinuxLocalIp(Logger log) {
        String ip = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                String name = intf.getName();
                if (name.contains("docker") || name.contains("lo")) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    String ipaddress;
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || (ipaddress = inetAddress.getHostAddress().toString()).contains("::") || ipaddress.contains("0:0:") || ipaddress.contains("fe80")) continue;
                    ip = ipaddress;
                }
            }
        }
        catch (SocketException ex) {
            log.warn("get ip failed", (Throwable)ex);
        }
        log.info("current host IP:   " + ip);
        return ip;
    }

    public static void main(String[] args) {
    }
}

