/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import azkaban.utils.Props;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

public class HadoopJobUtils {
    public static final Pattern APPLICATION_ID_PATTERN = Pattern.compile("application_\\d+_\\d+");
    public static final Pattern BDP_CLIENT_JOB_ID_PATTERN = Pattern.compile("job_\\d+_\\d+");
    public static final String BDP_CLIENT_CONF_FILE = "bdp.client.conf.file";

    public static void killAllHadoopJobs(String logFilePath, Logger log) {
        Set<Object> allSpawnedJobs = new HashSet();
        try {
            allSpawnedJobs = HadoopJobUtils.findIdFromLog(logFilePath, log, APPLICATION_ID_PATTERN);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        log.info("applicationIds to kill: " + allSpawnedJobs);
        for (String string : allSpawnedJobs) {
            try {
                HadoopJobUtils.killByCommand(String.format("yarn application -kill %s", string), log);
            }
            catch (Throwable t) {
                log.warn("something happened while trying to kill this job: " + string, t);
            }
        }
    }

    public static void killBdpClientJob(List<String> commands, String logFilePath, Logger log, Props sysProps) {
        if (CollectionUtils.isEmpty(commands)) {
            log.info("command is empty.");
            return;
        }
        Set<Object> jobIds = new HashSet();
        try {
            jobIds = HadoopJobUtils.findIdFromLog(logFilePath, log, BDP_CLIENT_JOB_ID_PATTERN);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
        log.info("bdp client job ids: " + jobIds);
        for (String string : jobIds) {
            try {
                HadoopJobUtils.killByCommand(String.format("bdp-client -c %s job kill -j %s", sysProps.getString(BDP_CLIENT_CONF_FILE, ""), string), log);
            }
            catch (Throwable t) {
                log.warn("something happened while trying to kill this job: " + string, t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> findIdFromLog(String logFilePath, Logger log, Pattern pattern) {
        File logFile = new File(logFilePath);
        if (!logFile.exists()) {
            throw new IllegalArgumentException("the logFilePath does not exist: " + logFilePath);
        }
        if (!logFile.isFile()) {
            throw new IllegalArgumentException("the logFilePath specified  is not a valid file: " + logFilePath);
        }
        if (!logFile.canRead()) {
            throw new IllegalArgumentException("unable to read the logFilePath specified: " + logFilePath);
        }
        BufferedReader br = null;
        HashSet<String> applicationIds = new HashSet<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(logFile));
            while ((line = br.readLine()) != null) {
                String[] inputs = line.split("\\s");
                if (inputs == null) continue;
                for (String input : inputs) {
                    Matcher m = pattern.matcher(input);
                    if (!m.find()) continue;
                    String appId = m.group(0);
                    applicationIds.add(appId);
                }
            }
        }
        catch (IOException e) {
            log.error("Error while trying to find applicationId for log", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
        return applicationIds;
    }

    public static void killByCommand(String cmd, Logger log) {
        log.info("exec cmd: " + cmd);
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException io) {
            log.error("exec cmd failed.", (Throwable)io);
        }
    }
}

