/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import com.webank.wedatasphere.schedulis.common.jobExecutor.utils.Date;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");

    public static int getQuarter(LocalDate date) {
        return (date.getMonthOfYear() - 1) / 3 + 1;
    }

    public static boolean isFirstYear(LocalDate date) {
        return date.getMonthOfYear() < 7;
    }

    public static LocalDate getQuarterBegin(LocalDate localDate) {
        int year = localDate.getYear();
        LocalDate date = null;
        switch (DateUtils.getQuarter(localDate)) {
            case 1: {
                date = LocalDate.parse((String)(year + "0101"), (DateTimeFormatter)dateTimeFormatter);
                break;
            }
            case 2: {
                date = LocalDate.parse((String)(year + "0401"), (DateTimeFormatter)dateTimeFormatter);
                break;
            }
            case 3: {
                date = LocalDate.parse((String)(year + "0701"), (DateTimeFormatter)dateTimeFormatter);
                break;
            }
            case 4: {
                date = LocalDate.parse((String)(year + "1001"), (DateTimeFormatter)dateTimeFormatter);
            }
        }
        return date;
    }

    public static LocalDate getQuarterEnd(LocalDate localDate) {
        int year = localDate.getYear();
        LocalDate date = null;
        switch (DateUtils.getQuarter(localDate)) {
            case 1: {
                date = LocalDate.parse((String)(year + "0331"), (DateTimeFormatter)dateTimeFormatter);
                break;
            }
            case 2: {
                date = LocalDate.parse((String)(year + "0630"), (DateTimeFormatter)dateTimeFormatter);
                break;
            }
            case 3: {
                date = LocalDate.parse((String)(year + "0930"), (DateTimeFormatter)dateTimeFormatter);
                break;
            }
            case 4: {
                date = LocalDate.parse((String)(year + "1231"), (DateTimeFormatter)dateTimeFormatter);
            }
        }
        return date;
    }

    public static LocalDate getHalfYearBegin(LocalDate localDate) {
        int year = localDate.getYear();
        LocalDate date = DateUtils.isFirstYear(localDate) ? LocalDate.parse((String)(year + "0101"), (DateTimeFormatter)dateTimeFormatter) : LocalDate.parse((String)(year + "0701"), (DateTimeFormatter)dateTimeFormatter);
        return date;
    }

    public static LocalDate getHalfYearEnd(LocalDate localDate) {
        int year = localDate.getYear();
        LocalDate date = DateUtils.isFirstYear(localDate) ? LocalDate.parse((String)(year + "0630"), (DateTimeFormatter)dateTimeFormatter) : LocalDate.parse((String)(year + "1231"), (DateTimeFormatter)dateTimeFormatter);
        return date;
    }

    public static LocalDate getYearBegin(LocalDate date) {
        return LocalDate.parse((String)(date.getYear() + "0101"), (DateTimeFormatter)dateTimeFormatter);
    }

    public static LocalDate getYearEnd(LocalDate date) {
        return LocalDate.parse((String)(date.getYear() + "1231"), (DateTimeFormatter)dateTimeFormatter);
    }

    public static LocalDate getLastMonthEnd(LocalDate date) {
        return date.minusMonths(1).dayOfMonth().withMaximumValue();
    }

    public static LocalDate getLastQuarterEnd(LocalDate date) {
        return DateUtils.getQuarterEnd(date.minusMonths(3));
    }

    public static LocalDate getLastYearEnd(LocalDate date) {
        return DateUtils.getYearEnd(date.minusYears(1));
    }

    public static String calDate(Date date, int num, LocalDate localDate) {
        LocalDate tmpDate;
        if (num == 0) {
            tmpDate = localDate;
        } else {
            switch (date.getCalRule()) {
                case "day": {
                    tmpDate = localDate.plusDays(num);
                    break;
                }
                case "month": {
                    if (date.getValue().contains("begin")) {
                        tmpDate = localDate.plusMonths(num).dayOfMonth().withMinimumValue();
                        break;
                    }
                    if (date.getValue().contains("end")) {
                        tmpDate = localDate.plusMonths(num).dayOfMonth().withMaximumValue();
                        break;
                    }
                    tmpDate = localDate.plusMonths(num);
                    break;
                }
                case "quarter": {
                    if (date.getValue().contains("begin")) {
                        tmpDate = localDate.plusMonths(num * 3).dayOfMonth().withMinimumValue();
                        break;
                    }
                    if (date.getValue().contains("end")) {
                        tmpDate = localDate.plusMonths(num * 3).dayOfMonth().withMaximumValue();
                        break;
                    }
                    tmpDate = localDate.plusMonths(num * 3);
                    break;
                }
                case "halfYear": {
                    if (date.getValue().contains("begin")) {
                        tmpDate = localDate.plusMonths(num * 6).dayOfMonth().withMinimumValue();
                        break;
                    }
                    if (date.getValue().contains("end")) {
                        tmpDate = localDate.plusMonths(num * 6).dayOfMonth().withMaximumValue();
                        break;
                    }
                    tmpDate = localDate.plusMonths(num * 6);
                    break;
                }
                default: {
                    tmpDate = date.getValue().contains("begin") ? localDate.plusYears(num).dayOfMonth().withMinimumValue() : (date.getValue().contains("end") ? localDate.plusYears(num).dayOfMonth().withMaximumValue() : localDate.plusYears(num));
                }
            }
        }
        return tmpDate.toString(date.getFormat());
    }
}

