/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.utils;

import azkaban.flow.Flow;
import azkaban.flow.Node;
import azkaban.project.Project;
import azkaban.scheduler.ScheduleManagerException;
import azkaban.sla.SlaOption;
import azkaban.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.joda.time.Minutes;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertUtil {
    private static final Logger logger = LoggerFactory.getLogger(AlertUtil.class);

    public static SlaOption parseSlaSetting(String set, Flow flow, Project project) throws ScheduleManagerException {
        logger.info("Tryint to set sla with the following set: " + set);
        ArrayList<String> slaActions = new ArrayList<String>();
        HashMap<String, Object> slaInfo = new HashMap<String, Object>();
        String[] parts = set.split(",", -1);
        String id = parts[0];
        String rule = parts[1];
        String duration = parts[2];
        String level = parts[3];
        String emailAction = parts[4];
        String killAction = parts[5];
        List<Flow> embeddedFlows = project.getFlows();
        if (emailAction.equals("true") || killAction.equals("true")) {
            ReadablePeriod dur;
            String slaType;
            if (emailAction.equals("true")) {
                slaActions.add("SlaAlert");
                slaInfo.put("SlaAlertType", "email");
            }
            if (killAction.equals("true")) {
                String killActionType = id.equals("") ? "SlaCancelFlow" : "SlaKillJob";
                slaActions.add(killActionType);
            }
            if (id.equals("")) {
                slaType = rule.equals("SUCCESS") ? "FlowSucceed" : "FlowFinish";
            } else {
                Node node = flow.getNode(id);
                if (node != null && "flow".equals(node.getType())) {
                    slaInfo.put("JobName", id);
                    slaInfo.put("embeddedId", node.getEmbeddedFlowId());
                } else {
                    slaInfo.put("JobName", id);
                }
                String[] str = id.split(":");
                for (Flow f : embeddedFlows) {
                    Node n = f.getNode(str[str.length - 1]);
                    if (n == null || !n.getType().equals("flow")) continue;
                    logger.info(id + " is embeddedFlow.");
                    slaInfo.put("embeddedId", n.getEmbeddedFlowId());
                    break;
                }
                slaType = rule.equals("SUCCESS") ? "JobSucceed" : "JobFinish";
            }
            try {
                dur = AlertUtil.parseDuration(duration);
            }
            catch (Exception e) {
                throw new ScheduleManagerException("\u5b9a\u65f6\u8c03\u5ea6\u7684\u8d85\u65f6\u65f6\u95f4\u8f93\u5165\u683c\u5f0f\u4e0d\u6b63\u786e!");
            }
            slaInfo.put("Duration", Utils.createPeriodString((ReadablePeriod)dur));
            SlaOption r = new SlaOption(slaType, slaActions, slaInfo, level);
            r.setTimeSet(duration);
            r.setEmailAction(emailAction);
            r.setKillAction(killAction);
            logger.info("Parsing sla as id:" + id + " type:" + slaType + " rule:" + rule + " Duration:" + duration + " actions:" + slaActions);
            return r;
        }
        return null;
    }

    public static ReadablePeriod parseDuration(String duration) {
        int hour = Integer.parseInt(duration.split(":")[0]);
        int min = Integer.parseInt(duration.split(":")[1]);
        return Minutes.minutes((int)(min + hour * 60)).toPeriod();
    }
}

