/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.user;

import azkaban.ServiceProvider;
import azkaban.user.Permission;
import azkaban.user.Role;
import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.user.UserManagerException;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.system.JdbcSystemUserImpl;
import com.webank.wedatasphere.schedulis.common.system.SystemUserLoader;
import com.webank.wedatasphere.schedulis.common.system.SystemUserManagerException;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssPermissions;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssRole;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssUser;
import com.webank.wedatasphere.schedulis.common.utils.LdapCheckCenter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUserManager
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger((String)SystemUserManager.class.getName());
    private HashMap<String, User> users;
    private HashMap<String, String> userPassword;
    private HashMap<String, Role> roles;
    private HashMap<String, Set<String>> groupRoles;
    private HashMap<String, Set<String>> proxyUserMap;
    private Props props;
    @Inject
    private SystemUserLoader systemUserLoader;

    @Inject
    public SystemUserManager(Props props) {
        this.props = props;
        this.systemUserLoader = ServiceProvider.SERVICE_PROVIDER.getInstance(JdbcSystemUserImpl.class);
    }

    public SystemUserManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUser(String username, String password) throws UserManagerException {
        if (username == null || username.trim().isEmpty()) {
            throw new UserManagerException("Empty User Name.");
        }
        if (password == null || password.trim().isEmpty()) {
            throw new UserManagerException("Empty Password.");
        }
        User user = null;
        SystemUserManager systemUserManager = this;
        synchronized (systemUserManager) {
            try {
                WtssUser wtssUser = this.systemUserLoader.getWtssUserByUsername(username);
                if (null == wtssUser) {
                    throw new UserManagerException("Unknown User.");
                }
                user = new User(wtssUser.getUsername());
                wtssUser.setPassword(password);
                if (!LdapCheckCenter.checkLogin(this.props, username, password) && null == this.systemUserLoader.getWtssUserByUsernameAndPassword(wtssUser)) {
                    throw new UserManagerException("Error User Name Or Password.");
                }
                this.initUserAuthority(wtssUser, user);
            }
            catch (Exception e) {
                logger.error("Login error\uff01 caused by {}\uff1a", (Throwable)e);
                throw new UserManagerException("Error User Name Or Password.");
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username, String password, String superUser) throws UserManagerException {
        if (StringUtils.isBlank((String)username)) {
            logger.error("Login by  superuser, username is null");
            throw new UserManagerException("superUser proxy login, username is null");
        }
        User user = null;
        SystemUserManager systemUserManager = this;
        synchronized (systemUserManager) {
            try {
                WtssUser wtssUser = this.systemUserLoader.getWtssUserByUsername(username);
                if (null == wtssUser) {
                    throw new UserManagerException("User does not exists");
                }
                user = new User(wtssUser.getUsername());
                wtssUser.setPassword(password);
                this.initUserAuthority(wtssUser, user);
            }
            catch (Exception e) {
                logger.error("Login error\uff01cased by {}\uff1a", (Throwable)e);
                throw new UserManagerException("Error User Name Or Password.");
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String username) throws UserManagerException {
        if (username == null || username.trim().isEmpty()) {
            throw new UserManagerException("Empty User Name.");
        }
        User user = null;
        SystemUserManager systemUserManager = this;
        synchronized (systemUserManager) {
            try {
                WtssUser wtssUser = this.systemUserLoader.getWtssUserByUsername(username);
                if (null == wtssUser) {
                    throw new UserManagerException("Unknown User.");
                }
                user = new User(wtssUser.getUsername());
                wtssUser.setPassword("");
                this.initUserAuthority(wtssUser, user);
            }
            catch (Exception e) {
                throw new UserManagerException("Error User Name.");
            }
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUserAuthority(WtssUser wtssUser, User user) {
        HashMap<String, User> users = new HashMap<String, User>();
        HashMap userPassword = new HashMap();
        HashMap<String, Role> roles = new HashMap<String, Role>();
        HashMap groupRoles = new HashMap();
        HashMap proxyUserMap = new HashMap();
        try {
            users.put(wtssUser.getUsername(), user);
            WtssRole wtssRole = this.systemUserLoader.getWtssRoleById(wtssUser.getRoleId());
            List<WtssPermissions> wtssPermissionsList = this.systemUserLoader.getWtssPermissionsListByIds(wtssRole.getPermissionsIds());
            ArrayList<String> permissionsNameList = new ArrayList<String>();
            for (WtssPermissions wtssPermissions : wtssPermissionsList) {
                permissionsNameList.add(wtssPermissions.getPermissionsName());
            }
            Permission perm = new Permission();
            for (String permName : permissionsNameList) {
                try {
                    Permission.Type type = Permission.Type.valueOf(permName);
                    perm.addPermission(type);
                }
                catch (IllegalArgumentException e) {
                    logger.error("\u6dfb\u52a0\u6743\u9650 " + permName + "\u9519\u8bef. \u6743\u9650\u4e0d\u5b58\u5728.", (Throwable)e);
                }
            }
            Role role = new Role(wtssRole.getRoleName(), perm);
            user.addRole(role.getName());
            roles.put(wtssRole.getRoleName(), role);
            String proxyUsers = wtssUser.getProxyUsers();
            if (StringUtils.isNotEmpty((String)proxyUsers)) {
                String[] proxySplit;
                for (String proxyUser : proxySplit = proxyUsers.split("\\s*,\\s*")) {
                    HashSet<String> proxySet = new HashSet<String>();
                    user.addProxyUser(proxyUser);
                    proxySet.add(proxyUser);
                    proxyUserMap.put(wtssUser.getUsername(), proxySet);
                }
            }
            user.setRoleMap(roles);
        }
        catch (SystemUserManagerException e) {
            logger.error("\u7528\u6237\u6743\u9650\u7ec4\u88c5\u5931\u8d25\uff01", (Throwable)e);
        }
        SystemUserManager systemUserManager = this;
        synchronized (systemUserManager) {
            this.users = users;
            this.userPassword = userPassword;
            this.roles = roles;
            this.proxyUserMap = proxyUserMap;
            this.groupRoles = groupRoles;
        }
    }

    @Override
    public boolean validateUser(String username) {
        return this.users.containsKey(username);
    }

    @Override
    public boolean validateGroup(String group) {
        return true;
    }

    @Override
    public Role getRole(String roleName) {
        return this.roles.get(roleName);
    }

    @Override
    public boolean validateProxyUser(String proxyUser, User realUser) {
        return this.proxyUserMap.containsKey(realUser.getUserId()) && this.proxyUserMap.get(realUser.getUserId()).contains(proxyUser);
    }
}

