/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.system.common;

import azkaban.user.User;
import azkaban.user.UserManager;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.system.SystemManager;
import com.webank.wedatasphere.schedulis.common.system.SystemUserManagerException;
import com.webank.wedatasphere.schedulis.common.system.entity.DepartmentMaintainer;
import com.webank.wedatasphere.schedulis.common.system.entity.WebankDepartment;
import com.webank.wedatasphere.schedulis.common.system.entity.WebankUser;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssUser;
import java.util.List;
import javax.inject.Inject;

public class TransitionService {
    private UserManager userManager;
    private SystemManager systemManager;
    private Props props;

    @Inject
    public TransitionService(UserManager userManager, SystemManager systemManager, Props props) {
        this.userManager = userManager;
        this.systemManager = systemManager;
        this.props = props;
    }

    public SystemManager getSystemManager() {
        return this.systemManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public String getUserDepartmentByUsername(String userName) throws SystemUserManagerException {
        return this.systemManager.getUserDepartmentByUsername(userName);
    }

    public WtssUser getSystemUserByUserName(String userName) throws SystemUserManagerException {
        return this.systemManager.getSystemUserByUserName(userName);
    }

    public WtssUser getSystemUserById(String userId) throws SystemUserManagerException {
        return this.systemManager.getSystemUserById(userId);
    }

    public WebankUser getWebankUserByUserName(String userName) {
        return this.systemManager.getWebankUserByUserName(userName);
    }

    public WebankDepartment getWebankDepartmentByDpId(Integer departmentId) throws SystemUserManagerException {
        return this.systemManager.getWebankDepartmentByDpId(departmentId);
    }

    public List<Integer> getDepartmentMaintainerDepListByUserName(String userName) throws SystemUserManagerException {
        return this.systemManager.getDepartmentMaintainerDepListByUserName(userName);
    }

    public String getDepartmentMaintainerByDepId(long departmentId) throws SystemUserManagerException {
        DepartmentMaintainer departmentMaintainer = this.systemManager.getDepMaintainerByDepId(departmentId);
        if (departmentMaintainer != null) {
            return departmentMaintainer.getOpsUser();
        }
        return null;
    }

    public List<WtssUser> getSystemUserByDepId(Integer depId) {
        return this.systemManager.getSystemUserByDepartmentId(depId);
    }

    public Boolean validateProxyUser(String proxyUserName, User user) {
        return this.userManager.validateProxyUser(proxyUserName, user);
    }

    public Boolean validateGroup(String group) {
        return this.userManager.validateGroup(group);
    }

    public Boolean validateUser(String userName) {
        return this.userManager.validateUser(userName);
    }
}

