/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.system;

import azkaban.user.User;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.utils.XmlResolveUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUsersSync {
    private static final Logger logger = LoggerFactory.getLogger((String)XmlUsersSync.class.getName());
    public static final String XML_FILE_PARAM = "user.manager.xml.file";
    public static final String USER_TAG = "user";
    public static final String ROLE_TAG = "role";
    public static final String GROUP_TAG = "group";
    public static final String ROLENAME_ATTR = "name";
    public static final String ROLEPERMISSIONS_ATTR = "permissions";
    public static final String USERNAME_ATTR = "username";
    public static final String EMAIL_ATTR = "email";
    public static final String ROLES_ATTR = "roles";
    public static final String PROXY_ATTR = "proxy";
    public static final String GROUPS_ATTR = "groups";
    private final String xmlPath;
    private Props props;
    private HashMap<String, User> users;

    public XmlUsersSync(Props props) {
        this.props = props;
        this.xmlPath = props.getString(XML_FILE_PARAM);
        this.parseXMLFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXMLFile() {
        File file = new File(this.xmlPath);
        if (!file.exists()) {
            throw new IllegalArgumentException("User xml file " + this.xmlPath + " doesn't exist.");
        }
        HashMap<String, User> users = new HashMap<String, User>();
        HashMap<String, String> userPassword = new HashMap<String, String>();
        HashMap roles = new HashMap();
        HashMap groupRoles = new HashMap();
        HashMap<String, Set<String>> proxyUserMap = new HashMap<String, Set<String>>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            XmlResolveUtils.avoidXEE(docBuilderFactory);
            builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalArgumentException("Exception while parsing user xml. Document builder not created.", e);
        }
        Document doc = null;
        try {
            doc = builder.parse(file);
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Exception while parsing " + this.xmlPath + ". Invalid XML.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception while parsing " + this.xmlPath + ". Error reading file.", e);
        }
        NodeList tagList = doc.getChildNodes();
        Node azkabanUsers = tagList.item(0);
        User user = null;
        NodeList azkabanUsersList = azkabanUsers.getChildNodes();
        for (int i = 0; i < azkabanUsersList.getLength(); ++i) {
            Node node = azkabanUsersList.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(USER_TAG)) continue;
            user = this.parseUserTag(node, users, userPassword, proxyUserMap);
        }
        XmlUsersSync xmlUsersSync = this;
        synchronized (xmlUsersSync) {
            this.users = users;
        }
    }

    private User parseUserTag(Node node, HashMap<String, User> users, HashMap<String, String> userPassword, HashMap<String, Set<String>> proxyUserMap) {
        String value;
        Node proxy;
        Node groups;
        NamedNodeMap userAttrMap = node.getAttributes();
        Node userNameAttr = userAttrMap.getNamedItem(USERNAME_ATTR);
        if (userNameAttr == null) {
            throw new RuntimeException("Error loading user. The 'username' attribute doesn't exist");
        }
        String username = userNameAttr.getNodeValue();
        userPassword.put(username, username);
        User user = new User(userNameAttr.getNodeValue());
        users.put(username, user);
        logger.info("Loading user " + user.getUserId());
        Node roles = userAttrMap.getNamedItem(ROLES_ATTR);
        if (roles != null) {
            String[] roleSplit;
            String value2 = roles.getNodeValue();
            for (String role : roleSplit = value2.split("\\s*,\\s*")) {
                user.addRole(role);
            }
        }
        if ((groups = userAttrMap.getNamedItem(GROUPS_ATTR)) != null) {
            String[] groupSplit;
            String value3 = groups.getNodeValue();
            for (String group : groupSplit = value3.split("\\s*,\\s*")) {
                user.addGroup(group);
            }
        }
        if ((proxy = userAttrMap.getNamedItem(PROXY_ATTR)) != null && StringUtils.isNotEmpty((String)(value = proxy.getNodeValue()))) {
            String[] proxySplit;
            for (String proxyUser : proxySplit = value.split("\\s*,\\s*")) {
                Set<String> proxySet = proxyUserMap.get(username);
                if (proxySet == null) {
                    proxySet = new HashSet<String>();
                    proxyUserMap.put(username, proxySet);
                }
                user.addProxyUser(proxyUser);
                proxySet.add(proxyUser);
            }
        }
        return user;
    }

    public HashMap<String, User> getXmlUserMap() {
        return this.users;
    }
}

