/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.system;

import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.JdbcExecutorLoader;
import azkaban.project.Project;
import azkaban.project.ProjectLoader;
import azkaban.storage.StorageManager;
import azkaban.user.User;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.executor.DepartmentGroup;
import com.webank.wedatasphere.schedulis.common.i18nutils.LoadJsonUtils;
import com.webank.wedatasphere.schedulis.common.system.SystemUserLoader;
import com.webank.wedatasphere.schedulis.common.system.SystemUserManagerException;
import com.webank.wedatasphere.schedulis.common.system.XmlUsersSync;
import com.webank.wedatasphere.schedulis.common.system.entity.DepartmentMaintainer;
import com.webank.wedatasphere.schedulis.common.system.entity.WebankDepartment;
import com.webank.wedatasphere.schedulis.common.system.entity.WebankUser;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssPermissions;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssRole;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssUser;
import com.webank.wedatasphere.schedulis.common.utils.MD5Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SystemManager {
    private static final Logger logger = LoggerFactory.getLogger(SystemManager.class);
    private final ProjectLoader projectLoader;
    private final SystemUserLoader systemUserLoader;
    private final JdbcExecutorLoader jdbcExecutorLoader;
    private final Props props;

    @Inject
    public SystemManager(ProjectLoader loader, StorageManager storageManager, SystemUserLoader systemUserLoader, JdbcExecutorLoader jdbcExecutorLoader, Props props) {
        this.projectLoader = Objects.requireNonNull(loader);
        this.props = Objects.requireNonNull(props);
        this.systemUserLoader = Objects.requireNonNull(systemUserLoader);
        this.jdbcExecutorLoader = jdbcExecutorLoader;
    }

    public Props getProps() {
        return this.props;
    }

    public WebankUser getWebankUserByUserId(String userId) {
        WebankUser webankUser = null;
        try {
            webankUser = this.systemUserLoader.getWebankUserByUserId(userId);
        }
        catch (SystemUserManagerException e) {
            logger.error("Exception in query webank user by userId, caused by:{}", (Throwable)e);
        }
        return webankUser;
    }

    private Map<String, String> loadSystemManagerI18nData() {
        String languageType = LoadJsonUtils.getLanguageType();
        Map<String, String> dataMap = languageType.equalsIgnoreCase("zh_CN") ? LoadJsonUtils.transJson("/com.webank.wedatasphere.schedulis.i18n.conf/azkaban-common-zh_CN.json", "SystemManager") : LoadJsonUtils.transJson("/com.webank.wedatasphere.schedulis.i18n.conf/azkaban-common-en_US.json", "SystemManager");
        return dataMap;
    }

    public WebankUser getWebankUserByUserName(String userName) {
        WebankUser webankUser = null;
        try {
            webankUser = this.systemUserLoader.getWebankUserByUserName(userName);
        }
        catch (SystemUserManagerException e) {
            logger.error("Exception in query webank user by user name, caused by:{}", (Throwable)e);
        }
        return webankUser;
    }

    public List<WebankUser> findAllWebankUserList(String searchName) {
        List<WebankUser> webankUserList = null;
        try {
            webankUserList = this.systemUserLoader.findAllWebankUserList(searchName);
        }
        catch (SystemUserManagerException e) {
            logger.error("Exception in query all webank user as user list, caused by:{}", (Throwable)e);
        }
        return webankUserList;
    }

    public List<WebankUser> findAllWebankUserPageList(String searchName, int pageNum, int pageSize) throws SystemUserManagerException {
        List<WebankUser> webankUserList = null;
        try {
            webankUserList = this.systemUserLoader.findAllWebankUserPageList(searchName, pageNum, pageSize);
        }
        catch (SystemUserManagerException e) {
            logger.error("Exception in query all webank user as user page list, caused by:{}", (Throwable)e);
        }
        return webankUserList;
    }

    public List<WtssUser> findSystemUserPage(String userName, String fullName, String departmentName, int start, int pageSize) throws SystemUserManagerException {
        List<WtssUser> wtssUserList = this.systemUserLoader.findSystemUserPage(userName, fullName, departmentName, start, pageSize);
        return wtssUserList;
    }

    public int getSystemUserTotal() throws SystemUserManagerException {
        return this.systemUserLoader.getWtssUserTotal();
    }

    public int getSystemUserTotal(String username) throws SystemUserManagerException {
        return this.systemUserLoader.getWtssUserTotal(username);
    }

    public int addSystemUser(String userId, String password, int roleId, String proxyUser, int departmentId) throws SystemUserManagerException {
        Map<String, String> dataMap = this.loadSystemManagerI18nData();
        WtssUser wtssUser = new WtssUser();
        WebankUser webankUser = this.systemUserLoader.getWebankUserByUserId(userId);
        WebankDepartment webankDepartment = this.systemUserLoader.getWebankDepartmentByDpId(departmentId);
        if (null != webankUser) {
            wtssUser.setUserId(webankUser.userId);
            wtssUser.setUsername(webankUser.urn);
            wtssUser.setFullName(webankUser.fullName);
            if (null != webankDepartment) {
                wtssUser.setDepartmentId(webankDepartment.dpId);
                wtssUser.setDepartmentName(webankDepartment.dpChName);
            } else {
                wtssUser.setDepartmentId(webankUser.departmentId);
                wtssUser.setDepartmentName(webankUser.departmentName);
            }
            wtssUser.setEmail(webankUser.email);
        } else {
            wtssUser.setUserId("wtss_" + userId);
            wtssUser.setUsername(userId);
            wtssUser.setFullName(userId);
            if (null != webankDepartment) {
                wtssUser.setDepartmentId(webankDepartment.dpId);
                wtssUser.setDepartmentName(webankDepartment.dpChName);
            }
            wtssUser.setEmail("");
        }
        String encodePwd = MD5Utils.md5(MD5Utils.md5(password) + wtssUser.getUserId());
        wtssUser.setPassword(encodePwd);
        if (null != proxyUser && !"".equals(proxyUser)) {
            Pattern pattern = Pattern.compile("^[A-Za-z0-9_,]+$");
            if (!pattern.matcher(proxyUser).matches()) {
                throw new SystemUserManagerException(dataMap.get("errorFormatProxy"));
            }
            wtssUser.setProxyUsers(proxyUser);
        } else {
            wtssUser.setProxyUsers(wtssUser.getUsername());
        }
        wtssUser.setRoleId(roleId);
        wtssUser.setUserType(WtssUser.UserType.ACTIVE.getUserTypeNum());
        wtssUser.setCreateTime(System.currentTimeMillis());
        wtssUser.setUpdateTime(System.currentTimeMillis());
        wtssUser.setModifyInfo("Normal");
        wtssUser.setModifyType("0");
        String userCategory = userId.startsWith("WTSS_") ? "ops" : (userId.startsWith("hduser") ? "system" : "personal");
        wtssUser.setUserCategory(userCategory);
        return this.systemUserLoader.addWtssUser(wtssUser);
    }

    public int getWebankUserTotal() throws SystemUserManagerException {
        return this.systemUserLoader.getWebankUserTotal();
    }

    public WtssUser getSystemUserById(String userId) throws SystemUserManagerException {
        return this.systemUserLoader.getWtssUserByUserId(userId);
    }

    public int updateSystemUser(WtssUser wtssUser, boolean synEsb) throws SystemUserManagerException {
        return this.systemUserLoader.updateWtssUser(wtssUser, synEsb);
    }

    public int updateSystemUserByName(WtssUser wtssUser, boolean synEsb) throws SystemUserManagerException {
        return this.systemUserLoader.updateWtssUserByName(wtssUser, synEsb);
    }

    public int updateSystemUser(String userId, String password, int roleId, String proxyUser, int departmentId) throws SystemUserManagerException {
        Map<String, String> dataMap = this.loadSystemManagerI18nData();
        WtssUser wtssUser = this.systemUserLoader.getWtssUserByUserId(userId);
        if (null != wtssUser) {
            WebankUser webankUser = this.systemUserLoader.getWebankUserByUserId(userId);
            if (null != webankUser) {
                wtssUser.setUserId(webankUser.userId);
            } else {
                wtssUser.setUserId(userId);
            }
            WebankDepartment webankDepartment = this.systemUserLoader.getWebankDepartmentByDpId(departmentId);
            wtssUser.setDepartmentId(departmentId);
            if (webankDepartment != null) {
                wtssUser.setDepartmentName(webankDepartment.dpChName);
            } else {
                wtssUser.setDepartmentName(wtssUser.getDepartmentName());
            }
            String passwordDb = wtssUser.getPassword();
            if (!passwordDb.equals(password)) {
                String encodePwd = MD5Utils.md5(MD5Utils.md5(password) + wtssUser.getUserId());
                wtssUser.setPassword(encodePwd);
            }
            if (null != proxyUser && !"".equals(proxyUser)) {
                Pattern pattern = Pattern.compile("^[A-Za-z0-9_,]+$");
                if (!pattern.matcher(proxyUser).matches()) {
                    throw new SystemUserManagerException(dataMap.get("errorFormatProxy"));
                }
                wtssUser.setProxyUsers(proxyUser);
            } else {
                wtssUser.setProxyUsers(wtssUser.getUsername());
            }
            wtssUser.setRoleId(roleId);
            wtssUser.setUserType(WtssUser.UserType.ACTIVE.getUserTypeNum());
            wtssUser.setUpdateTime(System.currentTimeMillis());
            String userCategory = Pattern.compile("^[0-9]+$").matcher(userId).matches() ? "personal" : (userId.startsWith("wtss_hduser") ? "system" : (userId.startsWith("wtss_WTSS") ? "ops" : "test"));
            wtssUser.setUserCategory(userCategory);
            return this.systemUserLoader.updateWtssUser(wtssUser);
        }
        throw new SystemUserManagerException("Unregistered User, Please register this user.");
    }

    public WtssRole getWtssRoleById(int roleId) {
        try {
            return this.systemUserLoader.getWtssRoleById(roleId);
        }
        catch (SystemUserManagerException e) {
            logger.error("get wtss user role by roleId fail, caused by:{}", (Throwable)e);
            return null;
        }
    }

    public String getUserPermission(int roleId) {
        String userPermString = "";
        try {
            WtssRole wtssRole = this.systemUserLoader.getWtssRoleById(roleId);
            if (wtssRole != null) {
                List<WtssPermissions> wtssPermissionsList = this.systemUserLoader.getWtssPermissionsListByIds(wtssRole.getPermissionsIds());
                List permissionsNameList = wtssPermissionsList.stream().map(WtssPermissions::getPermissionsName).collect(Collectors.toList());
                userPermString = String.join((CharSequence)",", permissionsNameList);
            }
        }
        catch (SystemUserManagerException e) {
            logger.error("getUserPermission by roleId failed, caused by:{}", (Throwable)e);
        }
        return userPermString;
    }

    public List<WebankDepartment> findAllWebankDepartmentPageList(String searchName, int pageNum, int pageSize) throws SystemUserManagerException {
        List<WebankDepartment> webankDepartmentList = null;
        try {
            webankDepartmentList = this.systemUserLoader.findAllWebankDepartmentPageList(searchName, pageNum, pageSize);
        }
        catch (SystemUserManagerException e) {
            logger.error("Exception in query webank department as page list, caused by:{}", (Throwable)e);
        }
        return webankDepartmentList;
    }

    public int getWebankDepartmentTotal() throws SystemUserManagerException {
        return this.systemUserLoader.getWebankDepartmentTotal();
    }

    public List<WebankDepartment> findAllWebankDepartmentList(String searchName) throws SystemUserManagerException {
        List<WebankDepartment> webankDepartmentList = null;
        try {
            webankDepartmentList = this.systemUserLoader.findAllWebankDepartmentList(searchName);
        }
        catch (SystemUserManagerException e) {
            throw new SystemUserManagerException(e);
        }
        return webankDepartmentList;
    }

    public WebankDepartment getWebankDepartmentByDpId(int dpId) throws SystemUserManagerException {
        return this.systemUserLoader.getWebankDepartmentByDpId(dpId);
    }

    public List<WebankDepartment> findAllWebankDepartmentPageOrSearch(String searchName, int pageNum, int pageSize) throws SystemUserManagerException {
        List<WebankDepartment> webankDepartmentList = null;
        try {
            webankDepartmentList = this.systemUserLoader.findAllWebankDepartmentPageOrSearch(searchName, pageNum, pageSize);
        }
        catch (SystemUserManagerException e) {
            throw new SystemUserManagerException(e);
        }
        return webankDepartmentList;
    }

    public int deleteSystemUser(String userId) throws SystemUserManagerException {
        return this.systemUserLoader.deleteWtssUser(userId);
    }

    public void addXmlUserToDB() throws SystemUserManagerException {
        XmlUsersSync xmlUsersSync = new XmlUsersSync(this.props);
        for (String username : xmlUsersSync.getXmlUserMap().keySet()) {
            User user = xmlUsersSync.getXmlUserMap().get(username);
            WtssUser existUser = this.systemUserLoader.getWtssUserByUsername(user.getUserId());
            WtssUser wtssUser = new WtssUser();
            WebankUser webankUser = this.systemUserLoader.getWebankUserByUsername(user.getUserId());
            if (null != webankUser && null == existUser) {
                wtssUser.setUserId(webankUser.userId);
                wtssUser.setUsername(webankUser.urn);
                wtssUser.setFullName(webankUser.fullName);
                wtssUser.setDepartmentId(webankUser.departmentId);
                wtssUser.setDepartmentName(webankUser.departmentName);
                wtssUser.setEmail(webankUser.email);
                wtssUser.setPassword("");
            } else if (null == existUser) {
                wtssUser.setUserId("wtss_" + username);
                wtssUser.setUsername(username);
                wtssUser.setFullName(username);
                wtssUser.setEmail("");
                wtssUser.setPassword("Abcd1234");
            }
            if (null != existUser) continue;
            List<String> proxyUsers = user.getProxyUsers();
            String proxyUser = "";
            for (int i = 0; i < proxyUsers.size(); ++i) {
                proxyUser = proxyUser + proxyUsers.get(i) + ",";
            }
            proxyUser = !"".equals(proxyUser) ? proxyUser.substring(0, proxyUser.length() - 1) : wtssUser.getUsername();
            wtssUser.setProxyUsers(proxyUser);
            int roleId = 0;
            roleId = user.getGroups().contains("bdp-admin") ? 1 : 2;
            wtssUser.setRoleId(roleId);
            wtssUser.setUserType(WtssUser.UserType.ACTIVE.getUserTypeNum());
            wtssUser.setCreateTime(System.currentTimeMillis());
            wtssUser.setUpdateTime(System.currentTimeMillis());
            wtssUser.setModifyInfo("Normal");
            wtssUser.setModifyType("0");
            String userId = user.getUserId();
            String userCategory = userId.startsWith("WTSS_") ? "ops" : (userId.startsWith("hduser") ? "system" : "personal");
            wtssUser.setUserCategory(userCategory);
            try {
                this.systemUserLoader.addWtssUser(wtssUser);
            }
            catch (SystemUserManagerException e) {
                e.printStackTrace();
            }
        }
    }

    public WebankDepartment getParentDepartmentByPId(int pid) throws SystemUserManagerException {
        return this.systemUserLoader.getParentDepartmentByPId(pid);
    }

    public WebankDepartment getDeparmentById(int dpId) throws SystemUserManagerException {
        return this.systemUserLoader.getWebankDepartmentByDpId(dpId);
    }

    public int addDeparment(int dpId, int pid, String dpName, String dpChName, int orgId, String orgName, String division, Integer groupId, Integer uploadFlag) throws SystemUserManagerException {
        WebankDepartment webankDepartment = new WebankDepartment();
        webankDepartment.setDpId(Long.valueOf(dpId));
        webankDepartment.setPid(Long.valueOf(pid));
        webankDepartment.setDpName(dpName);
        webankDepartment.setDpChName(dpChName);
        webankDepartment.setOrgId(Long.valueOf(orgId));
        webankDepartment.setOrgName(orgName);
        webankDepartment.setDivision(division);
        webankDepartment.setGroupId(groupId);
        webankDepartment.setUploadFlag(uploadFlag);
        return this.systemUserLoader.addDeparment(webankDepartment);
    }

    public int updateDeparment(int dpId, int pid, String dpName, String dpChName, int orgId, String orgName, String division, Integer groupId, Integer uploadFlag) throws SystemUserManagerException {
        WebankDepartment webankDepartment = new WebankDepartment();
        webankDepartment.setDpId(Long.valueOf(dpId));
        webankDepartment.setPid(Long.valueOf(pid));
        webankDepartment.setDpName(dpName);
        webankDepartment.setDpChName(dpChName);
        webankDepartment.setOrgId(Long.valueOf(orgId));
        webankDepartment.setOrgName(orgName);
        webankDepartment.setDivision(division);
        webankDepartment.setGroupId(groupId);
        webankDepartment.setUploadFlag(uploadFlag);
        return this.systemUserLoader.updateDeparment(webankDepartment);
    }

    public int deleteDeparment(int dpId) throws SystemUserManagerException {
        return this.systemUserLoader.deleteDeparment(dpId);
    }

    public int getWebankDepartmentTotal(String searchterm) throws SystemUserManagerException {
        return this.systemUserLoader.getWebankDepartmentTotal(searchterm);
    }

    public String getUserDepartmentByUsername(String userName) throws SystemUserManagerException {
        String userDepartment;
        String department = "Submitter";
        WtssUser wtssUser = this.systemUserLoader.getWtssUserByUsername(userName);
        if (null != wtssUser && null != (userDepartment = wtssUser.getDepartmentName()) && !userDepartment.isEmpty()) {
            return userDepartment;
        }
        return department;
    }

    public List<DepartmentGroup> fetchAllDepartmentGroup() {
        ArrayList<DepartmentGroup> departmentGroups = new ArrayList();
        try {
            departmentGroups = this.jdbcExecutorLoader.fetchAllDepartmentGroup();
        }
        catch (ExecutorManagerException e) {
            logger.error("fetch All Department Group failed.");
        }
        return departmentGroups;
    }

    public boolean addDepartmentGroup(DepartmentGroup departmentGroup) {
        boolean ret = false;
        try {
            this.jdbcExecutorLoader.addDepartmentGroup(departmentGroup);
            ret = true;
        }
        catch (ExecutorManagerException e) {
            logger.error("add Department Group failed");
        }
        return ret;
    }

    public boolean checkGroupNameIsExist(DepartmentGroup departmentGroup) {
        try {
            return this.jdbcExecutorLoader.checkGroupNameIsExist(departmentGroup);
        }
        catch (ExecutorManagerException e) {
            logger.error("checkGroupNameIsExist: {}", (Throwable)e);
            return false;
        }
    }

    public boolean checkExecutorIsUsed(int executorId) {
        try {
            return this.jdbcExecutorLoader.checkExecutorIsUsed(executorId);
        }
        catch (ExecutorManagerException e) {
            logger.error("checkExecutorIsUsed: {}", (Throwable)e);
            return false;
        }
    }

    public boolean deleteDepartmentGroup(DepartmentGroup departmentGroup) {
        int ret = 0;
        try {
            ret = this.jdbcExecutorLoader.deleteDepartmentGroup(departmentGroup);
        }
        catch (ExecutorManagerException e) {
            logger.error("delete Department Group failed");
        }
        return ret != 0;
    }

    public boolean updateDepartmentGroup(DepartmentGroup departmentGroup) {
        int ret = 0;
        try {
            ret = this.jdbcExecutorLoader.updateDepartmentGroup(departmentGroup);
        }
        catch (ExecutorManagerException e) {
            logger.error("update Department Group failed");
        }
        return ret != 0;
    }

    public boolean groupIdIsExist(DepartmentGroup departmentGroup) {
        int count = -1;
        boolean ret = false;
        try {
            count = this.jdbcExecutorLoader.groupIdIsExist(departmentGroup);
        }
        catch (ExecutorManagerException e) {
            logger.error(e.getMessage());
        }
        if (count > 0) {
            ret = true;
        }
        return ret;
    }

    public DepartmentGroup getDepartmentGroupById(Integer id) {
        DepartmentGroup departmentGroup = null;
        try {
            departmentGroup = this.jdbcExecutorLoader.fetchDepartmentGroupById(id);
        }
        catch (ExecutorManagerException e) {
            logger.error("get Department Group by id failed");
        }
        return departmentGroup;
    }

    public List<Executor> fetchAllExecutors() {
        List<Executor> executors = null;
        try {
            executors = this.jdbcExecutorLoader.fetchAllExecutors();
        }
        catch (ExecutorManagerException e) {
            logger.error("get Executor failed");
        }
        return executors;
    }

    public List<WtssUser> getSystemUserByDepartmentId(int dpId) {
        List<WtssUser> wtssUserList = null;
        try {
            wtssUserList = this.systemUserLoader.getSystemUserByDepartmentId(dpId);
        }
        catch (SystemUserManagerException e) {
            logger.error("get SystemUser By DepartmentId failed, caused by:{}", (Throwable)e);
        }
        return wtssUserList;
    }

    public List<WtssUser> getModifySystemUser(String modifyType) {
        List<WtssUser> wtssUserList = null;
        try {
            wtssUserList = this.systemUserLoader.getModifySystemUser(modifyType);
        }
        catch (SystemUserManagerException e) {
            logger.error("get Modify SystemUser By modifyType failed, caused by:{}", (Throwable)e);
        }
        return wtssUserList;
    }

    public List<WtssUser> getModifySystemUser(int start, int pageSize) {
        List<WtssUser> wtssUserList = null;
        try {
            wtssUserList = this.systemUserLoader.getModifySystemUser(start, pageSize);
        }
        catch (SystemUserManagerException e) {
            logger.error("get Modify SystemUser By modifyType failed, caused by:{}", (Throwable)e);
        }
        return wtssUserList;
    }

    public List<WtssUser> getModifySystemUser(String searchterm, int start, int pageSize) {
        List<WtssUser> wtssUserList = null;
        try {
            wtssUserList = this.systemUserLoader.getModifySystemUser(searchterm, start, pageSize);
        }
        catch (SystemUserManagerException e) {
            logger.error("get Modify SystemUser By modifyType failed, caused by:{}", (Throwable)e);
        }
        return wtssUserList;
    }

    public String getModifyInfoSystemUserById(String userId) {
        String modifyInfoById = "";
        try {
            modifyInfoById = this.systemUserLoader.getModifyInfoSystemUserById(userId);
        }
        catch (SystemUserManagerException e) {
            logger.error("get Single Modify SystemUser Info By userId failed, caused by:{}", (Throwable)e);
        }
        return modifyInfoById;
    }

    public WtssUser getSystemUserByUserName(String userName) throws SystemUserManagerException {
        return this.systemUserLoader.getSystemUserByUserName(userName);
    }

    public List<DepartmentMaintainer> getDepartmentMaintainerList(int start, int pageSize) throws SystemUserManagerException {
        return this.systemUserLoader.getDepartmentMaintainerList(start, pageSize);
    }

    public int getDepartmentMaintainerTotal() throws SystemUserManagerException {
        return this.systemUserLoader.getDepartmentMaintainerTotal();
    }

    public List<DepartmentMaintainer> getDepartmentMaintainerList(String searchterm, int start, int pageSize) throws SystemUserManagerException {
        return this.systemUserLoader.getDepartmentMaintainerList(searchterm, start, pageSize);
    }

    public int addDepartmentMaintainer(long departmentId, String departmentName, String userName) throws SystemUserManagerException {
        return this.systemUserLoader.addDepartmentMaintainer(departmentId, departmentName, userName);
    }

    public DepartmentMaintainer getDepMaintainerByDepId(long departmentId) throws SystemUserManagerException {
        return this.systemUserLoader.getDepMaintainerByDepId(departmentId);
    }

    public int updateDepartmentMaintainer(long departmentId, String departmentName, String depMaintainer) throws SystemUserManagerException {
        return this.systemUserLoader.updateDepartmentMaintainer(departmentId, departmentName, depMaintainer);
    }

    public int deleteDepartmentMaintainer(Integer departmentId) throws SystemUserManagerException {
        return this.systemUserLoader.deleteDepartmentMaintainer(departmentId);
    }

    public List<Integer> getDepartmentMaintainerDepListByUserName(String loginUserName) throws SystemUserManagerException {
        return this.systemUserLoader.getDepartmentMaintainerDepListByUserName(loginUserName);
    }

    public boolean isDepartmentMaintainer(User user) {
        try {
            return CollectionUtils.isNotEmpty(this.getDepartmentMaintainerDepListByUserName(user.getUserId()));
        }
        catch (SystemUserManagerException e) {
            return false;
        }
    }

    public List<Integer> getMaintainedProjects(User user) {
        try {
            return this.systemUserLoader.getMaintainedProjects(user.getUserId());
        }
        catch (SystemUserManagerException e) {
            return Collections.emptyList();
        }
    }

    public boolean isMaintainedProject(Project project, List<Integer> projectIds) {
        return projectIds.contains(project.getId());
    }
}

