/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.system;

import azkaban.db.DatabaseOperator;
import azkaban.utils.Props;
import com.webank.wedatasphere.schedulis.common.executor.DepartmentGroup;
import com.webank.wedatasphere.schedulis.common.system.SystemUserLoader;
import com.webank.wedatasphere.schedulis.common.system.SystemUserManagerException;
import com.webank.wedatasphere.schedulis.common.system.entity.DepartmentMaintainer;
import com.webank.wedatasphere.schedulis.common.system.entity.WebankDepartment;
import com.webank.wedatasphere.schedulis.common.system.entity.WebankUser;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssPermissions;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssRole;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssUser;
import com.webank.wedatasphere.schedulis.common.utils.MD5Utils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JdbcSystemUserImpl
implements SystemUserLoader {
    private static final Logger logger = LoggerFactory.getLogger(JdbcSystemUserImpl.class);
    private final DatabaseOperator dbOperator;
    private static final String SQL_PARAMS_TABLE_WTSS_USER = "user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category ";
    private static final String SQL_PARAMS_TABLE_CFG_WEBANK_ALL_USERS = "app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time ";
    public static final String SQL_PARAMS_TABLE_WTSS_ROLE = "role_id,role_name, permissions_ids, description, create_time, update_time";
    public static final String SQL_PARAMS_TABLE_WTSS_PERMISSIONS = "permissions_id, permissions_name, permissions_value, permissions_type, description, create_time, update_time";
    public static final String SQL_PARAMS_TABLE_CFG_WEBANK_ORGANIZATION = "dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag";
    public static final String SQL_PARAMS_TABLE_DEPARTMENT_MAINTAINER = "department_id, department_name, ops_user";

    @Inject
    public JdbcSystemUserImpl(Props props, DatabaseOperator databaseOperator) {
        this.dbOperator = databaseOperator;
    }

    @Override
    public int getWebankUserTotal() throws SystemUserManagerException {
        IntHandler intHandler = new IntHandler();
        try {
            return (Integer)this.dbOperator.query(IntHandler.GET_WEBANK_USER_TOTAL, (ResultSetHandler)intHandler);
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find the total of Webank User.", e);
        }
    }

    @Override
    public List<WebankUser> findAllWebankUserList(String searchName) throws SystemUserManagerException {
        List webankUserList = null;
        String querySQL = "SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users";
        ArrayList<String> params = new ArrayList<String>();
        boolean first = true;
        try {
            if (StringUtils.isNotBlank((CharSequence)searchName)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + " full_name LIKE ?";
                params.add('%' + searchName + '%');
                first = false;
            }
            webankUserList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new findAllWebankUserHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find Webank User by userName.", e);
        }
        return webankUserList;
    }

    @Override
    public List<WebankUser> findAllWebankUserPageList(String searchName, int pageNum, int pageSize) throws SystemUserManagerException {
        List webankUserList = null;
        String querySQL = "SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users";
        ArrayList<Object> params = new ArrayList<Object>();
        boolean first = true;
        try {
            if (StringUtils.isNotBlank((CharSequence)searchName)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + " full_name LIKE ?";
                params.add('%' + searchName + '%');
                first = false;
            }
            if (pageNum > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(pageNum);
                params.add(pageSize);
            }
            webankUserList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new findAllWebankUserHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find Webank User", e);
        }
        return webankUserList;
    }

    @Override
    public WebankUser getWebankUserByUserId(String userId) throws SystemUserManagerException {
        List webankUserList = null;
        try {
            webankUserList = (List)this.dbOperator.query("SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users WHERE user_id=? ", (ResultSetHandler)new findAllWebankUserHandler(), new Object[]{userId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find Webank User by userId", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)webankUserList)) {
            return (WebankUser)webankUserList.get(0);
        }
        return null;
    }

    @Override
    public List<WtssUser> findSystemUserPage(String userName, String fullName, String departmentName, int start, int pageSize) throws SystemUserManagerException {
        List wtssUserList = null;
        String querySQL = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user ";
        ArrayList<Object> params = new ArrayList<Object>();
        boolean first = true;
        try {
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + " username LIKE ?";
                params.add('%' + userName + '%');
                first = false;
            }
            if (StringUtils.isNotBlank((CharSequence)fullName)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + " full_name LIKE ?";
                params.add('%' + fullName + '%');
                first = false;
            }
            if (StringUtils.isNotBlank((CharSequence)departmentName)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + " department_name LIKE ?";
                params.add('%' + departmentName + '%');
                first = false;
            }
            if (start > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(start);
                params.add(pageSize);
            }
            wtssUserList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new SystemUserHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find WTSS User", e);
        }
        return wtssUserList;
    }

    @Override
    public int addWtssUser(WtssUser wtssUser) throws SystemUserManagerException {
        String INSERT_WTSS_USER = "INSERT INTO wtss_user (user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            return this.dbOperator.update("INSERT INTO wtss_user (user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category ) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{wtssUser.getUserId(), wtssUser.getUsername(), wtssUser.getPassword(), wtssUser.getFullName(), wtssUser.getDepartmentId(), wtssUser.getDepartmentName(), wtssUser.getEmail(), wtssUser.getProxyUsers(), wtssUser.getRoleId(), wtssUser.getUserType(), wtssUser.getCreateTime(), wtssUser.getUpdateTime(), wtssUser.getModifyInfo(), wtssUser.getModifyType(), wtssUser.getUserCategory()});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException(String.format("Add User %s Failed", wtssUser.toString()), e);
        }
    }

    @Override
    public int getWtssUserTotal() throws SystemUserManagerException {
        IntHandler intHandler = new IntHandler();
        try {
            return (Integer)this.dbOperator.query(IntHandler.GET_WTSS_USER_TOTAL, (ResultSetHandler)intHandler);
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find the total of WTSS User.", e);
        }
    }

    @Override
    public int getWtssUserTotal(String username) throws SystemUserManagerException {
        IntHandler intHandler = new IntHandler();
        String querySQL = IntHandler.GET_WTSS_USER_TOTAL;
        ArrayList<String> params = new ArrayList<String>();
        boolean first = true;
        try {
            if (StringUtils.isNotBlank((CharSequence)username)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + " full_name LIKE ?";
                params.add('%' + username + '%');
                first = false;
            }
            return (Integer)this.dbOperator.query(querySQL, (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find the total of WTSS User", e);
        }
    }

    @Override
    public int updateWtssUser(WtssUser wtssUser) throws SystemUserManagerException {
        String INSERT_WTSS_USER = "UPDATE wtss_user SET password=?, department_id=?, department_name=?, proxy_users=?, role_id=?, user_type=?, update_time=?, user_category=? WHERE user_id=? ";
        try {
            return this.dbOperator.update("UPDATE wtss_user SET password=?, department_id=?, department_name=?, proxy_users=?, role_id=?, user_type=?, update_time=?, user_category=? WHERE user_id=? ", new Object[]{wtssUser.getPassword(), wtssUser.getDepartmentId(), wtssUser.getDepartmentName(), wtssUser.getProxyUsers(), wtssUser.getRoleId(), wtssUser.getUserType(), wtssUser.getUpdateTime(), wtssUser.getUserCategory(), wtssUser.getUserId()});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException(String.format("Error update by wtssUser, %s ", wtssUser.toString()), e);
        }
    }

    @Override
    public int updateWtssUser(WtssUser wtssUser, boolean synEsb) throws SystemUserManagerException {
        String INSERT_WTSS_USER = "UPDATE wtss_user SET user_id=?, department_id=?, department_name=?, update_time=?, modify_type=? ,modify_info=? WHERE user_id=? ";
        try {
            return this.dbOperator.update("UPDATE wtss_user SET user_id=?, department_id=?, department_name=?, update_time=?, modify_type=? ,modify_info=? WHERE user_id=? ", new Object[]{wtssUser.getUserId(), wtssUser.getDepartmentId(), wtssUser.getDepartmentName(), wtssUser.getUpdateTime(), wtssUser.getModifyType(), wtssUser.getModifyInfo(), wtssUser.getUserId()});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException(String.format("Error update by esb, %s ", wtssUser.toString()), e);
        }
    }

    @Override
    public int updateWtssUserByName(WtssUser wtssUser, boolean synEsb) throws SystemUserManagerException {
        String INSERT_WTSS_USER = "UPDATE wtss_user SET user_id=?, department_id=?, department_name=?, update_time=?, modify_type=? ,modify_info=? WHERE username=? ";
        try {
            return this.dbOperator.update("UPDATE wtss_user SET user_id=?, department_id=?, department_name=?, update_time=?, modify_type=? ,modify_info=? WHERE username=? ", new Object[]{wtssUser.getUserId(), wtssUser.getDepartmentId(), wtssUser.getDepartmentName(), wtssUser.getUpdateTime(), wtssUser.getModifyType(), wtssUser.getModifyInfo(), wtssUser.getUsername()});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException(String.format("Error update by name, %s ", wtssUser.toString()), e);
        }
    }

    @Override
    public WtssUser getWtssUserByUserId(String userId) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE user_id=? ", (ResultSetHandler)new SystemUserHandler(), new Object[]{userId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS User by userId", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)wtssUserList)) {
            return (WtssUser)wtssUserList.get(0);
        }
        return null;
    }

    @Override
    public WtssUser getWtssUserByUsernameAndPassword(String username, String password) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE username=? AND password=? ", (ResultSetHandler)new SystemUserHandler(), new Object[]{username, password});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS User by userName and password.", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)wtssUserList)) {
            return (WtssUser)wtssUserList.get(0);
        }
        return null;
    }

    @Override
    public WtssUser getWtssUserByUsernameAndPassword(WtssUser wtssUser) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            String username = wtssUser.getUsername();
            String encodePwd = MD5Utils.md5(MD5Utils.md5(wtssUser.getPassword()) + wtssUser.getUserId());
            wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE username=? AND password=? ", (ResultSetHandler)new SystemUserHandler(), new Object[]{username, encodePwd});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS User by userName and password.", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)wtssUserList)) {
            return (WtssUser)wtssUserList.get(0);
        }
        return null;
    }

    @Override
    public WtssRole getWtssRoleById(int roleId) throws SystemUserManagerException {
        List wtssRoleList = null;
        try {
            wtssRoleList = (List)this.dbOperator.query("SELECT role_id,role_name, permissions_ids, description, create_time, update_time FROM wtss_role  WHERE role_id=? ", (ResultSetHandler)new WtssRoleHandler(), new Object[]{roleId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS User by roleId", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)wtssRoleList)) {
            return (WtssRole)wtssRoleList.get(0);
        }
        return null;
    }

    @Override
    public WtssPermissions getWtssPermissionsById(int permissionsId) throws SystemUserManagerException {
        List wtssPermissionsList = null;
        try {
            wtssPermissionsList = (List)this.dbOperator.query("SELECT permissions_id, permissions_name, permissions_value, permissions_type, description, create_time, update_time FROM wtss_permissions  WHERE permissions_id=? ", (ResultSetHandler)new WtssPermissionsHandler(), new Object[]{permissionsId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS Permission by permissionsId", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)wtssPermissionsList)) {
            return (WtssPermissions)wtssPermissionsList.get(0);
        }
        return null;
    }

    @Override
    public List<WtssPermissions> getWtssPermissionsListByIds(String permissionsIds) throws SystemUserManagerException {
        List wtssPermissionsList = null;
        String sql = "SELECT permissions_id, permissions_name, permissions_value, permissions_type, description, create_time, update_time FROM wtss_permissions  WHERE permissions_id in ";
        sql = sql + "(" + permissionsIds + ")";
        try {
            wtssPermissionsList = (List)this.dbOperator.query(sql, (ResultSetHandler)new WtssPermissionsHandler());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS Permission by permissionsIds", e);
        }
        return wtssPermissionsList;
    }

    @Override
    public WtssUser getWtssUserByUsername(String username) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE username=? ", (ResultSetHandler)new SystemUserHandler(), new Object[]{username});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS User by userName", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)wtssUserList)) {
            return (WtssUser)wtssUserList.get(0);
        }
        return null;
    }

    @Override
    public int getWebankDepartmentTotal() throws SystemUserManagerException {
        IntHandler intHandler = new IntHandler();
        try {
            return (Integer)this.dbOperator.query(IntHandler.GET_WEBANK_DEPARTMENT_TOTAL, (ResultSetHandler)intHandler);
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find the total of Webank Department", e);
        }
    }

    @Override
    public int getWebankDepartmentTotal(String searchterm) throws SystemUserManagerException {
        IntHandler intHandler = new IntHandler();
        String querySQL = IntHandler.GET_WEBANK_DEPARTMENT_TOTAL;
        ArrayList<String> params = new ArrayList<String>();
        boolean first = true;
        try {
            if (StringUtils.isNotBlank((CharSequence)searchterm)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + " dp_ch_name LIKE ? ";
                params.add('%' + searchterm + '%');
                first = false;
            }
            return (Integer)this.dbOperator.query(querySQL, (ResultSetHandler)intHandler, params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find the total of Webank Department", e);
        }
    }

    @Override
    public List<WebankDepartment> findAllWebankDepartmentList(String searchName) throws SystemUserManagerException {
        List webankDepartmentList = null;
        String querySQL = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization  WHERE pid=100000";
        ArrayList<String> params = new ArrayList<String>();
        boolean first = true;
        try {
            if (StringUtils.isNotBlank((CharSequence)searchName)) {
                querySQL = querySQL + " AND ";
                querySQL = querySQL + " dp_ch_name LIKE ?";
                params.add('%' + searchName + '%');
                first = false;
            }
            webankDepartmentList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new WebankDepartmentHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find all Webank Department", e);
        }
        return webankDepartmentList;
    }

    @Override
    public List<WebankDepartment> findAllWebankDepartmentPageList(String searchName, int pageNum, int pageSize) throws SystemUserManagerException {
        List webankDepartmentList = null;
        String querySQL = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization  WHERE pid=100000";
        ArrayList<Object> params = new ArrayList<Object>();
        boolean first = false;
        try {
            if (StringUtils.isNotBlank((CharSequence)searchName)) {
                querySQL = querySQL + " AND ";
                querySQL = querySQL + " dp_ch_name LIKE ?";
                params.add('%' + searchName + '%');
                first = false;
            }
            if (pageNum > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(pageNum);
                params.add(pageSize);
            }
            webankDepartmentList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new WebankDepartmentHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find Webank Department", e);
        }
        return webankDepartmentList;
    }

    @Override
    public WebankDepartment getWebankDepartmentByDpId(int dpId) throws SystemUserManagerException {
        List webankDepartmentList = null;
        try {
            webankDepartmentList = (List)this.dbOperator.query("SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization  WHERE dp_id=? ", (ResultSetHandler)new WebankDepartmentHandler(), new Object[]{dpId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find Webank Department by dpId", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)webankDepartmentList)) {
            return (WebankDepartment)webankDepartmentList.get(0);
        }
        return null;
    }

    @Override
    public WebankDepartment getParentDepartmentByPId(int pId) throws SystemUserManagerException {
        List webankDepartmentList = null;
        try {
            webankDepartmentList = (List)this.dbOperator.query("SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization  WHERE pid=? ", (ResultSetHandler)new WebankDepartmentHandler(), new Object[]{pId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find Webank Department by dpId", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)webankDepartmentList)) {
            return (WebankDepartment)webankDepartmentList.get(0);
        }
        return null;
    }

    @Override
    public List<WebankDepartment> findAllWebankDepartmentPageOrSearch(String searchName, int pageNum, int pageSize) throws SystemUserManagerException {
        List webankDepartmentList = null;
        String querySQL = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, g.`name` , c.`upload_flag`  FROM cfg_webank_organization c LEFT JOIN department_group g ON g.`id` = c.`group_id` ";
        ArrayList<Object> params = new ArrayList<Object>();
        boolean first = true;
        try {
            if (StringUtils.isNotBlank((CharSequence)searchName)) {
                if (first) {
                    querySQL = querySQL + " WHERE ";
                    first = false;
                } else {
                    querySQL = querySQL + " AND ";
                }
                querySQL = querySQL + "c.dp_ch_name LIKE ? ";
                params.add('%' + searchName + '%');
                first = false;
            }
            if (pageNum > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(pageNum);
                params.add(pageSize);
            }
            webankDepartmentList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new FetchWebankDepartmentHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find Webank Department", e);
        }
        return webankDepartmentList;
    }

    @Override
    public int deleteWtssUser(String userId) throws SystemUserManagerException {
        String DELETE_WTSS_USER_BY_ID = "DELETE FROM wtss_user WHERE user_id=? ";
        try {
            return this.dbOperator.update("DELETE FROM wtss_user WHERE user_id=? ", new Object[]{userId});
        }
        catch (SQLException e) {
            logger.error("delet wtss user failed.", (Throwable)e);
            throw new SystemUserManagerException("Error deleting wtss user " + userId);
        }
    }

    @Override
    public WebankUser getWebankUserByUsername(String username) throws SystemUserManagerException {
        List webankUserList = null;
        try {
            webankUserList = (List)this.dbOperator.query("SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users WHERE urn=? ", (ResultSetHandler)new findAllWebankUserHandler(), new Object[]{username});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find Webank Department by userName", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)webankUserList)) {
            return (WebankUser)webankUserList.get(0);
        }
        return null;
    }

    @Override
    public int addDeparment(WebankDepartment webankDepartment) throws SystemUserManagerException {
        return this.addDeparmentHandel(webankDepartment);
    }

    private int addDeparmentHandel(WebankDepartment webankDepartment) throws SystemUserManagerException {
        String INSERT_DEPARMENT = "INSERT INTO cfg_webank_organization (dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag) values (?,?,?,?,?,?,?,?,?)";
        try {
            return this.dbOperator.update("INSERT INTO cfg_webank_organization (dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag) values (?,?,?,?,?,?,?,?,?)", new Object[]{webankDepartment.getDpId(), webankDepartment.getPid(), webankDepartment.getDpName(), webankDepartment.getDpChName(), webankDepartment.getOrgId(), webankDepartment.getOrgName(), webankDepartment.getDivision(), webankDepartment.getGroupId(), webankDepartment.getUploadFlag()});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException(String.format("Add User %s Failed", webankDepartment.toString()), e);
        }
    }

    @Override
    public int updateDeparment(WebankDepartment webankDepartment) throws SystemUserManagerException {
        String UPDATE_DEPARMENT_BY_ID = "UPDATE cfg_webank_organization SET pid=?, dp_name=?, dp_ch_name=?, org_id=?, org_name=?, division=? , group_id=? ,upload_flag=?  WHERE dp_id=? ";
        try {
            int updateResult = this.dbOperator.update("UPDATE cfg_webank_organization SET pid=?, dp_name=?, dp_ch_name=?, org_id=?, org_name=?, division=? , group_id=? ,upload_flag=?  WHERE dp_id=? ", new Object[]{webankDepartment.getPid(), webankDepartment.getDpName(), webankDepartment.getDpChName(), webankDepartment.getOrgId(), webankDepartment.getOrgName(), webankDepartment.getDivision(), webankDepartment.getGroupId(), webankDepartment.getUploadFlag(), webankDepartment.getDpId()});
            return updateResult;
        }
        catch (SQLException e) {
            throw new SystemUserManagerException(String.format("Error updating %s ", webankDepartment.toString()), e);
        }
    }

    @Override
    public int deleteDeparment(int dpId) throws SystemUserManagerException {
        String DELETE_DEPARMENT_BY_ID = "DELETE FROM cfg_webank_organization WHERE dp_id=? ";
        try {
            return this.dbOperator.update("DELETE FROM cfg_webank_organization WHERE dp_id=? ", new Object[]{dpId});
        }
        catch (SQLException e) {
            logger.error("delet wtss user failed.", (Throwable)e);
            throw new SystemUserManagerException("Error deleting deparment " + dpId);
        }
    }

    @Override
    public List<WtssUser> getSystemUserByDepartmentId(int dpId) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE department_id=? ", (ResultSetHandler)new SystemUserHandler(), new Object[]{dpId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("get SystemUser By DepartmentId failed, caused by:{}", e);
        }
        return wtssUserList;
    }

    @Override
    public List<WtssUser> getModifySystemUser(String modifyType) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            if (StringUtils.isBlank((CharSequence)modifyType)) {
                wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE modify_type !='0'", (ResultSetHandler)new SystemUserHandler());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user ").append(" WHERE modify_type=? ").append(" ORDER BY update_time DESC");
                wtssUserList = (List)this.dbOperator.query(builder.toString(), (ResultSetHandler)new SystemUserHandler(), new Object[]{modifyType});
            }
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("get Modify SystemUser By modifyType failed, caused by:{}", e);
        }
        return wtssUserList;
    }

    @Override
    public List<WtssUser> getModifySystemUser(int start, int pageSize) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            ArrayList<Integer> params = new ArrayList<Integer>();
            if (start > -1 && pageSize > 0) {
                params.add(start);
                params.add(pageSize);
            }
            wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE modify_type !='0' Limit ?, ?", (ResultSetHandler)new SystemUserHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("get Modify SystemUser By modifyType failed, caused by:{}", e);
        }
        return wtssUserList;
    }

    @Override
    public List<WtssUser> getModifySystemUser(String searchterm, int start, int pageSize) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            String querySQL = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE modify_type !='0'";
            ArrayList<Object> params = new ArrayList<Object>();
            if (StringUtils.isNotBlank((CharSequence)searchterm)) {
                querySQL = querySQL + " AND full_name LIKE ?";
                params.add('%' + searchterm + '%');
            }
            if (start > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(start);
                params.add(pageSize);
            }
            wtssUserList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new SystemUserHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find WTSS User", e);
        }
        return wtssUserList;
    }

    @Override
    public String getModifyInfoSystemUserById(String userId) throws SystemUserManagerException {
        WtssUser wtssUserByUserId = this.getWtssUserByUserId(userId);
        if (null == wtssUserByUserId) {
            throw new SystemUserManagerException("Failed to find WTSS User by userId");
        }
        return wtssUserByUserId.getModifyInfo();
    }

    @Override
    public WtssUser getSystemUserByUserName(String userName) throws SystemUserManagerException {
        List wtssUserList = null;
        try {
            wtssUserList = (List)this.dbOperator.query("SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE username=? ", (ResultSetHandler)new SystemUserHandler(), new Object[]{userName});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find WTSS User by userName", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)wtssUserList)) {
            return (WtssUser)wtssUserList.get(0);
        }
        return null;
    }

    @Override
    public WebankUser getWebankUserByUserName(String userName) throws SystemUserManagerException {
        List webankUserList = null;
        try {
            webankUserList = (List)this.dbOperator.query("SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users WHERE urn=? ", (ResultSetHandler)new findAllWebankUserHandler(), new Object[]{userName});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find Webank User by userId", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)webankUserList)) {
            return (WebankUser)webankUserList.get(0);
        }
        return null;
    }

    @Override
    public List<DepartmentMaintainer> getDepartmentMaintainerList(String searchterm, int start, int pageSize) throws SystemUserManagerException {
        List departmentMaintainerList = null;
        try {
            String querySQL = "SELECT department_id, department_name, ops_user FROM department_maintainer ";
            ArrayList<Object> params = new ArrayList<Object>();
            if (StringUtils.isNotBlank((CharSequence)searchterm)) {
                querySQL = querySQL + " WHERE department_id LIKE ? or department_name LIKE ? or ops_user LIKE ?";
                params.add('%' + searchterm + '%');
                params.add('%' + searchterm + '%');
                params.add('%' + searchterm + '%');
            }
            if (start > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(start);
                params.add(pageSize);
            }
            departmentMaintainerList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new DepartmentMaintainerHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find department maintainer, caused by:", e);
        }
        return departmentMaintainerList;
    }

    @Override
    public List<DepartmentMaintainer> getDepartmentMaintainerList(int start, int pageSize) throws SystemUserManagerException {
        List departmentMaintainerList = null;
        try {
            String querySQL = "SELECT department_id, department_name, ops_user FROM department_maintainer ";
            ArrayList<Integer> params = new ArrayList<Integer>();
            if (start > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(start);
                params.add(pageSize);
            }
            departmentMaintainerList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new DepartmentMaintainerHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find department maintainer, caused by:", e);
        }
        return departmentMaintainerList;
    }

    @Override
    public DepartmentMaintainer getDepMaintainerByDepId(long departmentId) throws SystemUserManagerException {
        List departmentMaintainerList = null;
        try {
            String querySQL = "SELECT department_id, department_name, ops_user FROM department_maintainer  WHERE department_id=? ";
            departmentMaintainerList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new DepartmentMaintainerHandler(), new Object[]{departmentId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find department maintainer, caused by:", e);
        }
        if (CollectionUtils.isNotEmpty((Collection)departmentMaintainerList)) {
            return (DepartmentMaintainer)departmentMaintainerList.get(0);
        }
        return null;
    }

    @Override
    public int getDepartmentMaintainerTotal() throws SystemUserManagerException {
        IntHandler intHandler = new IntHandler();
        try {
            return (Integer)this.dbOperator.query(IntHandler.GET_DEPARTMENT_MAINTAINER_TOTAL, (ResultSetHandler)intHandler);
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to find the total of Department Maintainer.", e);
        }
    }

    @Override
    public int updateDepartmentMaintainer(long departmentId, String departmentName, String depMaintainer) throws SystemUserManagerException {
        String UPDATE_DEPARTMENT_MAINTAINER = "UPDATE department_maintainer SET department_id=?, department_name=?, ops_user=? WHERE department_id=? ";
        try {
            return this.dbOperator.update("UPDATE department_maintainer SET department_id=?, department_name=?, ops_user=? WHERE department_id=? ", new Object[]{departmentId, departmentName, depMaintainer, departmentId});
        }
        catch (SQLException e) {
            Integer destDepartmentId = Integer.valueOf(departmentId + "");
            String objectStr = new DepartmentMaintainer(destDepartmentId, departmentName, depMaintainer).toString();
            throw new SystemUserManagerException(String.format("Error adding %s ", objectStr), e);
        }
    }

    @Override
    public int deleteDepartmentMaintainer(Integer departmentId) throws SystemUserManagerException {
        String DELETE_DEPARTMENT_MAINTAINER_BY_ID = "DELETE FROM department_maintainer WHERE department_id=? ";
        try {
            return this.dbOperator.update("DELETE FROM department_maintainer WHERE department_id=? ", new Object[]{departmentId});
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Error delete Department Maintainer, id= " + departmentId);
        }
    }

    @Override
    public int addDepartmentMaintainer(long departmentId, String departmentName, String userName) throws SystemUserManagerException {
        String INSERT_DEPARTMENT_MAINTAINER = "INSERT INTO department_maintainer (department_id, department_name, ops_user) values (?,?,?)";
        try {
            return this.dbOperator.update("INSERT INTO department_maintainer (department_id, department_name, ops_user) values (?,?,?)", new Object[]{departmentId, departmentName, userName});
        }
        catch (SQLException e) {
            Integer destDepartmentId = Integer.valueOf(departmentId + "");
            String objectStr = new DepartmentMaintainer(destDepartmentId, departmentName, userName).toString();
            throw new SystemUserManagerException(String.format("Add department maintainer %s Failed", objectStr), e);
        }
    }

    @Override
    public List<Integer> getDepartmentMaintainerDepListByUserName(String loginUserName) throws SystemUserManagerException {
        List departmentMaintainerList = null;
        try {
            String querySql = "SELECT department_id, department_name, ops_user FROM department_maintainer ";
            ArrayList<String> params = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)loginUserName)) {
                querySql = querySql + " WHERE ops_user LIKE ?";
                params.add('%' + loginUserName + '%');
            }
            if (CollectionUtils.isNotEmpty((Collection)(departmentMaintainerList = (List)this.dbOperator.query(querySql, (ResultSetHandler)new DepartmentMaintainerHandler(), params.toArray())))) {
                ArrayList<DepartmentMaintainer> realDataList = new ArrayList<DepartmentMaintainer>();
                for (DepartmentMaintainer departmentMaintainer : departmentMaintainerList) {
                    String opsUserStr = departmentMaintainer.getOpsUser().trim();
                    List<String> opsUserList = this.filterInvalidData(opsUserStr);
                    if (!CollectionUtils.isNotEmpty(opsUserList) || !opsUserList.contains(loginUserName)) continue;
                    realDataList.add(departmentMaintainer);
                }
                return realDataList.stream().map(DepartmentMaintainer::getDepartmentId).collect(Collectors.toList());
            }
            return null;
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("Failed to page find department maintainer depId, caused by:", e);
        }
    }

    @Override
    public List<Integer> getMaintainedProjects(String username) throws SystemUserManagerException {
        String querySql = "SELECT pr.id FROM projects pr JOIN wtss_user w on w.username=pr.create_user JOIN department_maintainer d on d.department_id=w.department_id WHERE pr.active=1 and d.ops_user like '%" + username + "%'";
        try {
            return (List)this.dbOperator.query(querySql, this::getProjectIds);
        }
        catch (SQLException e) {
            throw new SystemUserManagerException("get maintained projects of " + username + " failed", e);
        }
    }

    private List<String> filterInvalidData(String originStr) {
        String[] strings = originStr.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String string : strings) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            list.add(string);
        }
        return list;
    }

    private List<Integer> getProjectIds(ResultSet rs) throws SQLException {
        ArrayList<Integer> projectIds = new ArrayList<Integer>();
        while (rs.next()) {
            projectIds.add(rs.getInt(1));
        }
        return projectIds;
    }

    private static class FetchWebankDepartmentHandler
    implements ResultSetHandler<List<WebankDepartment>> {
        private static final String FETCH_ALL_WEBANK_DEPARTMENT = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, g.`name` , c.`upload_flag`  FROM cfg_webank_organization c LEFT JOIN department_group g ON g.`id` = c.`group_id` ";

        private FetchWebankDepartmentHandler() {
        }

        public List<WebankDepartment> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<WebankDepartment> webankDepartmentList = new ArrayList<WebankDepartment>();
            do {
                long dpId = rs.getLong(1);
                long pid = rs.getLong(2);
                String dpName = rs.getString(3);
                String dpChName = rs.getString(4);
                long orgId = rs.getLong(5);
                String orgName = rs.getString(6);
                String division = rs.getString(7);
                String groupName = rs.getString(8);
                int uploadFlag = rs.getInt(9);
                DepartmentGroup departmentGroup = new DepartmentGroup();
                departmentGroup.setName(groupName);
                WebankDepartment info = new WebankDepartment(dpId, dpName, dpChName, orgId, orgName, division, pid, uploadFlag);
                info.setDepartmentGroup(departmentGroup);
                webankDepartmentList.add(info);
            } while (rs.next());
            return webankDepartmentList;
        }
    }

    private static class WebankDepartmentHandler
    implements ResultSetHandler<List<WebankDepartment>> {
        private static final String BASE_SQL_FIND_ALL_WEBANK_DEPARTMENT = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization ";
        private static final String FIND_WEBANK_DEPARTMENT_NO_ORG = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization  WHERE pid=100000";
        private static final String FIND_WEBANK_DEPARTMENT_BY_DPID = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization  WHERE dp_id=? ";
        private static final String FIND_WEBANK_DEPARTMENT_BY_PID = "SELECT dp_id, pid, dp_name, dp_ch_name, org_id, org_name, division, group_id, upload_flag FROM cfg_webank_organization  WHERE pid=? ";

        private WebankDepartmentHandler() {
        }

        public List<WebankDepartment> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<WebankDepartment> webankDepartmentList = new ArrayList<WebankDepartment>();
            do {
                long dpId = rs.getLong(1);
                long pid = rs.getLong(2);
                String dpName = rs.getString(3);
                String dpChName = rs.getString(4);
                long orgId = rs.getLong(5);
                String orgName = rs.getString(6);
                String division = rs.getString(7);
                int groupId = rs.getInt(8);
                int uploadFlag = rs.getInt(9);
                WebankDepartment info = new WebankDepartment(dpId, dpName, dpChName, orgId, orgName, division, pid, groupId, uploadFlag);
                webankDepartmentList.add(info);
            } while (rs.next());
            return webankDepartmentList;
        }
    }

    private static class WtssPermissionsHandler
    implements ResultSetHandler<List<WtssPermissions>> {
        private static final String BASE_SQL_FIND_WTSS_PERM = "SELECT permissions_id, permissions_name, permissions_value, permissions_type, description, create_time, update_time FROM wtss_permissions ";
        private static final String FIND_WTSS_PERM_BY_ID = "SELECT permissions_id, permissions_name, permissions_value, permissions_type, description, create_time, update_time FROM wtss_permissions  WHERE permissions_id=? ";
        private static final String FIND_WTSS_PERM_BY_IDS = "SELECT permissions_id, permissions_name, permissions_value, permissions_type, description, create_time, update_time FROM wtss_permissions  WHERE permissions_id in ";

        private WtssPermissionsHandler() {
        }

        public List<WtssPermissions> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<WtssPermissions> wtssPermissionsList = new ArrayList<WtssPermissions>();
            do {
                int permissionsId = rs.getInt(1);
                String rolepermissionsName = rs.getString(2);
                int permissions_value = rs.getInt(3);
                int permissions_type = rs.getInt(4);
                String description = rs.getString(5);
                long createdTime = rs.getLong(6);
                long updateTime = rs.getLong(7);
                WtssPermissions info = new WtssPermissions(permissionsId, rolepermissionsName, permissions_value, permissions_type, description, createdTime, updateTime);
                wtssPermissionsList.add(info);
            } while (rs.next());
            return wtssPermissionsList;
        }
    }

    private static class WtssRoleHandler
    implements ResultSetHandler<List<WtssRole>> {
        private static final String BASE_SQL_FIND_WTSS_ROLE = "SELECT role_id,role_name, permissions_ids, description, create_time, update_time FROM wtss_role ";
        private static final String FIND_WTSS_ROLE_BY_ID = "SELECT role_id,role_name, permissions_ids, description, create_time, update_time FROM wtss_role  WHERE role_id=? ";

        private WtssRoleHandler() {
        }

        public List<WtssRole> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<WtssRole> wtssRoleList = new ArrayList<WtssRole>();
            do {
                int roleId = rs.getInt(1);
                String roleName = rs.getString(2);
                String permissions_ids = rs.getString(3);
                String description = rs.getString(4);
                long createdTime = rs.getLong(5);
                long updateTime = rs.getLong(6);
                WtssRole info = new WtssRole(roleId, roleName, permissions_ids, description, createdTime, updateTime);
                wtssRoleList.add(info);
            } while (rs.next());
            return wtssRoleList;
        }
    }

    public static class IntHandler
    implements ResultSetHandler<Integer> {
        public static String GET_WEBANK_USER_TOTAL = "SELECT count(*) FROM cfg_webank_all_users";
        public static String GET_WTSS_USER_TOTAL = "SELECT count(*) FROM wtss_user";
        public static String GET_WEBANK_DEPARTMENT_TOTAL = "SELECT count(*) FROM cfg_webank_organization ";
        public static String GET_DEPARTMENT_MAINTAINER_TOTAL = "SELECT count(*) FROM department_maintainer ";

        public Integer handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return 0;
            }
            return rs.getInt(1);
        }
    }

    private static class SystemUserHandler
    implements ResultSetHandler<List<WtssUser>> {
        private static final String BASE_SQL_FIND_WTSS_USER = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user ";
        private static final String FIND_ALL_MODIFY_WTSS_USER = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE modify_type !='0'";
        private static final String FIND_WTSS_USER_BY_MODIFY_TYPE = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE modify_type=? ";
        private static final String FIND_WTSS_USER_BY_DEPARTMENT_ID = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE department_id=? ";
        private static final String FIND_WTSS_USER_BY_ID = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE user_id=? ";
        private static final String FIND_WTSS_USER_BY_NAME = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE username=? ";
        private static final String FIND_WTSS_USER_BY_USERNAME_AND_PASSWORD = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE username=? AND password=? ";
        private static final String FIND_WTSS_USER_BY_USERNAME = "SELECT user_id, username, password, full_name, department_id, department_name, email, proxy_users, role_id, user_type, create_time, update_time, modify_info, modify_type, user_category  FROM wtss_user  WHERE username=? ";

        private SystemUserHandler() {
        }

        public List<WtssUser> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<WtssUser> wtssUserList = new ArrayList<WtssUser>();
            do {
                String userId = rs.getString(1);
                String username = rs.getString(2);
                String password = rs.getString(3);
                String fullName = rs.getString(4);
                long departmentId = rs.getLong(5);
                String departmentName = rs.getString(6);
                String email = rs.getString(7);
                String proxyUsers = rs.getString(8);
                int roleId = rs.getInt(9);
                int userType = rs.getInt(10);
                long createdTime = rs.getLong(11);
                long updateTime = rs.getLong(12);
                String modifyInfo = rs.getString(13);
                String modifyType = rs.getString(14);
                String userCategory = rs.getString(15);
                WtssUser wtssUser = new WtssUser();
                wtssUser.setUserId(userId);
                wtssUser.setUsername(username);
                wtssUser.setPassword(password);
                wtssUser.setFullName(fullName);
                wtssUser.setDepartmentId(departmentId);
                wtssUser.setEmail(email);
                wtssUser.setDepartmentName(departmentName);
                wtssUser.setProxyUsers(proxyUsers);
                wtssUser.setRoleId(roleId);
                wtssUser.setUserType(userType);
                wtssUser.setCreateTime(createdTime);
                wtssUser.setUpdateTime(updateTime);
                wtssUser.setModifyInfo(modifyInfo);
                wtssUser.setModifyType(modifyType);
                wtssUser.setUserCategory(userCategory);
                wtssUserList.add(wtssUser);
            } while (rs.next());
            return wtssUserList;
        }
    }

    private static class DepartmentMaintainerHandler
    implements ResultSetHandler<List<DepartmentMaintainer>> {
        private static final String BASE_SQL_FIND_DEPARTMENT_MAINTAINER = "SELECT department_id, department_name, ops_user FROM department_maintainer ";
        private static final String FIND_DEPARTMENT_ID_BY_ID = "SELECT department_id, department_name, ops_user FROM department_maintainer  WHERE department_id=? ";

        private DepartmentMaintainerHandler() {
        }

        public List<DepartmentMaintainer> handle(ResultSet resultSet) throws SQLException {
            if (!resultSet.next()) {
                return Collections.emptyList();
            }
            ArrayList<DepartmentMaintainer> departmentMaintainerList = new ArrayList<DepartmentMaintainer>();
            do {
                int departmentId = resultSet.getInt(1);
                String departmentName = resultSet.getString(2);
                String opsUser = resultSet.getString(3);
                DepartmentMaintainer departmentMaintainer = new DepartmentMaintainer();
                departmentMaintainer.setDepartmentId(departmentId);
                departmentMaintainer.setDepartmentName(departmentName);
                departmentMaintainer.setOpsUser(opsUser);
                departmentMaintainerList.add(departmentMaintainer);
            } while (resultSet.next());
            return departmentMaintainerList;
        }
    }

    private static class findAllWebankUserHandler
    implements ResultSetHandler<List<WebankUser>> {
        private static final String BASE_SQL_FIND_ALL_WEBANK_USER = "SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users";
        private static final String FIND_WEBANK_USER_BY_ID = "SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users WHERE user_id=? ";
        private static final String FIND_WEBANK_USER_BY_NAME = "SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users WHERE urn=? ";
        private static final String FIND_WEBANK_USER_BY_USERNAME = "SELECT app_id, user_id, urn, full_name, display_name, title, employee_number,manager_urn, org_id, default_group_name, email, department_id, department_name,start_date, mobile_phone, is_active, person_group, created_time, modified_time  FROM cfg_webank_all_users WHERE urn=? ";

        private findAllWebankUserHandler() {
        }

        public List<WebankUser> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<WebankUser> webankUserList = new ArrayList<WebankUser>();
            do {
                int appId = rs.getInt(1);
                String userId = rs.getString(2);
                String urn = rs.getString(3);
                String fullName = rs.getString(4);
                String displayName = rs.getString(5);
                String title = rs.getString(6);
                long employeeNumber = rs.getLong(7);
                String mangerUrn = rs.getString(8);
                long orgId = rs.getLong(9);
                String defaultGroupName = rs.getString(10);
                String email = rs.getString(11);
                long departmentId = rs.getLong(12);
                String departmentName = rs.getString(13);
                String startDate = rs.getString(14);
                String mobilePhone = rs.getString(15);
                String isActive = rs.getString(16);
                int personGroup = rs.getInt(17);
                long createdTime = rs.getLong(18);
                long modifiedTime = rs.getLong(19);
                WebankUser info = new WebankUser(appId, userId, urn, fullName, displayName, title, employeeNumber, mangerUrn, orgId, defaultGroupName, email, departmentId, departmentName, startDate, mobilePhone, isActive, personGroup, createdTime, modifiedTime);
                webankUserList.add(info);
            } while (rs.next());
            return webankUserList;
        }
    }
}

