/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.log;

import azkaban.db.DatabaseOperator;
import azkaban.db.EncodingType;
import azkaban.db.SQLTransaction;
import azkaban.executor.ExecutorManagerException;
import com.webank.wedatasphere.schedulis.common.log.LogCodeType;
import com.webank.wedatasphere.schedulis.common.log.LogFilterEntity;
import com.webank.wedatasphere.schedulis.common.log.OperateType;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LogFilterDao {
    private static final Logger logger = LoggerFactory.getLogger(LogFilterDao.class);
    private final DatabaseOperator dbOperator;

    @Inject
    public LogFilterDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public synchronized Integer uploadLogFilter(LogFilterEntity filterEntity) throws ExecutorManagerException {
        String INSERT_LOG_FILTER_FLOW = "INSERT INTO log_filter (log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time) values (?,?,?,?,?,?,?)";
        java.util.Date submitTime = new java.util.Date();
        SQLTransaction insertAndGetLastID = transOperator -> {
            transOperator.update("INSERT INTO log_filter (log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time) values (?,?,?,?,?,?,?)", new Object[]{filterEntity.getLogCode(), filterEntity.getCodeType(), filterEntity.getCompareText(), filterEntity.getOperateType(), filterEntity.getLogNotice(), submitTime, submitTime});
            transOperator.getConnection().commit();
            return transOperator.getLastInsertId();
        };
        try {
            long id = (Long)this.dbOperator.transaction(insertAndGetLastID);
            logger.info("History Recover given " + filterEntity.getCodeId() + " given id " + id);
            filterEntity.setCodeId((int)id);
            this.updateLogFilterFlow(filterEntity);
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error creating History Recover.", e);
        }
        return filterEntity.getCodeId();
    }

    void updateLogFilterFlow(LogFilterEntity logFilterEntity) throws ExecutorManagerException {
        this.updateLogFilterFlow(logFilterEntity, EncodingType.GZIP);
    }

    private void updateLogFilterFlow(LogFilterEntity logFilterEntity, EncodingType encType) throws ExecutorManagerException {
        String UPDATE_LOG_FILTER_FLOW_DATA = "UPDATE log_filter SET log_code=?, code_type=?, compare_text=?, operate_type=?, log_notice=?, update_time=? WHERE code_id=? ";
        java.util.Date updateTime = new java.util.Date();
        try {
            this.dbOperator.update("UPDATE log_filter SET log_code=?, code_type=?, compare_text=?, operate_type=?, log_notice=?, update_time=? WHERE code_id=? ", new Object[]{logFilterEntity.getLogCode(), logFilterEntity.getCodeType(), logFilterEntity.getCompareText(), logFilterEntity.getOperateType(), logFilterEntity.getLogNotice(), updateTime, logFilterEntity.getCodeId()});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error updating History Recover.", e);
        }
    }

    public List<LogFilterEntity> listAllLogFilter() throws ExecutorManagerException {
        String query = FetchLogFilterEntity.LIST_BASE_LOG_FILTER_QUERY;
        ArrayList params = new ArrayList();
        try {
            return (List)this.dbOperator.query(query, (ResultSetHandler)new FetchLogFilterEntity(), params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Error fetching history recover flows", e);
        }
    }

    public static class FetchLogFilterEntity
    implements ResultSetHandler<List<LogFilterEntity>> {
        static String LIST_BASE_LOG_FILTER_QUERY = "SELECT code_id, log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time FROM log_filter ";
        static String LIST_LOG_FILTER_BY_ID = "SELECT code_id, log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time FROM log_filter WHERE code_id=?";
        static String LIST_ALL_LOG_FILTER_HISTORY = "SELECT code_id, log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time FROM log_filter ORDER BY code_id DESC LIMIT ?, ?";
        static String LIST_EXECUTABLE_FLOW_HISTORY = "SELECT code_id, log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time FROM log_filter WHERE project_id=? AND flow_id=? ORDER BY exec_id DESC LIMIT ?, ?";
        static String LIST_EXECUTABLE_FLOW_BY_STATUS = "SELECT code_id, log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time FROM log_filter WHERE project_id=? AND flow_id=? AND status=? ORDER BY exec_id DESC LIMIT ?, ?";
        static String LIST_USER_LOG_FILTER_FLOW_HISTORY = "SELECT code_id, log_code, code_type, compare_text, operate_type, log_notice, submit_time, update_time FROM log_filter WHERE submit_user=? ORDER BY recover_id DESC LIMIT ?, ?";

        public List<LogFilterEntity> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<LogFilterEntity> logFilterList = new ArrayList<LogFilterEntity>();
            do {
                try {
                    int codeId = rs.getInt(1);
                    String logCode = rs.getString(2);
                    int codeType = rs.getInt(3);
                    String compareText = rs.getString(4);
                    int operateType = rs.getInt(5);
                    String logNotice = rs.getString(6);
                    Date submitTime = rs.getDate(7);
                    Date updateTime = rs.getDate(8);
                    LogFilterEntity filterObj = new LogFilterEntity(codeId, logCode, LogCodeType.fromInteger(codeType), compareText, OperateType.fromInteger(operateType), logNotice, submitTime, updateTime);
                    logFilterList.add(filterObj);
                }
                catch (Exception e) {
                    throw new SQLException("Error retrieving History Recover data ", e);
                }
            } while (rs.next());
            return logFilterList;
        }
    }
}

