/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.jobExecutor.utils;

import azkaban.executor.ExecutableFlow;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SystemBuiltInParamUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemBuiltInParamUtils.class);
    public static final String RUN_DATE = "run_date";
    public static final String RUN_DATE_STD = "run_date_std";
    public static final String RUN_MONTH_BEGIN = "run_month_begin";
    public static final String RUN_MONTH_BEGIN_STD = "run_month_begin_std";
    public static final String RUN_MONTH_END = "run_month_end";
    public static final String RUN_MONTH_END_STD = "run_month_end_std";
    public static final String MINUS = "MINUS";
    public static final String PLUS = "PLUS";
    private Map<String, String> propMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FileWrite(String filePath, String fileStr) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(filePath);
            fw.write(fileStr);
        }
        catch (Exception e) {
            logger.error("\u5199\u5165\u811a\u672c\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<String> loadAllPropertiesFile(String workingDir) {
        ArrayList<String> propPathList = new ArrayList<String>();
        this.findPropPath(workingDir, propPathList);
        return propPathList;
    }

    private void findPropPath(String dirPath, List<String> filePathList) {
        File f = new File(dirPath);
        if (!f.exists()) {
            System.out.println(dirPath + " not exists");
        }
        File[] fa = f.listFiles();
        for (int i = 0; i < fa.length; ++i) {
            File fs = fa[i];
            if (fs.isDirectory()) {
                this.findPropPath(fs.getPath(), filePathList);
                continue;
            }
            if (!fs.getName().endsWith(".properties")) continue;
            filePathList.add(fs.getPath().toString());
        }
    }

    private List<String> loadAllScriptFile(String workingDir) {
        ArrayList<String> scriptPathList = new ArrayList<String>();
        this.findScriptFilePath(workingDir, scriptPathList);
        return scriptPathList;
    }

    private void findScriptFilePath(String dirPath, List<String> filePathList) {
        File f = new File(dirPath);
        if (!f.exists()) {
            logger.error("\u6587\u4ef6\u5730\u5740: " + dirPath + "\u4e0d\u5b58\u5728\uff01");
        }
        File[] fa = f.listFiles();
        for (int i = 0; i < fa.length; ++i) {
            File fs = fa[i];
            if (fs.isDirectory()) {
                this.findScriptFilePath(fs.getPath(), filePathList);
                continue;
            }
            if (!fs.getName().endsWith(".py") && !fs.getName().endsWith(".sh") && !fs.getName().endsWith(".sql") && !fs.getName().endsWith(".hql")) continue;
            filePathList.add(fs.getPath().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readProperties(String propPath) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(propPath);
            prop.load(input);
            if (!prop.isEmpty()) {
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    String key = String.valueOf(entry.getKey());
                    String value = String.valueOf(entry.getValue());
                    propMap.put(key, value);
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u8bfb\u53d6properties\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return propMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String filePath) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            String fileStr;
            File file = new File(filePath);
            br = new BufferedReader(new FileReader(file));
            char[] data = new char[1024];
            int rn = 0;
            String line = "";
            while ((rn = br.read(data)) > 0) {
                String st = String.valueOf(data, 0, rn);
                sb.append(st);
            }
            String string = fileStr = sb.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u811a\u672c\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    private Map<String, String> paramDecompose(String fileStr, ExecutableFlow ef) {
        HashMap<String, String> paramReplaceMap = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        Matcher matcher = pattern.matcher(fileStr);
        while (matcher.find()) {
            String fullStr = matcher.group();
            String valueStr = matcher.group(1);
            if (0 == ef.getFlowType()) {
                paramReplaceMap.put(fullStr, this.scriptTimeHandleOther(valueStr, ef.getStartTime()));
                continue;
            }
            paramReplaceMap.put(fullStr, this.scriptTimeHandleOther(valueStr, Long.valueOf(ef.getRepeatOption().get("startTimeLong"))));
        }
        return paramReplaceMap;
    }

    private String scriptTimeHandle(String param, long runDate) {
        String[] sAry;
        String mathStr;
        String timeStr = "";
        Date date = new Date(runDate);
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate().minusDays(1L);
        if (RUN_DATE.equals(param = param.replaceAll("\\s*", ""))) {
            timeStr = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        } else if (RUN_DATE_STD.equals(param)) {
            timeStr = localDate.toString();
        } else if (param.contains(RUN_DATE) && !param.contains(RUN_DATE_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_DATE);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.minusDays(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.plusDays(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            }
        } else if (param.contains(RUN_DATE) && param.contains(RUN_DATE_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_DATE_STD);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.minusDays(Long.valueOf(sAry[1])).toString();
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.plusDays(Long.valueOf(sAry[1])).toString();
            }
        }
        if (RUN_MONTH_BEGIN.equals(param)) {
            timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        } else if (RUN_MONTH_BEGIN_STD.equals(param)) {
            timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).toString();
        } else if (param.contains(RUN_MONTH_BEGIN) && !param.contains(RUN_MONTH_BEGIN_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_MONTH_BEGIN);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).plusMonths(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            }
        } else if (param.contains(RUN_MONTH_BEGIN) && param.contains(RUN_MONTH_BEGIN_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_MONTH_BEGIN_STD);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(Long.valueOf(sAry[1])).toString();
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).plusMonths(Long.valueOf(sAry[1])).toString();
            }
        }
        return timeStr;
    }

    private String scriptTimeHandleOther(String param, long runDate) {
        String[] sAry;
        String mathStr;
        String timeStr = "";
        Date date = new Date(runDate);
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate localDate = instant.atZone(zoneId).toLocalDate().minusDays(1L);
        if (RUN_DATE.equals(param = param.replaceAll("\\s*", ""))) {
            timeStr = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        } else if (RUN_DATE_STD.equals(param)) {
            timeStr = localDate.toString();
        } else if (param.contains(RUN_DATE) && !param.contains(RUN_DATE_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_DATE);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.minusDays(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.plusDays(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            }
        } else if (param.contains(RUN_DATE) && param.contains(RUN_DATE_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_DATE_STD);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.minusDays(Long.valueOf(sAry[1])).toString();
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.plusDays(Long.valueOf(sAry[1])).toString();
            }
        }
        if (RUN_MONTH_BEGIN.equals(param)) {
            timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        } else if (RUN_MONTH_BEGIN_STD.equals(param)) {
            timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).toString();
        } else if (param.contains(RUN_MONTH_BEGIN) && !param.contains(RUN_MONTH_BEGIN_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_MONTH_BEGIN);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).plusMonths(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            }
        } else if (param.contains(RUN_MONTH_BEGIN) && param.contains(RUN_MONTH_BEGIN_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_MONTH_BEGIN_STD);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(Long.valueOf(sAry[1])).toString();
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.with(TemporalAdjusters.firstDayOfMonth()).plusMonths(Long.valueOf(sAry[1])).toString();
            }
        }
        if (RUN_MONTH_END.equals(param)) {
            timeStr = localDate.withDayOfMonth(localDate.lengthOfMonth()).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        } else if (RUN_MONTH_END_STD.equals(param)) {
            timeStr = localDate.withDayOfMonth(localDate.lengthOfMonth()).toString();
        } else if (param.contains(RUN_MONTH_END) && !param.contains(RUN_MONTH_END_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_MONTH_END);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.withDayOfMonth(localDate.lengthOfMonth()).minusMonths(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.withDayOfMonth(localDate.lengthOfMonth()).plusMonths(Long.valueOf(sAry[1])).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            }
        } else if (param.contains(RUN_MONTH_END) && param.contains(RUN_MONTH_END_STD)) {
            mathStr = StringUtils.substringAfter((String)param, (String)RUN_MONTH_END_STD);
            sAry = new String[]{};
            if (MINUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("-");
                timeStr = localDate.withDayOfMonth(localDate.lengthOfMonth()).minusMonths(Long.valueOf(sAry[1])).toString();
            } else if (PLUS.equals(this.paramVerify(mathStr, param))) {
                sAry = mathStr.split("\\+");
                timeStr = localDate.withDayOfMonth(localDate.lengthOfMonth()).plusMonths(Long.valueOf(sAry[1])).toString();
            }
        }
        return timeStr;
    }

    private void filterUserParam(Map<String, String> systemParam) {
        HashMap<String, String> handleMap = new HashMap<String, String>();
        handleMap.putAll(systemParam);
        for (String userKey : this.getPropMap().keySet()) {
            for (String systemKey : handleMap.keySet()) {
                if (systemKey.contains(userKey) && !userKey.contains("_std") && !systemKey.contains(userKey + "_std")) {
                    systemParam.remove(systemKey);
                }
                if (!systemKey.contains(userKey) || !userKey.contains("_std")) continue;
                systemParam.remove(systemKey);
            }
        }
    }

    public void run(String workingDir, ExecutableFlow ef) {
        SystemBuiltInParamUtils df = new SystemBuiltInParamUtils();
        List<String> propPathList = df.loadAllPropertiesFile(workingDir);
        for (String filePath : propPathList) {
            df.getPropMap().putAll(df.readProperties(filePath));
        }
        List<String> scriptPathList = df.loadAllScriptFile(workingDir);
        for (String filePath : scriptPathList) {
            String fileStr = df.readFile(filePath);
            System.out.println("===============Start===============");
            Map<String, String> scriptMap = df.paramDecompose(fileStr, ef);
            if (StringUtils.isEmpty((String)df.getPropMap().get(RUN_DATE))) {
                if (StringUtils.isEmpty((String)df.getPropMap().get(RUN_DATE_STD))) {
                    df.filterUserParam(scriptMap);
                    for (String timeStr : scriptMap.keySet()) {
                        fileStr = StringUtils.replace((String)fileStr, (String)timeStr, (String)scriptMap.get(timeStr));
                    }
                }
            }
            System.out.println("===============End================");
            df.FileWrite(filePath, fileStr);
        }
    }

    public static void main(String[] args) {
        LocalDate localDate = LocalDate.now().minusDays(1L);
        String timeStr = localDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        System.out.println(localDate.toString());
        System.out.println(timeStr);
    }

    public Map<String, String> getPropMap() {
        return this.propMap;
    }

    public void setPropMap(Map<String, String> propMap) {
        this.propMap = propMap;
    }

    public void addPropMap(String key, String value) {
        this.propMap.put(key, value);
    }

    private String paramVerify(String param, String fullParam) {
        int minusSite = param.indexOf("-");
        int plusSite = param.indexOf("+");
        String symbol = "";
        String[] sAry = null;
        if (plusSite > minusSite && minusSite != -1 || plusSite == -1) {
            sAry = param.split("-");
            symbol = MINUS;
        } else if (minusSite > plusSite && plusSite != -1 || minusSite == -1) {
            sAry = param.split("\\+");
            symbol = PLUS;
        }
        if (sAry.length > 1 && sAry.length == 2) {
            String start = sAry[0];
            if (StringUtils.isNotEmpty((String)start)) {
                logger.error("\u811a\u672c\u66ff\u6362\u53c2\u6570\u9002\u914d\u5f02\u5e38\uff01\u8bf7\u68c0\u67e5\u811a\u672c\uff01");
                throw new RuntimeException("The script parameter ${" + fullParam + "} exception!Please check the script!");
            }
            String str = sAry[1];
            Pattern pattern = Pattern.compile("[0-9]*");
            if (!pattern.matcher(str).matches()) {
                logger.error("\u811a\u672c\u66ff\u6362\u53c2\u6570\u9002\u914d\u5f02\u5e38\uff01\u8bf7\u68c0\u67e5\u811a\u672c\uff01");
                throw new RuntimeException("The script parameter ${" + fullParam + "} exception!Please check the script!");
            }
        } else {
            if (sAry.length > 2) {
                logger.error("\u811a\u672c\u66ff\u6362\u53c2\u6570\u9002\u914d\u5f02\u5e38\uff01\u8bf7\u68c0\u67e5\u811a\u672c\uff01");
                throw new RuntimeException("The script parameter ${" + fullParam + "} exception!Please check the script!");
            }
            if (sAry.length <= 1) {
                logger.error("\u811a\u672c\u66ff\u6362\u53c2\u6570\u9002\u914d\u5f02\u5e38\uff01\u8bf7\u68c0\u67e5\u811a\u672c\uff01");
                throw new RuntimeException("The script parameter ${" + fullParam + "} exception!Please check the script!");
            }
        }
        return symbol;
    }
}

