/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.jobExecutor.utils;

import azkaban.executor.ExecutableFlow;
import com.webank.wedatasphere.schedulis.common.jobExecutor.utils.Date;
import com.webank.wedatasphere.schedulis.common.utils.DateUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemBuiltInParamJodeTimeUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemBuiltInParamJodeTimeUtils.class);
    public static final String TIME_TEMPLATE = "(\\d{4}\\.\\d{2}\\.\\d{2}|\\d{4}/\\d{2}/\\d{2}|\\d{4}-\\d{2}-\\d{2}|\\d{4}\\d{2}\\d{2})";
    private Map<String, String> propMap = new HashMap<String, String>();
    private Map<String, LocalDate> defaultDate = new HashMap<String, LocalDate>();
    private static String re = "[a-z_]+((\\+|-)[1-9][0-9]*){0,1}";

    private void initDate(ExecutableFlow executableFlow) throws RuntimeException {
        LocalDate runDate = null;
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
        if (2 == executableFlow.getFlowType()) {
            runDate = new LocalDate((Object)Long.valueOf(executableFlow.getRepeatOption().get("startTimeLong"))).minusDays(1);
        } else if (null != executableFlow.getExecutionOptions().getFlowParameters().get(Date.RUN_DATE.getValue())) {
            runDate = LocalDate.parse((String)executableFlow.getExecutionOptions().getFlowParameters().get(Date.RUN_DATE.getValue()), (DateTimeFormatter)dateTimeFormatter);
        } else if (this.propMap.get(Date.RUN_DATE.getValue()) != null) {
            String tmp = this.propMap.get(Date.RUN_DATE.getValue()).replaceAll("[\"'./-]", "");
            runDate = LocalDate.parse((String)tmp, (DateTimeFormatter)dateTimeFormatter);
        } else {
            runDate = new LocalDate(executableFlow.getSubmitTime()).minusDays(1);
        }
        executableFlow.setRunDate(runDate.toString("yyyyMMdd"));
        this.defaultDate.put(Date.RUN_DATE.getValue(), runDate);
        this.defaultDate.put(Date.RUN_DATE_STD.getValue(), runDate);
        this.defaultDate.put(Date.RUN_TODAY.getValue(), runDate.plusDays(1));
        this.defaultDate.put(Date.RUN_TODAY_STD.getValue(), runDate.plusDays(1));
        this.defaultDate.put(Date.RUN_MONTH_BEGIN.getValue(), runDate.dayOfMonth().withMinimumValue());
        this.defaultDate.put(Date.RUN_MONTH_BEGIN_STD.getValue(), runDate.dayOfMonth().withMinimumValue());
        this.defaultDate.put(Date.RUN_MONTH_END.getValue(), runDate.dayOfMonth().withMaximumValue());
        this.defaultDate.put(Date.RUN_MONTH_END_STD.getValue(), runDate.dayOfMonth().withMaximumValue());
        this.defaultDate.put(Date.RUN_QUARTER_BEGIN.getValue(), DateUtils.getQuarterBegin(runDate));
        this.defaultDate.put(Date.RUN_QUARTER_END.getValue(), DateUtils.getQuarterEnd(runDate));
        this.defaultDate.put(Date.RUN_HALF_YEAR_BEGIN.getValue(), DateUtils.getHalfYearBegin(runDate));
        this.defaultDate.put(Date.RUN_HALF_YEAR_END.getValue(), DateUtils.getHalfYearEnd(runDate));
        this.defaultDate.put(Date.RUN_YEAR_BEGIN.getValue(), DateUtils.getYearBegin(runDate));
        this.defaultDate.put(Date.RUN_YEAR_END.getValue(), DateUtils.getYearEnd(runDate));
        this.defaultDate.put(Date.RUN_LAST_MONTH_END.getValue(), DateUtils.getLastMonthEnd(runDate));
        this.defaultDate.put(Date.RUN_LAST_QUARTER_END.getValue(), DateUtils.getLastQuarterEnd(runDate));
        this.defaultDate.put(Date.RUN_LAST_YEAR_END.getValue(), DateUtils.getLastYearEnd(runDate));
        this.defaultDate.put(Date.RUN_QUARTER_BEGIN_STD.getValue(), DateUtils.getQuarterBegin(runDate));
        this.defaultDate.put(Date.RUN_QUARTER_END_STD.getValue(), DateUtils.getQuarterEnd(runDate));
        this.defaultDate.put(Date.RUN_HALF_YEAR_BEGIN_STD.getValue(), DateUtils.getHalfYearBegin(runDate));
        this.defaultDate.put(Date.RUN_HALF_YEAR_END_STD.getValue(), DateUtils.getHalfYearEnd(runDate));
        this.defaultDate.put(Date.RUN_YEAR_BEGIN_STD.getValue(), DateUtils.getYearBegin(runDate));
        this.defaultDate.put(Date.RUN_YEAR_END_STD.getValue(), DateUtils.getYearEnd(runDate));
        this.defaultDate.put(Date.RUN_LAST_MONTH_END_STD.getValue(), DateUtils.getLastMonthEnd(runDate));
        this.defaultDate.put(Date.RUN_LAST_QUARTER_END_STD.getValue(), DateUtils.getLastQuarterEnd(runDate));
        this.defaultDate.put(Date.RUN_LAST_YEAR_END_STD.getValue(), DateUtils.getLastYearEnd(runDate));
        if (2 != executableFlow.getFlowType()) {
            Date[] date;
            for (Date item : date = new Date[]{Date.RUN_DATE_STD, Date.RUN_TODAY, Date.RUN_TODAY_STD, Date.RUN_MONTH_BEGIN, Date.RUN_MONTH_BEGIN_STD, Date.RUN_MONTH_END, Date.RUN_MONTH_END_STD, Date.RUN_QUARTER_BEGIN, Date.RUN_QUARTER_BEGIN_STD, Date.RUN_QUARTER_END, Date.RUN_QUARTER_END_STD, Date.RUN_LAST_QUARTER_END, Date.RUN_LAST_QUARTER_END_STD, Date.RUN_HALF_YEAR_BEGIN, Date.RUN_HALF_YEAR_BEGIN_STD, Date.RUN_HALF_YEAR_END, Date.RUN_HALF_YEAR_END_STD, Date.RUN_YEAR_BEGIN, Date.RUN_YEAR_BEGIN_STD, Date.RUN_YEAR_END, Date.RUN_YEAR_END_STD, Date.RUN_LAST_MONTH_END, Date.RUN_LAST_MONTH_END_STD, Date.RUN_LAST_YEAR_END, Date.RUN_LAST_YEAR_END_STD}) {
                LocalDate newDate = this.hasNewDate(executableFlow, item);
                if (newDate == null) continue;
                this.defaultDate.put(item.getValue(), newDate);
            }
        }
    }

    private LocalDate hasNewDate(ExecutableFlow executableFlow, Date dateType) {
        LocalDate newDate = null;
        if (null != executableFlow.getExecutionOptions().getFlowParameters().get(dateType.getValue())) {
            newDate = LocalDate.parse((String)executableFlow.getExecutionOptions().getFlowParameters().get(dateType.getValue()), (DateTimeFormatter)DateTimeFormat.forPattern((String)dateType.getFormat()));
        } else if (this.propMap.get(dateType.getValue()) != null) {
            newDate = LocalDate.parse((String)this.propMap.get(dateType.getValue()), (DateTimeFormatter)DateTimeFormat.forPattern((String)dateType.getFormat()));
        }
        return newDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void FileWrite(String filePath, String fileStr) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(filePath);
            fw.write(fileStr);
        }
        catch (Exception e) {
            logger.error("\u5199\u5165\u811a\u672c\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<String> loadAllPropertiesFile(String workingDir) {
        ArrayList<String> propPathList = new ArrayList<String>();
        this.findPropPath(workingDir, propPathList);
        return propPathList;
    }

    private void findPropPath(String dirPath, List<String> filePathList) {
        File f = new File(dirPath);
        if (!f.exists()) {
            System.out.println(dirPath + " not exists");
        }
        File[] fa = f.listFiles();
        for (int i = 0; i < fa.length; ++i) {
            File fs = fa[i];
            if (fs.isDirectory()) {
                this.findPropPath(fs.getPath(), filePathList);
                continue;
            }
            if (!fs.getName().endsWith(".properties")) continue;
            filePathList.add(fs.getPath().toString());
        }
    }

    private List<String> loadAllScriptFile(String workingDir) {
        ArrayList<String> scriptPathList = new ArrayList<String>();
        this.findScriptFilePath(workingDir, scriptPathList);
        return scriptPathList;
    }

    private void findScriptFilePath(String dirPath, List<String> filePathList) {
        File f = new File(dirPath);
        if (!f.exists()) {
            logger.error("\u6587\u4ef6\u5730\u5740: " + dirPath + "\u4e0d\u5b58\u5728\uff01");
        }
        File[] fa = f.listFiles();
        for (int i = 0; i < fa.length; ++i) {
            File fs = fa[i];
            if (fs.isDirectory()) {
                this.findScriptFilePath(fs.getPath(), filePathList);
                continue;
            }
            if (!fs.getName().endsWith(".py") && !fs.getName().endsWith(".sh") && !fs.getName().endsWith(".sql") && !fs.getName().endsWith(".hql") && !fs.getName().endsWith(".job") && !fs.getName().endsWith(".flow") && !fs.getName().endsWith(".properties")) continue;
            filePathList.add(fs.getPath().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readProperties(String propPath) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        Properties prop = new Properties();
        FileInputStream input = null;
        try {
            input = new FileInputStream(propPath);
            prop.load(input);
            if (!prop.isEmpty()) {
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    String key = String.valueOf(entry.getKey());
                    String value = String.valueOf(entry.getValue());
                    propMap.put(key, value);
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u8bfb\u53d6properties\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)ex);
            ex.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return propMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(String filePath) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = null;
        try {
            String fileStr;
            File file = new File(filePath);
            br = new BufferedReader(new FileReader(file));
            char[] data = new char[1024];
            boolean rn = false;
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            String string = fileStr = sb.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u811a\u672c\u6587\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    private Map<String, String> paramDecompose(String fileStr, ExecutableFlow ef) {
        HashMap<String, String> paramReplaceMap = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("\\$\\{([^\\}]+)\\}");
        Matcher matcher = pattern.matcher(fileStr);
        while (matcher.find()) {
            String fullStr = matcher.group();
            String valueStr = matcher.group(1);
            String timeParam = this.calculationDate(valueStr);
            if ("".equals(timeParam)) continue;
            paramReplaceMap.put(fullStr, timeParam);
        }
        return paramReplaceMap;
    }

    private String calculationDate(String fullVal) {
        fullVal = fullVal.replaceAll("\\s*", "");
        String timeStr = "";
        if (fullVal.matches(re)) {
            String[] str = fullVal.split("\\+|-");
            if (str.length == 1) {
                String key = str[0];
                int num = 0;
                if (this.defaultDate.containsKey(key) && Date.getDateMap().containsKey(key)) {
                    Date date = Date.getDateMap().get(key);
                    timeStr = DateUtils.calDate(date, num, this.defaultDate.get(key));
                }
            } else {
                String key = str[0];
                int num = Integer.parseInt(StringUtils.substringAfter((String)fullVal, (String)key));
                if (this.defaultDate.containsKey(key) && Date.getDateMap().containsKey(key)) {
                    Date date = Date.getDateMap().get(key);
                    timeStr = DateUtils.calDate(date, num, this.defaultDate.get(key));
                }
            }
        }
        return timeStr;
    }

    private void filterUserParam(Map<String, String> systemParam, ExecutableFlow ef) {
        HashMap<String, String> handleMap = new HashMap<String, String>();
        handleMap.putAll(systemParam);
        for (String userKey : this.getPropMap().keySet()) {
            for (String systemKey : handleMap.keySet()) {
                if (systemKey.contains(userKey) && !userKey.contains("_std") && !systemKey.contains(userKey + "_std")) {
                    systemParam.remove(systemKey);
                }
                if (!systemKey.contains(userKey) || !userKey.contains("_std")) continue;
                systemParam.remove(systemKey);
            }
        }
        for (String userKey : ef.getExecutionOptions().getFlowParameters().keySet()) {
            if (null == handleMap.get("${" + userKey + "}")) continue;
            systemParam.remove("${" + userKey + "}");
        }
        for (String userKey : ef.getUserProps().keySet()) {
            if (null == handleMap.get("${" + userKey + "}")) continue;
            systemParam.remove("${" + userKey + "}");
        }
    }

    public void run(String workingDir, ExecutableFlow ef) {
        List<String> propPathList = this.loadAllPropertiesFile(workingDir);
        for (String filePath : propPathList) {
            this.getPropMap().putAll(this.readProperties(filePath));
        }
        try {
            if (ef.getOtherOption().get("run_date") == null && this.getPropMap().get("run_date") != null && !this.getPropMap().get("run_date").isEmpty()) {
                ef.getOtherOption().put("run_date", this.getPropMap().get("run_date"));
            }
        }
        catch (RuntimeException e) {
            logger.error("set rundate failed {}", (Throwable)e);
        }
        List<String> scriptPathList = this.loadAllScriptFile(workingDir);
        boolean initDateIsSuccess = true;
        try {
            this.initDate(ef);
        }
        catch (RuntimeException re) {
            initDateIsSuccess = false;
            logger.error("parse run_date failed.", (Throwable)re);
        }
        for (String filePath : scriptPathList) {
            Map<String, String> scriptMap;
            String fileStr = this.readFile(filePath);
            if (initDateIsSuccess && (scriptMap = this.paramDecompose(fileStr, ef)) != null && scriptMap.size() != 0) {
                for (String timeStr : scriptMap.keySet()) {
                    fileStr = StringUtils.replace((String)fileStr, (String)timeStr, (String)scriptMap.get(timeStr));
                }
            }
            this.FileWrite(filePath, fileStr);
        }
    }

    public Map<String, String> getPropMap() {
        return this.propMap;
    }

    public static boolean dateFormatCheck(String date) {
        Pattern p = Pattern.compile(TIME_TEMPLATE);
        Matcher m = p.matcher(date);
        if (m.matches()) {
            return true;
        }
        logger.error(date + "\uff0c\u4e0d\u662f\u5408\u6cd5\u7684\u65e5\u671f\u683c\u5f0f\uff01");
        return false;
    }
}

