/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.i18nutils;

import com.webank.wedatasphere.schedulis.common.utils.GsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadJsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoadJsonUtils.class);
    public static volatile String languageType = "zh_CN";

    public static String getLanguageType() {
        return languageType;
    }

    public static void setLanguageType(String languageType) {
        LoadJsonUtils.languageType = languageType;
    }

    public static Map<String, String> transJson(String fileName, String dataNode) {
        Map<String, String> resultMap = new HashMap<String, String>();
        try {
            String jsonStr = LoadJsonUtils.readFromTextFile(fileName);
            resultMap = (Map)GsonUtils.json2Map(jsonStr).get(dataNode);
        }
        catch (Exception e) {
            logger.error("Json File trans Failed, caused by:{}", (Throwable)e);
        }
        return resultMap;
    }

    public static String readFromTextFile(String fileName) throws IOException {
        InputStream resourceAsStream = LoadJsonUtils.class.getResourceAsStream(fileName);
        InputStreamReader reader = new InputStreamReader(resourceAsStream);
        BufferedReader br = new BufferedReader(reader);
        StringBuilder builder = new StringBuilder();
        String line = br.readLine();
        while (line != null) {
            builder.append(line);
            line = br.readLine();
        }
        return builder.toString();
    }
}

