/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.executor;

import azkaban.db.DatabaseOperator;
import azkaban.db.SQLTransaction;
import azkaban.executor.ExecutorManagerException;
import com.webank.wedatasphere.schedulis.common.executor.UserVariable;
import com.webank.wedatasphere.schedulis.common.system.entity.WtssUser;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserVariableDao {
    private static final Logger logger = LoggerFactory.getLogger(UserVariableDao.class);
    private final DatabaseOperator dbOperator;
    private static final String INSERT_USER_VARIABLE = "INSERT INTO user_variable (`key`, `description`, `value`, `owner`, `create_time`, `update_time`) VALUES (?, ?, ?, ?, ?, ?);";
    private static final String INSERT_USER_VARIABLE_USER = "INSERT INTO user_variable_user (`v_id`, `username`) VALUES (?, ?);";
    private static final String DELETE_USER_VARIABLE = "DELETE FROM user_variable WHERE id = ? ;";
    private static final String DELETE_USER_VARIABLE_USER = "DELETE FROM user_variable_user WHERE v_id = ? ;";
    private static final String UPDATE_USER_VARIABLE = "UPDATE user_variable SET `key` = ?, description = ?, `value` = ?, `owner` = ?, update_time = ? WHERE id = ? ;";
    private static final String FETCH_ALL_USER_VARIABLE = "SELECT v.`id`, v.`key`, v.`description`,v.`value`,v.`owner`,v.`create_time`,v.`update_time`,u.`username` FROM user_variable v LEFT JOIN user_variable_user u ON v.id = u.v_id where v.`owner` = ? OR u.`username` = ? ;";
    private static final String FETCH_USER_VARIABLE_BY_ID = "SELECT v.`id`, v.`key`, v.`description`,v.`value`, v.`owner`,v.`create_time`, v.`update_time`, u.`username` FROM user_variable v LEFT JOIN user_variable_user u ON v.id = u.v_id where v.id = ? ;";
    private static final String WTSS_USER_IS_EXIST = "select count(1) from wtss_user where username = ?";
    private static final String LOAD_WTSS_USER = "SELECT user_id, username, full_name FROM wtss_user ";
    private static final String COUNT_WTSS_USER = "SELECT count(1) FROM wtss_user";

    @Inject
    public UserVariableDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public Integer getWtssUserTotal() throws ExecutorManagerException {
        try {
            return (Integer)this.dbOperator.query(COUNT_WTSS_USER, (ResultSetHandler)new FindWtssUserHandler());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Failed to statistics the number of user in wtss_user", e);
        }
    }

    public List<WtssUser> findAllWtssUserPageList(String searchName, int pageNum, int pageSize) throws ExecutorManagerException {
        List wtssUserList = null;
        String querySQL = LOAD_WTSS_USER;
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            if (searchName != null && !searchName.isEmpty()) {
                querySQL = querySQL + " WHERE username LIKE ? ";
                params.add('%' + searchName + '%');
            }
            if (pageNum > -1 && pageSize > 0) {
                querySQL = querySQL + " Limit ?, ?";
                params.add(pageNum);
                params.add(pageSize);
            }
            wtssUserList = (List)this.dbOperator.query(querySQL, (ResultSetHandler)new FetchWtssUserHandler(), params.toArray());
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Failed to page find user in wtss_user.", e);
        }
        return wtssUserList;
    }

    public Integer findWtssUserByName(String name) throws ExecutorManagerException {
        try {
            return (Integer)this.dbOperator.query(WTSS_USER_IS_EXIST, (ResultSetHandler)new FindWtssUserHandler(), new Object[]{name});
        }
        catch (Exception e) {
            throw new ExecutorManagerException("findWtssUserByName failed.", e);
        }
    }

    public void addUserVariable(UserVariable userVariable) throws ExecutorManagerException {
        try {
            SQLTransaction insertAndGetLastID = transOperator -> {
                Connection conn = transOperator.getConnection();
                long id = 0L;
                try {
                    transOperator.update(INSERT_USER_VARIABLE, new Object[]{userVariable.getKey(), userVariable.getDescription(), userVariable.getValue(), userVariable.getOwner(), System.currentTimeMillis(), System.currentTimeMillis()});
                    id = transOperator.getLastInsertId();
                    for (WtssUser user : userVariable.getUsers()) {
                        transOperator.update(INSERT_USER_VARIABLE_USER, new Object[]{(int)id, user.getUserId()});
                    }
                    transOperator.getConnection().commit();
                }
                catch (SQLException sql) {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw sql;
                }
                return id;
            };
            this.dbOperator.transaction(insertAndGetLastID);
        }
        catch (Exception e) {
            throw new ExecutorManagerException("addUserVariable failed.", e);
        }
    }

    public int deleteUserVariable(UserVariable variable) throws ExecutorManagerException {
        try {
            SQLTransaction delete = transOperator -> {
                Connection conn = transOperator.getConnection();
                Integer ret = 0;
                try {
                    ret = transOperator.update(DELETE_USER_VARIABLE, new Object[]{variable.getId()});
                    if (ret == 1) {
                        transOperator.update(DELETE_USER_VARIABLE_USER, new Object[]{variable.getId()});
                    }
                    transOperator.getConnection().commit();
                }
                catch (SQLException sql) {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw sql;
                }
                return ret;
            };
            return (Integer)this.dbOperator.transaction(delete);
        }
        catch (Exception e) {
            throw new ExecutorManagerException("deleteUserVariable failed.", e);
        }
    }

    public int updateUserVariable(UserVariable userVariable) throws ExecutorManagerException {
        try {
            SQLTransaction update = transOperator -> {
                Connection conn = transOperator.getConnection();
                Integer ret = 0;
                try {
                    ret = transOperator.update(UPDATE_USER_VARIABLE, new Object[]{userVariable.getKey(), userVariable.getDescription(), userVariable.getValue(), userVariable.getOwner(), System.currentTimeMillis(), userVariable.getId()});
                    if (ret == 1) {
                        transOperator.update(DELETE_USER_VARIABLE_USER, new Object[]{userVariable.getId()});
                        for (WtssUser user : userVariable.getUsers()) {
                            transOperator.update(INSERT_USER_VARIABLE_USER, new Object[]{userVariable.getId(), user.getUserId()});
                        }
                    }
                    transOperator.getConnection().commit();
                }
                catch (SQLException sql) {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw sql;
                }
                return ret;
            };
            return (Integer)this.dbOperator.transaction(update);
        }
        catch (Exception e) {
            throw new ExecutorManagerException("update userVariable failed.", e);
        }
    }

    public List<UserVariable> fetchAllUserVariable(UserVariable userVariable) throws ExecutorManagerException {
        List userVariables = null;
        try {
            userVariables = (List)this.dbOperator.query(FETCH_ALL_USER_VARIABLE, (ResultSetHandler)new FetchUserVariableByIdHandler(), new Object[]{userVariable.getOwner(), userVariable.getOwner()});
        }
        catch (Exception e) {
            throw new ExecutorManagerException("fetch ALL UserVariable failed", e);
        }
        return userVariables;
    }

    public List<UserVariable> fetchAllUserVariableByOwnerDepartment(Integer departmentId) throws ExecutorManagerException {
        List userVariableList = null;
        try {
            String querySql = "SELECT * FROM user_variable WHERE owner in(SELECT urn FROM cfg_webank_all_users where department_id=?)";
            userVariableList = (List)this.dbOperator.query(querySql, (ResultSetHandler)new UserVariableHandler(), new Object[]{departmentId});
        }
        catch (SQLException e) {
            throw new ExecutorManagerException("Failed to find userVariableList, caused by:", e);
        }
        return userVariableList;
    }

    public UserVariable getUserVariableById(Integer id) throws ExecutorManagerException {
        List userVariables = null;
        UserVariable userVariable = null;
        try {
            userVariables = (List)this.dbOperator.query(FETCH_USER_VARIABLE_BY_ID, (ResultSetHandler)new FetchUserVariableByIdHandler(), new Object[]{id});
            if (userVariables.size() != 0) {
                userVariable = (UserVariable)userVariables.get(0);
            }
        }
        catch (Exception e) {
            throw new ExecutorManagerException("fetch ALL UserVariable failed", e);
        }
        return userVariable;
    }

    public Map<String, String> getUserVariableByName(String userName) throws ExecutorManagerException {
        List userVariables = null;
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            userVariables = (List)this.dbOperator.query(FETCH_ALL_USER_VARIABLE, (ResultSetHandler)new FetchUserVariableHandler(), new Object[]{userName, userName});
            if (userVariables.size() != 0) {
                for (UserVariable userVariable : userVariables) {
                    variables.put(userVariable.getKey(), userVariable.getValue());
                }
            }
        }
        catch (Exception e) {
            throw new ExecutorManagerException("fetch ALL UserVariable failed", e);
        }
        return variables;
    }

    public static class FetchUserVariableHandler
    implements ResultSetHandler<List<UserVariable>> {
        public List<UserVariable> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<UserVariable> userVariables = new ArrayList<UserVariable>();
            do {
                UserVariable userVariable = new UserVariable();
                userVariable.setId(rs.getInt(1));
                userVariable.setKey(rs.getString(2));
                userVariable.setDescription(rs.getString(3));
                userVariable.setValue(rs.getString(4));
                userVariable.setOwner(rs.getString(5));
                userVariable.setCreateTime(rs.getLong(6));
                userVariable.setUpdateTime(rs.getLong(7));
                userVariables.add(userVariable);
            } while (rs.next());
            return userVariables;
        }
    }

    public static class UserVariableHandler
    implements ResultSetHandler<List<UserVariable>> {
        private static final String FETCH_USER_VARIABLE_BY_OWNER_DEPARTMENT_ID = "SELECT * FROM user_variable WHERE owner in(SELECT urn FROM cfg_webank_all_users where department_id=?)";

        public List<UserVariable> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<UserVariable> userVariables = new ArrayList<UserVariable>();
            do {
                UserVariable userVariable = new UserVariable();
                userVariable.setId(rs.getInt(1));
                userVariable.setKey(rs.getString(2));
                userVariable.setDescription(rs.getString(3));
                userVariable.setValue(rs.getString(4));
                userVariable.setOwner(rs.getString(5));
                userVariable.setCreateTime(rs.getLong(6));
                userVariable.setUpdateTime(rs.getLong(7));
                userVariables.add(userVariable);
            } while (rs.next());
            return userVariables;
        }
    }

    public static class FetchUserVariableByIdHandler
    implements ResultSetHandler<List<UserVariable>> {
        public List<UserVariable> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<UserVariable> userVariables = new ArrayList<UserVariable>();
            HashMap<Integer, UserVariable> tmp = new HashMap<Integer, UserVariable>();
            do {
                UserVariable userVariable = new UserVariable();
                int id = rs.getInt(1);
                userVariable.setId(id);
                userVariable.setKey(rs.getString(2));
                userVariable.setDescription(rs.getString(3));
                userVariable.setValue(rs.getString(4));
                userVariable.setOwner(rs.getString(5));
                userVariable.setCreateTime(rs.getLong(6));
                userVariable.setUpdateTime(rs.getLong(7));
                String userName = rs.getString(8);
                WtssUser user = new WtssUser();
                user.setUserId(userName);
                userVariable.getUsers().add(user);
                if (tmp.get(id) != null) {
                    ((UserVariable)tmp.get(id)).getUsers().add(user);
                    continue;
                }
                tmp.put(id, userVariable);
            } while (rs.next());
            userVariables.addAll(tmp.values());
            return userVariables;
        }
    }

    public static class FindWtssUserHandler
    implements ResultSetHandler<Integer> {
        public Integer handle(ResultSet rs) throws SQLException {
            int count = 0;
            if (!rs.next()) {
                return count;
            }
            do {
                count = rs.getInt(1);
            } while (rs.next());
            return count;
        }
    }

    public static class FetchWtssUserHandler
    implements ResultSetHandler<List<WtssUser>> {
        public List<WtssUser> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<WtssUser> wtssUserList = new ArrayList<WtssUser>();
            do {
                WtssUser wtssUser = new WtssUser();
                String userId = rs.getString(1);
                String username = rs.getString(2);
                String fullName = rs.getString(3);
                wtssUser.setUserId(userId);
                wtssUser.setUsername(username);
                wtssUser.setFullName(fullName);
                wtssUserList.add(wtssUser);
            } while (rs.next());
            return wtssUserList;
        }
    }
}

