/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.executor;

import azkaban.db.DatabaseOperator;
import azkaban.db.EncodingType;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutionReference;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.utils.GZIPUtils;
import azkaban.utils.Pair;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionQueueDao {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionQueueDao.class);
    private final DatabaseOperator dbOperator;

    @Inject
    public ExecutionQueueDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public synchronized void insertExecutableQueue(ExecutableFlow flow) throws ExecutorManagerException {
    }

    public synchronized void uploadExecutableQueue(ExecutableFlow flow) {
    }

    public List<ExecutableFlow> fetchExecutableQueue() {
        return null;
    }

    public synchronized void deleteExecutableQueue(ExecutableFlow flow) {
    }

    private static class FetchExecutableQueueHandler
    implements ResultSetHandler<List<Pair<ExecutionReference, ExecutableFlow>>> {
        private static final String FETCH_QUEUED_EXECUTABLE_FLOW = "SELECT exec_id,executor_id,status,error_count,update_time,flow_priority FROM execution_queue where executor_id is NULL AND status = " + Status.READY.getNumVal();

        private FetchExecutableQueueHandler() {
        }

        public List<Pair<ExecutionReference, ExecutableFlow>> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Pair<ExecutionReference, ExecutableFlow>> execFlows = new ArrayList<Pair<ExecutionReference, ExecutableFlow>>();
            do {
                int id = rs.getInt(1);
                int encodingType = rs.getInt(2);
                byte[] data = rs.getBytes(3);
                if (data == null) {
                    logger.error("Found a flow with empty data blob exec_id: " + id);
                    continue;
                }
                EncodingType encType = EncodingType.fromInteger((int)encodingType);
                try {
                    ExecutableFlow exFlow = ExecutableFlow.createExecutableFlowFromObject(GZIPUtils.transformBytesToObject(data, encType));
                    ExecutionReference ref = new ExecutionReference(id);
                    execFlows.add(new Pair<ExecutionReference, ExecutableFlow>(ref, exFlow));
                }
                catch (IOException e) {
                    throw new SQLException("Error retrieving flow data " + id, e);
                }
            } while (rs.next());
            return execFlows;
        }
    }
}

