/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.executor;

import azkaban.db.DatabaseOperator;
import azkaban.db.SQLTransaction;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorManagerException;
import com.webank.wedatasphere.schedulis.common.executor.DepartmentGroup;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DepartmentGroupDao {
    private static final Logger logger = LoggerFactory.getLogger(DepartmentGroupDao.class);
    private final DatabaseOperator dbOperator;
    private static final String FETCH_EXECUTORS_IDS_BY_SUBMIT_USER = "SELECT e.executor_id FROM  department_group_executors e LEFT JOIN department_group g ON e.`group_id` = g.`id` LEFT JOIN cfg_webank_organization o ON g.`id` = o.`group_id` LEFT JOIN wtss_user u ON u.`department_id` = o.`dp_id` WHERE u.`username` = ? ;";
    private static final String INSERT_DEPARTMENT_GROUP = "INSERT INTO department_group (`id`, `name`, `description`, `create_time`, `update_time`) VALUES (?, ?, ?, ?, ?);";
    private static final String QUERY_GROUPNAME = "SELECT * FROM department_group WHERE `name` = ? ;";
    private static final String QUERY_EXECUTOR = "SELECT * FROM department_group_executors WHERE executor_id = ? ;";
    private static final String INSERT_DEPARTMENT_GROUP_EXECUTORS = "INSERT INTO department_group_executors (`group_id`, `executor_id`) VALUES (?, ?);";
    private static final String UPDATE_DEPARTMENT_GROUP = "UPDATE department_group SET `id` = ?, `name` = ?, description = ?, update_time = ? WHERE id = ? ;";
    private static final String DELETE_DEPARTMENT_GROUP_EXECUTORS = "DELETE FROM department_group_executors WHERE group_id = ? ;";
    private static final String DELETE_DEPARTMENT_GROUP = "DELETE FROM department_group WHERE id = ? ;";
    private static final String FETCH_ALL_DEPARTMENT_GROUP = "SELECT g.`id`, g.`name`, g.`description`, g.`create_time`, g.`update_time`,e.`executor_id` ,exc.`host` FROM department_group g LEFT JOIN department_group_executors e ON g.id = e.`group_id` LEFT JOIN executors exc ON exc.`id` = e.`executor_id`;";
    private static final String FETCH_DEPARTMENT_GROUP_BY_ID = "SELECT g.`id`, g.`name`, g.`description`, g.`create_time`, g.`update_time`,e.`executor_id` ,exc.`host` FROM department_group g LEFT JOIN department_group_executors e ON g.id = e.`group_id` LEFT JOIN executors exc ON exc.`id` = e.`executor_id` WHERE g.`id` = ? ;";
    private static final String GROUP_ID_IS_EXIST = "SELECT count(1) FROM cfg_webank_organization WHERE group_id = ? ;";

    @Inject
    public DepartmentGroupDao(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public int updateDepartmentGroup(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        try {
            SQLTransaction update = transOperator -> {
                Connection conn = transOperator.getConnection();
                Integer ret = 0;
                try {
                    ret = transOperator.update(UPDATE_DEPARTMENT_GROUP, new Object[]{departmentGroup.getId(), departmentGroup.getName(), departmentGroup.getDescription(), System.currentTimeMillis(), departmentGroup.getOldId()});
                    if (ret == 1) {
                        transOperator.update(DELETE_DEPARTMENT_GROUP_EXECUTORS, new Object[]{departmentGroup.getOldId()});
                        for (int executorId : departmentGroup.getExecutorIds()) {
                            transOperator.update(INSERT_DEPARTMENT_GROUP_EXECUTORS, new Object[]{departmentGroup.getId(), executorId});
                        }
                    }
                    transOperator.getConnection().commit();
                }
                catch (SQLException sql) {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw sql;
                }
                return ret;
            };
            return (Integer)this.dbOperator.transaction(update);
        }
        catch (Exception e) {
            throw new ExecutorManagerException("update Department Group failed.", e);
        }
    }

    public int groupIdIsExist(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        try {
            return (Integer)this.dbOperator.query(GROUP_ID_IS_EXIST, (ResultSetHandler)new CountGroupIdHandle(), new Object[]{departmentGroup.getId()});
        }
        catch (Exception e) {
            throw new ExecutorManagerException("can not found group id in cfg_webank_organization, failed.", e);
        }
    }

    public int deleteDepartmentGroup(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        try {
            SQLTransaction delete = transOperator -> {
                Connection conn = transOperator.getConnection();
                Integer ret = 0;
                try {
                    ret = transOperator.update(DELETE_DEPARTMENT_GROUP, new Object[]{departmentGroup.getId()});
                    if (ret == 1) {
                        transOperator.update(DELETE_DEPARTMENT_GROUP_EXECUTORS, new Object[]{departmentGroup.getId()});
                    }
                    transOperator.getConnection().commit();
                }
                catch (SQLException sql) {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw sql;
                }
                return ret;
            };
            return (Integer)this.dbOperator.transaction(delete);
        }
        catch (Exception e) {
            throw new ExecutorManagerException("add Department Group failed.", e);
        }
    }

    public void addDepartmentGroup(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        try {
            SQLTransaction insert = transOperator -> {
                Connection conn = transOperator.getConnection();
                try {
                    transOperator.update(INSERT_DEPARTMENT_GROUP, new Object[]{departmentGroup.getId(), departmentGroup.getName(), departmentGroup.getDescription(), System.currentTimeMillis(), System.currentTimeMillis()});
                    for (int executorId : departmentGroup.getExecutorIds()) {
                        transOperator.update(INSERT_DEPARTMENT_GROUP_EXECUTORS, new Object[]{departmentGroup.getId(), executorId});
                    }
                    transOperator.getConnection().commit();
                }
                catch (SQLException sql) {
                    if (conn != null) {
                        conn.rollback();
                    }
                    throw sql;
                }
                return 1;
            };
            this.dbOperator.transaction(insert);
        }
        catch (Exception e) {
            throw new ExecutorManagerException("add Department Group failed.", e);
        }
    }

    public boolean checkGroupNameIsExist(DepartmentGroup departmentGroup) throws ExecutorManagerException {
        boolean flag = false;
        try {
            flag = (Boolean)this.dbOperator.query(QUERY_GROUPNAME, (ResultSetHandler)new CheckExistHandler(), new Object[]{departmentGroup.getName()});
        }
        catch (Exception e) {
            throw new ExecutorManagerException("checkGroupNameIsExist failed: ", e);
        }
        return flag;
    }

    public boolean checkExecutorIsUsed(int executorId) throws ExecutorManagerException {
        boolean flag = false;
        try {
            flag = (Boolean)this.dbOperator.query(QUERY_EXECUTOR, (ResultSetHandler)new CheckExistHandler(), new Object[]{executorId});
        }
        catch (Exception e) {
            throw new ExecutorManagerException("checkExecutorIsUsed failed: ", e);
        }
        return flag;
    }

    public List<DepartmentGroup> fetchAllDepartmentGroup() throws ExecutorManagerException {
        try {
            return (List)this.dbOperator.query(FETCH_ALL_DEPARTMENT_GROUP, (ResultSetHandler)new FetchDepartmentGroupHandler());
        }
        catch (Exception e) {
            throw new ExecutorManagerException("fetch ALL Department Group failed", e);
        }
    }

    public DepartmentGroup fetchDepartmentGroupById(Integer id) throws ExecutorManagerException {
        DepartmentGroup departmentGroup = null;
        try {
            List departmentGroups = (List)this.dbOperator.query(FETCH_DEPARTMENT_GROUP_BY_ID, (ResultSetHandler)new FetchDepartmentGroupHandler(), new Object[]{id});
            if (departmentGroups.size() != 0) {
                departmentGroup = (DepartmentGroup)departmentGroups.get(0);
            }
        }
        catch (Exception e) {
            throw new ExecutorManagerException("fetch ALL Department Group failed", e);
        }
        return departmentGroup;
    }

    public List<Integer> fetchExecutorsIdSBySubmitUser(String submitUser) throws ExecutorManagerException {
        try {
            return (List)this.dbOperator.query(FETCH_EXECUTORS_IDS_BY_SUBMIT_USER, (ResultSetHandler)new FetchExecutorIdsHandler(), new Object[]{submitUser});
        }
        catch (Exception e) {
            throw new ExecutorManagerException("fetch ExecutorsIdS BySubmitUser failed", e);
        }
    }

    public static class FetchExecutorIdsHandler
    implements ResultSetHandler<List<Integer>> {
        public List<Integer> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> executorIds = new ArrayList<Integer>();
            do {
                int executorId = rs.getInt(1);
                executorIds.add(executorId);
            } while (rs.next());
            return executorIds;
        }
    }

    public static class FetchDepartmentGroupHandler
    implements ResultSetHandler<List<DepartmentGroup>> {
        public List<DepartmentGroup> handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return Collections.emptyList();
            }
            HashMap<Integer, DepartmentGroup> departmentGroupMap = new HashMap<Integer, DepartmentGroup>();
            do {
                int id = rs.getInt(1);
                int executorId = rs.getInt(6);
                String executorHost = rs.getString(7);
                if (departmentGroupMap.get(id) != null) {
                    ((DepartmentGroup)departmentGroupMap.get(id)).getExecutorIds().add(executorId);
                    Executor executor = new Executor(id, executorHost, 12321, true);
                    ((DepartmentGroup)departmentGroupMap.get(id)).getExecutors().add(executor);
                    continue;
                }
                DepartmentGroup dp = new DepartmentGroup();
                String name = rs.getString(2);
                String description = rs.getString(3);
                Long createTime = rs.getLong(4);
                Long updateTime = rs.getLong(5);
                dp.setId(id);
                dp.setName(name);
                dp.setDescription(description);
                dp.setCreateTime(createTime);
                dp.setUpdateTime(updateTime);
                dp.getExecutorIds().add(executorId);
                Executor executor = new Executor(id, executorHost, 12321, true);
                dp.getExecutors().add(executor);
                departmentGroupMap.put(id, dp);
            } while (rs.next());
            ArrayList<DepartmentGroup> departmentGroups = new ArrayList<DepartmentGroup>(departmentGroupMap.values());
            return departmentGroups;
        }
    }

    public static class CheckExistHandler
    implements ResultSetHandler<Boolean> {
        public Boolean handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                return false;
            }
            return true;
        }
    }

    public static class CountGroupIdHandle
    implements ResultSetHandler<Integer> {
        public Integer handle(ResultSet rs) throws SQLException {
            int count = 0;
            if (!rs.next()) {
                return count;
            }
            do {
                count = rs.getInt(1);
            } while (rs.next());
            return count;
        }
    }
}

