/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.distributelock;

import azkaban.db.DatabaseOperator;
import com.webank.wedatasphere.schedulis.common.distributelock.AbstractDistributeLock;
import com.webank.wedatasphere.schedulis.common.distributelock.DistributeLock;
import com.webank.wedatasphere.schedulis.common.utils.HttpUtils;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DBTableDistributeLock
extends AbstractDistributeLock {
    private static final Logger log = LoggerFactory.getLogger(DBTableDistributeLock.class);

    @Inject
    public DBTableDistributeLock(DatabaseOperator dbOperator) {
        super(dbOperator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean lock(String lock_resource, long locktimeout, long gettimeout) {
        boolean lockResult = false;
        try {
            String current_request_Id = this.getRequestId();
            long getLockEndTime = System.currentTimeMillis() + gettimeout;
            while (System.currentTimeMillis() < getLockEndTime) {
                log.debug("start to get exist lock, lock_resource is {} " + lock_resource);
                DistributeLock distributeLock = this.get(lock_resource);
                if (Objects.isNull(distributeLock)) {
                    distributeLock = new DistributeLock(current_request_Id, lock_resource, 1L, 1, HttpUtils.getLinuxLocalIp(log), System.currentTimeMillis() + locktimeout, System.currentTimeMillis(), System.currentTimeMillis());
                    log.debug("there is no exist lock ,the system will request a new lock {} new distributeLock info: " + distributeLock.toString());
                    this.insert(distributeLock);
                    boolean bl = lockResult = true;
                    return bl;
                }
                log.debug("The lock already exists {} exist distributeLock info: " + distributeLock.toString());
                String lockRequest_id = distributeLock.getRequest_id();
                if ("".equals(lockRequest_id)) {
                    distributeLock.setRequest_id(current_request_Id);
                    distributeLock.setLock_count(1L);
                    distributeLock.setTimeout(System.currentTimeMillis() + locktimeout);
                    log.debug("The lock is not owner by anyone , assign it to the current thread {} distributeLock info: " + distributeLock.toString());
                    if (this.updateLock(distributeLock) != 1) continue;
                    boolean bl = lockResult = true;
                    return bl;
                }
                if (current_request_Id.equals(lockRequest_id)) {
                    distributeLock.setTimeout(System.currentTimeMillis() + locktimeout);
                    distributeLock.setLock_count(distributeLock.getLock_count() + 1L);
                    log.debug("The lock lockRequest_id is equal to current thread request_Id , and then the lock would reaccess {} distributeLock info: " + distributeLock.toString());
                    if (this.updateLock(distributeLock) != 1) continue;
                    boolean bl = lockResult = true;
                    return bl;
                }
                log.debug("The lock_resource is locked by other thread request_Id, {} distributeLock info: " + distributeLock.toString());
                if (System.currentTimeMillis() > distributeLock.getTimeout()) {
                    distributeLock.setRequest_id(current_request_Id);
                    distributeLock.setLock_count(1L);
                    distributeLock.setTimeout(System.currentTimeMillis() + locktimeout);
                    if (this.updateLock(distributeLock) != 1) continue;
                    boolean bl = lockResult = true;
                    return bl;
                }
                boolean bl = lockResult = false;
                return bl;
            }
            log.warn("get lock timeout");
        }
        catch (Exception e) {
            log.error("get distribute lock failed", (Throwable)e);
        }
        finally {
            lockResult = false;
        }
        return lockResult;
    }

    @Override
    public synchronized void unlock(String lock_resource) {
        String current_request_Id = this.getRequestId();
        DistributeLock distributeLock = this.get(lock_resource);
        if (Objects.nonNull(distributeLock) && current_request_Id.equals(distributeLock.getRequest_id()) && distributeLock.getLock_count() > 0L) {
            log.debug("The lock will be deleted {} distributeLock info: " + distributeLock.toString());
            this.delete(distributeLock);
        }
    }

    @Override
    public synchronized int resetLock(DistributeLock distributeLock) {
        distributeLock.setRequest_id("");
        distributeLock.setLock_count(0L);
        distributeLock.setTimeout(0L);
        return this.updateLock(distributeLock);
    }
}

