/*
 * Decompiled with CFR 0.152.
 */
package com.webank.wedatasphere.schedulis.common.distributelock;

import azkaban.db.DatabaseOperator;
import com.webank.wedatasphere.schedulis.common.distributelock.DistributeLock;
import com.webank.wedatasphere.schedulis.common.distributelock.DistributeLockAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.dbutils.ResultSetHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDistributeLock
implements DistributeLockAdapter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDistributeLock.class);
    DatabaseOperator dbOperator;
    ThreadLocal<String> requestIdTL = new ThreadLocal();

    @Inject
    public AbstractDistributeLock(DatabaseOperator dbOperator) {
        this.dbOperator = dbOperator;
    }

    public String getRequestId() {
        String requestId = this.requestIdTL.get();
        if (requestId == null || "".equals(requestId)) {
            requestId = Thread.currentThread().getId() + ":" + UUID.randomUUID().toString();
            this.requestIdTL.set(requestId);
        }
        log.debug("current_request_Id is {} ,current_request_ThreadName is {} " + requestId + "," + Thread.currentThread().getName());
        return requestId;
    }

    public DistributeLock get(String lock_resource) {
        DistributeLock distributeLock = null;
        try {
            distributeLock = (DistributeLock)this.dbOperator.query(FetchDistributeLockHandler.FETCH_APPOINT_DISTRIBUTELOCK, (ResultSetHandler)new FetchDistributeLockHandler(), new Object[]{lock_resource});
        }
        catch (Exception e) {
            log.error("get exists lock failed {} lock_resource:" + lock_resource, (Throwable)e);
        }
        return distributeLock;
    }

    public int insert(DistributeLock distributeLock) {
        String querySQL = "insert into distribute_lock (request_id,lock_resource,lock_count,version,ip,timeout,create_time,update_time)  values (?,?,?,?,?,?,?,?)";
        int result = 0;
        try {
            result = this.dbOperator.update(querySQL, new Object[]{distributeLock.getRequest_id(), distributeLock.getLock_resource(), distributeLock.getLock_count(), distributeLock.getVersion(), distributeLock.getIp(), distributeLock.getTimeout(), distributeLock.getCreate_time(), distributeLock.getUpdate_time()});
        }
        catch (SQLException e) {
            log.error("acquire a lock failed {} distributeLock info:" + distributeLock.toString(), (Throwable)e);
        }
        return result;
    }

    public int delete(DistributeLock distributeLock) {
        String querySQL = "delete from distribute_lock WHERE lock_resource = ?";
        int result = 0;
        try {
            result = this.dbOperator.update(querySQL, new Object[]{distributeLock.getLock_resource()});
        }
        catch (SQLException e) {
            log.error("delete lock failed {} distributeLock info:" + distributeLock.toString(), (Throwable)e);
        }
        return result;
    }

    @Override
    public int updateLock(DistributeLock distributeLock) {
        String querySQL = "update distribute_lock dl set request_id=?,lock_count=?,version=version+1,ip=?,timeout=?,update_time=? WHERE lock_resource =? and version =?";
        int result = 0;
        try {
            result = this.dbOperator.update(querySQL, new Object[]{distributeLock.getRequest_id(), distributeLock.getLock_count(), distributeLock.getIp(), distributeLock.getTimeout(), distributeLock.getUpdate_time(), distributeLock.getLock_resource(), distributeLock.getVersion()});
        }
        catch (SQLException e) {
            log.error("update lock failed {} distributeLock info:" + distributeLock.toString(), (Throwable)e);
        }
        return result;
    }

    @Override
    public boolean lock(String lock_key, long locktimeout, long gettimeout) {
        return false;
    }

    @Override
    public void unlock(String lock_key) {
    }

    @Override
    public int resetLock(DistributeLock distributeLock) {
        return 0;
    }

    public static class FetchDistributeLockHandler
    implements ResultSetHandler<DistributeLock> {
        static String FETCH_APPOINT_DISTRIBUTELOCK = "select * from distribute_lock dl WHERE dl.lock_resource =?";

        public DistributeLock handle(ResultSet rs) throws SQLException {
            if (!rs.next()) {
                log.info("there is no exist lock");
                return null;
            }
            int id = rs.getInt(1);
            String request_id = rs.getString(2);
            String lock_resource = rs.getString(3);
            long lock_count = rs.getInt(4);
            int version = rs.getInt(5);
            String ip = rs.getString(6);
            long timeout = rs.getLong(7);
            long create_time = rs.getLong(8);
            long update_time = rs.getLong(9);
            DistributeLock distributeLock = new DistributeLock(id, request_id, lock_resource, lock_count, version, ip, timeout, create_time, update_time);
            return distributeLock;
        }
    }
}

