/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.ThreadPoolExecutingListener;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingThreadPool
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(TrackingThreadPool.class);
    private final Map<Runnable, Boolean> inProgress = new ConcurrentHashMap<Runnable, Boolean>();
    private final ThreadLocal<Long> startTime = new ThreadLocal();
    private ThreadPoolExecutingListener executingListener = new NoOpThreadPoolExecutingListener();
    private long totalTime;
    private int totalTasks;

    public TrackingThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadPoolExecutingListener listener) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        if (listener != null) {
            this.executingListener = listener;
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        try {
            this.executingListener.beforeExecute(r);
        }
        catch (Throwable e) {
            logger.warn("Listener threw exception", e);
        }
        super.beforeExecute(t, r);
        this.inProgress.put(r, Boolean.TRUE);
        this.startTime.set(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        long time = System.currentTimeMillis() - this.startTime.get();
        TrackingThreadPool trackingThreadPool = this;
        synchronized (trackingThreadPool) {
            this.totalTime += time;
            ++this.totalTasks;
        }
        this.inProgress.remove(r);
        super.afterExecute(r, t);
        try {
            this.executingListener.afterExecute(r);
        }
        catch (Throwable e) {
            logger.warn("Listener threw exception", e);
        }
    }

    public Set<Runnable> getInProgressTasks() {
        return Collections.unmodifiableSet(this.inProgress.keySet());
    }

    public synchronized int getTotalTasks() {
        return this.totalTasks;
    }

    public synchronized double getAverageTaskTime() {
        return this.totalTasks == 0 ? 0.0 : (double)(this.totalTime / (long)this.totalTasks);
    }

    private static class NoOpThreadPoolExecutingListener
    implements ThreadPoolExecutingListener {
        private NoOpThreadPoolExecutingListener() {
        }

        @Override
        public void beforeExecute(Runnable r) {
        }

        @Override
        public void afterExecute(Runnable r) {
        }
    }
}

