/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.Pair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestfulApiClient<T> {
    protected static Logger logger = LoggerFactory.getLogger(RestfulApiClient.class);

    public static URI buildUri(String host, int port, String path, boolean isHttp, Pair<String, String> ... params) throws IOException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme(isHttp ? "http" : "https").setHost(host).setPort(port);
        if (null != path && path.length() > 0) {
            builder.setPath(path);
        }
        if (params != null) {
            for (Pair<String, String> pair : params) {
                builder.setParameter(pair.getFirst(), pair.getSecond());
            }
        }
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static HttpEntityEnclosingRequestBase completeRequest(HttpEntityEnclosingRequestBase request, List<Pair<String, String>> params) throws UnsupportedEncodingException {
        if (request != null && null != params && !params.isEmpty()) {
            List formParams = params.stream().map(pair -> new BasicNameValuePair((String)pair.getFirst(), (String)pair.getSecond())).collect(Collectors.toList());
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, "UTF-8");
            request.setEntity((HttpEntity)entity);
        }
        return request;
    }

    protected abstract T parseResponse(HttpResponse var1) throws IOException;

    public T httpPost(URI uri, List<Pair<String, String>> params) throws IOException {
        if (null == uri) {
            logger.error(" unable to perform httpPost as the passed uri is null.");
            return null;
        }
        HttpPost post = new HttpPost(uri);
        return this.sendAndReturn((HttpUriRequest)RestfulApiClient.completeRequest((HttpEntityEnclosingRequestBase)post, params));
    }

    protected T sendAndReturn(HttpUriRequest request) throws IOException {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            T t = this.parseResponse((HttpResponse)client.execute(request));
            return t;
        }
    }
}

