/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsMemoryUtil {
    private static final Logger logger = LoggerFactory.getLogger(OsMemoryUtil.class);
    private static final String MEM_INFO_FILE = "/proc/meminfo";
    private static final ImmutableSet<String> MEM_KEYS = ImmutableSet.of((Object)"MemFree", (Object)"Buffers", (Object)"Cached", (Object)"SwapFree");

    OsMemoryUtil() {
    }

    long getOsTotalFreeMemorySize() {
        List<String> lines;
        if (!Files.isRegularFile(Paths.get(MEM_INFO_FILE, new String[0]), new LinkOption[0])) {
            return 0L;
        }
        try {
            lines = Files.readAllLines(Paths.get(MEM_INFO_FILE, new String[0]), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String errMsg = "Failed to open mem info file: /proc/meminfo";
            logger.error("Failed to open mem info file: /proc/meminfo", (Throwable)e);
            return 0L;
        }
        return this.getOsTotalFreeMemorySizeFromStrings(lines);
    }

    long getOsTotalFreeMemorySizeFromStrings(List<String> lines) {
        long totalFree = 0L;
        int count = 0;
        for (String line : lines) {
            for (String keyName : MEM_KEYS) {
                if (!line.startsWith(keyName)) continue;
                ++count;
                long size = this.parseMemoryLine(line);
                if (size == 0L) {
                    return 0L;
                }
                totalFree += size;
            }
        }
        int length = MEM_KEYS.size();
        if (count != length) {
            String errMsg = String.format("Expect %d keys in the meminfo file. Got %d. content: %s", length, count, lines);
            logger.error(errMsg);
            totalFree = 0L;
        }
        return totalFree;
    }

    long parseMemoryLine(String line) {
        int idx1 = line.indexOf(":");
        int idx2 = line.lastIndexOf("kB");
        String sizeString = line.substring(idx1 + 1, idx2 - 1).trim();
        try {
            return Long.parseLong(sizeString);
        }
        catch (NumberFormatException e) {
            String err = "Failed to parse the meminfo file. Line: " + line;
            logger.error(err);
            return 0L;
        }
    }
}

