/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.CircularBuffer;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;

public class LogGobbler
extends Thread {
    private final BufferedReader inputReader;
    private final Logger logger;
    private final String loggingLevel;
    private final CircularBuffer<String> buffer;

    public LogGobbler(Reader inputReader, Logger logger, String level, int bufferLines) {
        this.inputReader = new BufferedReader(inputReader);
        this.logger = logger;
        this.loggingLevel = level;
        this.buffer = new CircularBuffer(bufferLines);
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                String line = this.inputReader.readLine();
                if (line == null) {
                    return;
                }
                this.buffer.append(line);
                this.log(line);
            }
        }
        catch (IOException e) {
            this.error("Error reading from logging stream:", e);
        }
    }

    private void log(String message) {
        if (this.logger != null) {
            switch (this.loggingLevel) {
                case "INFO": {
                    this.logger.info(message);
                    break;
                }
                case "DEBUG": {
                    this.logger.debug(message);
                    break;
                }
                case "ERROR": {
                    this.logger.error(message);
                    break;
                }
                case "WARN": {
                    this.logger.warn(message);
                    break;
                }
                default: {
                    this.logger.trace(message);
                }
            }
        }
    }

    private void error(String message, Exception e) {
        if (this.logger != null) {
            this.logger.error(message, (Throwable)e);
        }
    }

    private void info(String message, Exception e) {
        if (this.logger != null) {
            this.logger.info(message, (Throwable)e);
        }
    }

    public void awaitCompletion(long waitMs) {
        try {
            this.join(waitMs);
        }
        catch (InterruptedException e) {
            this.info("I/O thread interrupted.", e);
        }
    }

    public String getRecentLog() {
        return Joiner.on((String)System.getProperty("line.separator")).join(this.buffer);
    }
}

