/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteAsUser {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteAsUser.class);
    private static final String EXECUTE_AS_USER = "execute-as-user";
    private final File binaryExecutable;

    public ExecuteAsUser(String nativeLibDirectory) {
        this.binaryExecutable = new File(nativeLibDirectory, EXECUTE_AS_USER);
        this.validate();
    }

    private void validate() {
        if (!this.binaryExecutable.canExecute()) {
            throw new RuntimeException("Unable to execute execute-as-user binary. Invalid Path: " + this.binaryExecutable.getAbsolutePath());
        }
    }

    public int execute(String user, List<String> command) throws IOException {
        int exitCode;
        logger.info("Command: " + command);
        Process process = new ProcessBuilder(new String[0]).command(this.constructExecuteAsCommand(user, command)).inheritIO().start();
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            exitCode = 1;
        }
        return exitCode;
    }

    private List<String> constructExecuteAsCommand(String user, List<String> command) {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(this.binaryExecutable.getAbsolutePath());
        commandList.add(user);
        commandList.addAll(command);
        return commandList;
    }
}

